/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.units;

import java.util.Locale;

public class Quantity {
    private static Length.LengthUnit parseLength(String unit) throws IllegalArgumentException {
        if (unit.matches("[^\\[\\]]+\\[[^\\[\\]]+]")) {
            return Length.LengthUnit.valueOf(unit.substring(unit.indexOf(91) + 1, unit.indexOf(93)).toUpperCase(Locale.ROOT));
        }
        return Length.LengthUnit.valueOf(unit.toUpperCase(Locale.ROOT));
    }

    private static Angle.AngleUnit parseAngle(String unit) throws IllegalArgumentException {
        if (unit.matches("[^\\[\\]]+\\[[^\\[\\]]+]")) {
            return Angle.AngleUnit.valueOf(unit.substring(unit.indexOf(91) + 1, unit.indexOf(93)).toUpperCase(Locale.ROOT));
        }
        return Angle.AngleUnit.valueOf(unit.toUpperCase(Locale.ROOT));
    }

    private static Brightness.BrightnessUnit parseMag(String unit) throws IllegalArgumentException {
        if (unit.matches("[^\\[\\]]+\\[[^\\[\\]]+]")) {
            return Brightness.BrightnessUnit.valueOf(unit.substring(unit.indexOf(91) + 1, unit.indexOf(93)).toUpperCase(Locale.ROOT));
        }
        return Brightness.BrightnessUnit.valueOf(unit.toUpperCase(Locale.ROOT));
    }

    public static class Length {
        double value_m;

        public Length(double value, LengthUnit unit) {
            this.value_m = value * unit.m;
        }

        public Length(double value, String unit) {
            this(value, Quantity.parseLength(unit));
        }

        public static boolean isLength(String unit) {
            try {
                Quantity.parseLength(unit);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public double get(LengthUnit unit) {
            return this.value_m * (1.0 / unit.m);
        }

        public static enum LengthUnit {
            MM(0.001),
            CM(0.01),
            M(1.0),
            KM(1000.0),
            AU(1.495978707E11),
            LY(9.4607304725808E15),
            PC(3.08567758E16),
            KPC(3.08567758E19),
            MPC(3.08567758E22);

            final double m;

            private LengthUnit(double m) {
                this.m = m;
            }
        }
    }

    public static class Angle {
        double value_deg;

        public Angle(double value, AngleUnit unit) {
            this.value_deg = value * unit.deg;
        }

        public Angle(double value, String unit) {
            this(value, Quantity.parseAngle(unit));
        }

        public static boolean isAngle(String unit) {
            try {
                Quantity.parseAngle(unit);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public double get(AngleUnit unit) {
            return this.value_deg * (1.0 / unit.deg);
        }

        public Length getParallaxDistance() {
            double mas = this.get(AngleUnit.MAS);
            if (Double.isFinite(mas) && mas <= 0.0) {
                return new Length(-1.0, Length.LengthUnit.PC);
            }
            return new Length(1000.0 / mas, Length.LengthUnit.PC);
        }

        public static enum AngleUnit {
            DEG(1.0),
            RAD(57.29577951308232),
            MAS(2.7777777777777776E-7),
            ARCSEC(2.777777777777778E-4),
            ARCMIN(0.016666666666666666);

            final double deg;

            private AngleUnit(double deg) {
                this.deg = deg;
            }
        }
    }

    public static class Brightness {
        double value_mag;

        public Brightness(double value, BrightnessUnit unit) {
            this.value_mag = value * unit.mag;
        }

        public Brightness(double value, String unit) {
            this(value, Quantity.parseMag(unit));
        }

        public static boolean isBrightness(String unit) {
            try {
                Quantity.parseMag(unit);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public double get(BrightnessUnit unit) {
            return this.value_mag * (1.0 / unit.mag);
        }

        public static enum BrightnessUnit {
            MAG(1.0);

            final double mag;

            private BrightnessUnit(double mag) {
                this.mag = mag;
            }
        }
    }
}

