/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.update;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import gaiasky.util.Logger;
import gaiasky.util.parse.Parser;
import gaiasky.util.update.VersionCheckEvent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.TreeSet;

public class VersionChecker
implements Runnable {
    public static final int MAX_VERSION_NUMBER = 100000000;
    public static final int MIN_VERSION_NUMBER = 999999;
    private static final Logger.Log logger = Logger.getLogger(VersionChecker.class);
    private static final int VERSION_CHECK_TIMEOUT_MS = 5000;
    private final String stringUrl;
    private EventListener listener;

    public VersionChecker(String stringUrl) {
        this.stringUrl = stringUrl;
    }

    public static Integer stringToVersionNumber(String tag) {
        try {
            int v = 0;
            String[] tokens = tag.split("[.\\-]");
            if (tokens.length < 3) {
                logger.debug("Could not parse version '" + tag + "', assuming development or beta version");
                return 100000000;
            }
            String major = tokens[0];
            String minor = tokens[1];
            String rev = tokens[2];
            String seq = tokens.length > 3 ? tokens[3] : "00";
            v += Parser.parseInt(major) * 1000000;
            v += Parser.parseInt(minor) * 10000;
            v += Parser.parseInt(rev) * 100;
            return v += Parser.parseIntOrElse(seq, 0);
        }
        catch (Exception e) {
            logger.debug("Could not parse version '" + tag + "', assuming development or beta version");
            return 100000000;
        }
    }

    @Override
    public void run() {
        Net.HttpRequest request = new Net.HttpRequest("GET");
        request.setUrl(this.stringUrl);
        request.setTimeOut(5000);
        Gdx.net.sendHttpRequest(request, new Net.HttpResponseListener(){

            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                JsonReader reader = new JsonReader();
                TreeSet<VersionObject> tags = new TreeSet<VersionObject>();
                JsonValue result = reader.parse(httpResponse.getResultAsStream());
                int n = result.size;
                for (int i = 0; i < n; ++i) {
                    String tag = result.get(i).getString("name");
                    if (!tag.matches("^(\\D)?\\d+.\\d+(\\D{1})?(.\\d+)?(-\\d+)?$")) continue;
                    Integer version = VersionChecker.stringToVersionNumber(tag);
                    String commitDate = result.get(i).get("commit").getString("created");
                    DateTimeFormatter df = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
                    try {
                        LocalDateTime tagDate = LocalDateTime.parse(commitDate, df);
                        tags.add(new VersionObject(result.get(i), version, tagDate.toInstant(ZoneOffset.UTC)));
                        continue;
                    }
                    catch (DateTimeParseException e) {
                        logger.error(e, "Can't parse datetime: " + commitDate);
                    }
                }
                if (!tags.isEmpty()) {
                    VersionObject newest = null;
                    for (VersionObject tag : tags) {
                        if (newest != null && !tag.created.isAfter(newest.created)) continue;
                        newest = tag;
                    }
                    VersionChecker.this.listener.handle((Event)new VersionCheckEvent(newest.json.getString("name"), newest.version, newest.created));
                }
            }

            public void failed(Throwable t) {
                VersionChecker.this.listener.handle((Event)new VersionCheckEvent(true));
            }

            public void cancelled() {
                VersionChecker.this.listener.handle((Event)new VersionCheckEvent(true));
            }
        });
    }

    public void setListener(EventListener listener) {
        this.listener = listener;
    }

    public static int correctVersionNumber(int versionNumber) {
        if (versionNumber > 0 && versionNumber <= 999999) {
            versionNumber *= 100;
        }
        return versionNumber;
    }

    private static class VersionObject
    implements Comparable<VersionObject> {
        JsonValue json;
        Integer version;
        Instant created;

        public VersionObject(JsonValue value, Integer version, Instant created) {
            this.json = value;
            this.version = version;
            this.created = created;
        }

        @Override
        public int compareTo(VersionObject versionObject) {
            return this.version.compareTo(versionObject.version);
        }
    }
}

