/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.validator;

import gaiasky.util.validator.IValidator;

public abstract class CallbackValidator
implements IValidator {
    private Runnable isValidCallback;
    private Runnable isInvalidCallback;
    private IValidator parent;

    protected CallbackValidator() {
    }

    protected CallbackValidator(IValidator parent) {
        this.parent = parent;
    }

    public void setIsValidCallback(Runnable isValidCallback) {
        this.isValidCallback = isValidCallback;
    }

    public void setIsInvalidCallback(Runnable isInvalidCallback) {
        this.isInvalidCallback = isInvalidCallback;
    }

    protected void runIsValidCallback() {
        if (this.isValidCallback != null) {
            this.isValidCallback.run();
        }
    }

    protected void runIsInvalidCallback() {
        if (this.isInvalidCallback != null) {
            this.isInvalidCallback.run();
        }
    }

    public IValidator getParent() {
        return this.parent;
    }

    @Override
    public boolean validate(String value) {
        boolean valid = this.validateLocal(value);
        if (valid) {
            this.runIsValidCallback();
        } else {
            this.runIsInvalidCallback();
        }
        return valid && (this.parent == null || this.parent.validate(value));
    }

    protected abstract boolean validateLocal(String var1);
}

