/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.validator;

import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.validator.IValidator;
import gaiasky.util.validator.NumberValidator;

public class DoubleValidator
extends NumberValidator<Double> {
    public DoubleValidator(double min, double max) {
        super(null, min, max);
    }

    public DoubleValidator(IValidator parent, double min, double max) {
        super(parent, min, max);
    }

    @Override
    protected boolean validateLocal(String value) {
        double val;
        try {
            val = Parser.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return val >= (Double)this.min && val <= (Double)this.max;
    }

    @Override
    public String getMinString() {
        return (Double)this.min == Double.MIN_VALUE ? I18n.msg("gui.infinity.minus") : Double.toString((Double)this.min);
    }

    @Override
    public String getMaxString() {
        return (Double)this.max == Double.MAX_VALUE ? I18n.msg("gui.infinity") : Double.toString((Double)this.max);
    }
}

