/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.validator;

import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.validator.IValidator;
import gaiasky.util.validator.NumberValidator;

public class FloatValidator
extends NumberValidator<Float> {
    public FloatValidator(float min, float max) {
        super(null, Float.valueOf(min), Float.valueOf(max));
    }

    public FloatValidator(IValidator parent, float min, float max) {
        super(parent, Float.valueOf(min), Float.valueOf(max));
    }

    @Override
    protected boolean validateLocal(String value) {
        float val;
        try {
            val = Parser.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return val >= ((Float)this.min).floatValue() && val <= ((Float)this.max).floatValue();
    }

    @Override
    public String getMinString() {
        return ((Float)this.min).floatValue() == Float.MIN_VALUE ? I18n.msg("gui.infinity.minus") : Float.toString(((Float)this.min).floatValue());
    }

    @Override
    public String getMaxString() {
        return ((Float)this.max).floatValue() == Float.MAX_VALUE ? I18n.msg("gui.infinity") : Float.toString(((Float)this.max).floatValue());
    }
}

