/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.validator;

import gaiasky.util.i18n.I18n;
import gaiasky.util.validator.IValidator;
import gaiasky.util.validator.NumberValidator;

public class IntValidator
extends NumberValidator<Integer> {
    public IntValidator() {
        this(null);
    }

    public IntValidator(IValidator parent) {
        super(parent, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntValidator(int min, int max) {
        super(null, min, max);
    }

    @Override
    protected boolean validateLocal(String value) {
        int val;
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return val >= (Integer)this.min && val <= (Integer)this.max;
    }

    @Override
    public String getMinString() {
        return (Integer)this.min == Integer.MIN_VALUE ? I18n.msg("gui.infinity.minus") : Integer.toString((Integer)this.min);
    }

    @Override
    public String getMaxString() {
        return (Integer)this.max == Integer.MAX_VALUE ? I18n.msg("gui.infinity") : Integer.toString((Integer)this.max);
    }
}

