/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.validator;

import gaiasky.util.i18n.I18n;
import gaiasky.util.validator.IValidator;
import gaiasky.util.validator.NumberValidator;

public class LongValidator
extends NumberValidator<Long> {
    public LongValidator() {
        this(null);
    }

    public LongValidator(IValidator parent) {
        super(parent, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LongValidator(long min, long max) {
        super(null, min, max);
    }

    public LongValidator(IValidator parent, long min, long max) {
        super(parent, min, max);
    }

    @Override
    protected boolean validateLocal(String value) {
        long val;
        try {
            val = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return val >= (Long)this.min && val <= (Long)this.max;
    }

    @Override
    public String getMinString() {
        return (Long)this.min == Long.MIN_VALUE ? I18n.msg("gui.infinity.minus") : Long.toString((Long)this.min);
    }

    @Override
    public String getMaxString() {
        return (Long)this.max == Long.MAX_VALUE ? I18n.msg("gui.infinity") : Long.toString((Long)this.max);
    }
}

