/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.validator;

import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.CallbackValidator;
import gaiasky.util.validator.IValidator;

public class TextFieldComparatorValidator
extends CallbackValidator {
    private final OwnTextField[] lessThan;
    private final OwnTextField[] greaterThan;

    public TextFieldComparatorValidator(IValidator parent, OwnTextField[] lessThan, OwnTextField[] greaterThan) {
        super(parent);
        this.lessThan = lessThan;
        this.greaterThan = greaterThan;
    }

    @Override
    protected boolean validateLocal(String value) {
        try {
            float v;
            float val = Parser.parseFloatException(value);
            if (this.lessThan != null) {
                for (OwnTextField tf : this.lessThan) {
                    v = Parser.parseFloatException(tf.getText());
                    if (!(val >= v)) continue;
                    return false;
                }
            }
            if (this.greaterThan != null) {
                for (OwnTextField tf : this.greaterThan) {
                    v = Parser.parseFloatException(tf.getText());
                    if (!(val <= v)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

