/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr;

import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.vr.openxr.XrHelper;
import gaiasky.vr.openxr.XrRenderer;
import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.XrInputListener;
import gaiasky.vr.openxr.input.actions.Action;
import gaiasky.vr.openxr.input.actionsets.GaiaSkyActionSet;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL30;
import org.lwjgl.openxr.EXTDebugUtils;
import org.lwjgl.openxr.KHROpenGLEnable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionSuggestedBinding;
import org.lwjgl.openxr.XrActionsSyncInfo;
import org.lwjgl.openxr.XrActiveActionSet;
import org.lwjgl.openxr.XrApiLayerProperties;
import org.lwjgl.openxr.XrApplicationInfo;
import org.lwjgl.openxr.XrCompositionLayerProjection;
import org.lwjgl.openxr.XrCompositionLayerProjectionView;
import org.lwjgl.openxr.XrDebugUtilsMessengerCallbackDataEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerEXT;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.openxr.XrEventDataBuffer;
import org.lwjgl.openxr.XrEventDataEventsLost;
import org.lwjgl.openxr.XrEventDataInstanceLossPending;
import org.lwjgl.openxr.XrEventDataSessionStateChanged;
import org.lwjgl.openxr.XrExtensionProperties;
import org.lwjgl.openxr.XrFrameBeginInfo;
import org.lwjgl.openxr.XrFrameEndInfo;
import org.lwjgl.openxr.XrFrameState;
import org.lwjgl.openxr.XrFrameWaitInfo;
import org.lwjgl.openxr.XrGraphicsRequirementsOpenGLKHR;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrInstanceCreateInfo;
import org.lwjgl.openxr.XrInstanceProperties;
import org.lwjgl.openxr.XrInteractionProfileSuggestedBinding;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrReferenceSpaceCreateInfo;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSessionActionSetsAttachInfo;
import org.lwjgl.openxr.XrSessionBeginInfo;
import org.lwjgl.openxr.XrSessionCreateInfo;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.openxr.XrSwapchainCreateInfo;
import org.lwjgl.openxr.XrSwapchainImageAcquireInfo;
import org.lwjgl.openxr.XrSwapchainImageBaseHeader;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;
import org.lwjgl.openxr.XrSwapchainImageReleaseInfo;
import org.lwjgl.openxr.XrSwapchainImageWaitInfo;
import org.lwjgl.openxr.XrSystemGetInfo;
import org.lwjgl.openxr.XrSystemGraphicsProperties;
import org.lwjgl.openxr.XrSystemProperties;
import org.lwjgl.openxr.XrSystemTrackingProperties;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.openxr.XrView;
import org.lwjgl.openxr.XrViewConfigurationView;
import org.lwjgl.openxr.XrViewLocateInfo;
import org.lwjgl.openxr.XrViewState;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import oshi.util.tuples.Pair;

public class XrDriver
implements Disposable {
    private static final Logger.Log logger = Logger.getLogger(XrDriver.class);
    public long systemId;
    public boolean missingXrDebug;
    public String runtimeName;
    public String runtimeVersionString;
    public String hmdName;
    public String systemString;
    public long runtimeVersion;
    public XrInstance xrInstance;
    public XrSession xrSession;
    public XrDebugUtilsMessengerEXT xrDebugMessenger;
    public XrSpace xrAppSpace;
    private long glColorFormat;
    public XrView.Buffer views;
    private Array<XrControllerDevice> devices;
    private GaiaSkyActionSet actions;
    private final Array<XrInputListener> listeners = new Array();
    public SwapChain[] swapChains;
    public XrViewConfigurationView.Buffer viewConfigs;
    public final int viewConfigType = 2;
    private FrameBuffer[] viewFrameBuffers;
    private final AtomicReference<XrRenderer> currentRenderer = new AtomicReference();
    XrEventDataBuffer eventDataBuffer;
    int sessionState;
    boolean sessionRunning;
    boolean disposing = false;
    public long currentFrameTime = 0L;
    private boolean lastPollResult = false;

    public void createOpenXRInstance() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer wantedLayers;
            IntBuffer pi = stack.mallocInt(1);
            boolean hasCoreValidationLayer = false;
            this.check(XR10.xrEnumerateApiLayerProperties((IntBuffer)pi, null));
            int numLayers = pi.get(0);
            XrApiLayerProperties.Buffer pLayers = XrHelper.prepareApiLayerProperties(stack, numLayers);
            this.check(XR10.xrEnumerateApiLayerProperties((IntBuffer)pi, (XrApiLayerProperties.Buffer)pLayers));
            for (int index = 0; index < numLayers; ++index) {
                XrApiLayerProperties layer = (XrApiLayerProperties)pLayers.get(index);
                String layerName = layer.layerNameString();
                logger.info(I18n.msg("vr.init.layer", layerName));
                if (!layerName.equals("XR_APILAYER_LUNARG_core_validation")) continue;
                hasCoreValidationLayer = true;
            }
            logger.info(I18n.msg("vr.init.layers", numLayers));
            this.check(XR10.xrEnumerateInstanceExtensionProperties((ByteBuffer)null, (IntBuffer)pi, null));
            int numExtensions = pi.get(0);
            XrExtensionProperties.Buffer properties = XrHelper.prepareExtensionProperties(stack, numExtensions);
            this.check(XR10.xrEnumerateInstanceExtensionProperties((ByteBuffer)null, (IntBuffer)pi, (XrExtensionProperties.Buffer)properties));
            PointerBuffer wantedExtensions = stack.mallocPointer(2);
            boolean missingOpenGL = true;
            this.missingXrDebug = true;
            for (int i = 0; i < numExtensions; ++i) {
                XrExtensionProperties prop = (XrExtensionProperties)properties.get(i);
                String extensionName = prop.extensionNameString();
                logger.info(I18n.msg("vr.init.extension", extensionName));
                if (extensionName.equals("XR_KHR_opengl_enable")) {
                    missingOpenGL = false;
                    wantedExtensions.put(prop.extensionName());
                }
                if (!extensionName.equals("XR_EXT_debug_utils")) continue;
                this.missingXrDebug = false;
                wantedExtensions.put(prop.extensionName());
            }
            wantedExtensions.flip();
            logger.info(I18n.msg("vr.init.extensions", numExtensions));
            if (missingOpenGL) {
                throw new IllegalStateException("OpenXR runtime does not provide required extension: XR_KHR_opengl_enable");
            }
            if (hasCoreValidationLayer) {
                wantedLayers = stack.callocPointer(1);
                wantedLayers.put(0, stack.UTF8((CharSequence)"XR_APILAYER_LUNARG_core_validation"));
                logger.info(I18n.msg("vr.enable.validation"));
            } else {
                wantedLayers = null;
            }
            XrInstanceCreateInfo createInfo = XrInstanceCreateInfo.malloc((MemoryStack)stack).type$Default().next(0L).createFlags(0L).applicationInfo(XrApplicationInfo.calloc((MemoryStack)stack).applicationName(stack.UTF8((CharSequence)Settings.getApplicationName(false))).apiVersion(XR10.XR_CURRENT_API_VERSION)).enabledApiLayerNames(wantedLayers).enabledExtensionNames(wantedExtensions);
            PointerBuffer pp = stack.mallocPointer(1);
            this.check(XR10.xrCreateInstance((XrInstanceCreateInfo)createInfo, (PointerBuffer)pp));
            this.xrInstance = new XrInstance(pp.get(0), createInfo);
        }
    }

    public void initializeXRSystem() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer pl = stack.longs(0L);
            XrInstanceProperties properties = XrInstanceProperties.calloc((MemoryStack)stack).type$Default();
            this.check(XR10.xrGetInstanceProperties((XrInstance)this.xrInstance, (XrInstanceProperties)properties));
            this.runtimeName = properties.runtimeNameString();
            this.runtimeVersion = properties.runtimeVersion();
            this.runtimeVersionString = XR10.XR_VERSION_MAJOR((long)this.runtimeVersion) + "." + XR10.XR_VERSION_MINOR((long)this.runtimeVersion) + "." + XR10.XR_VERSION_PATCH((long)this.runtimeVersion);
            logger.info(I18n.msg("vr.runtime.name", this.runtimeName));
            logger.info(I18n.msg("vr.runtime.version", this.runtimeVersionString));
            this.check(XR10.xrGetSystem((XrInstance)this.xrInstance, (XrSystemGetInfo)XrSystemGetInfo.malloc((MemoryStack)stack).type$Default().next(0L).formFactor(1), (LongBuffer)pl));
            this.systemId = pl.get(0);
            if (this.systemId == 0L) {
                throw new IllegalStateException("No compatible headset detected");
            }
            logger.info(I18n.msg("vr.system", this.systemId));
        }
    }

    public XrGraphicsRequirementsOpenGLKHR getXrGraphicsRequirements(MemoryStack stack) {
        XrGraphicsRequirementsOpenGLKHR graphicsRequirements = XrGraphicsRequirementsOpenGLKHR.malloc((MemoryStack)stack).type$Default().next(0L).minApiVersionSupported(0L).maxApiVersionSupported(0L);
        KHROpenGLEnable.xrGetOpenGLGraphicsRequirementsKHR((XrInstance)this.xrInstance, (long)this.systemId, (XrGraphicsRequirementsOpenGLKHR)graphicsRequirements);
        return graphicsRequirements;
    }

    public void checkOpenGL() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrGraphicsRequirementsOpenGLKHR graphicsRequirements = this.getXrGraphicsRequirements(stack);
            if (!GLFW.glfwInit()) {
                throw new IllegalStateException("GLFW is not initialized!");
            }
            int actualMajorVersion = GL30.glGetInteger((int)33307);
            int actualMinorVersion = GL30.glGetInteger((int)33308);
            short minMajorVersion = XR10.XR_VERSION_MAJOR((long)graphicsRequirements.minApiVersionSupported());
            short minMinorVersion = XR10.XR_VERSION_MINOR((long)graphicsRequirements.minApiVersionSupported());
            short maxMajorVersion = XR10.XR_VERSION_MAJOR((long)graphicsRequirements.maxApiVersionSupported());
            short maxMinorVersion = XR10.XR_VERSION_MINOR((long)graphicsRequirements.maxApiVersionSupported());
            if (minMajorVersion > actualMajorVersion || minMajorVersion == actualMajorVersion && minMinorVersion > actualMinorVersion) {
                throw new IllegalStateException("The OpenXR runtime supports only OpenGL " + minMajorVersion + "." + minMinorVersion + " and later, but we got OpenGL " + actualMajorVersion + "." + actualMinorVersion);
            }
            if (actualMajorVersion > maxMajorVersion || actualMajorVersion == maxMajorVersion && actualMinorVersion > maxMinorVersion) {
                throw new IllegalStateException("The OpenXR runtime supports only OpenGL " + maxMajorVersion + "." + minMajorVersion + " and earlier, but we got OpenGL " + actualMajorVersion + "." + actualMinorVersion);
            }
        }
    }

    public void initializeOpenXRSession(long windowHandle) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            Struct graphicsBinding = XrHelper.createOpenGLBinding(stack, windowHandle);
            XrSessionCreateInfo sessionCreateInfo = XrSessionCreateInfo.calloc((MemoryStack)stack).set(8, graphicsBinding.address(), 0L, this.systemId);
            PointerBuffer pp = stack.mallocPointer(1);
            this.check(XR10.xrCreateSession((XrInstance)this.xrInstance, (XrSessionCreateInfo)sessionCreateInfo, (PointerBuffer)pp));
            this.xrSession = new XrSession(pp.get(0), this.xrInstance);
            if (!this.missingXrDebug) {
                XrDebugUtilsMessengerCreateInfoEXT ciDebugUtils = XrDebugUtilsMessengerCreateInfoEXT.calloc((MemoryStack)stack).type$Default().messageSeverities(4368L).messageTypes(15L).userCallback((messageSeverity, messageTypes, pCallbackData, userData) -> {
                    XrDebugUtilsMessengerCallbackDataEXT callbackData = XrDebugUtilsMessengerCallbackDataEXT.create((long)pCallbackData);
                    logger.info(I18n.msg("vr.debug.utils", callbackData.messageString()));
                    callbackData.close();
                    return 0;
                });
                logger.info(I18n.msg("vr.enable.debug"));
                this.check(EXTDebugUtils.xrCreateDebugUtilsMessengerEXT((XrInstance)this.xrInstance, (XrDebugUtilsMessengerCreateInfoEXT)ciDebugUtils, (PointerBuffer)pp));
                this.xrDebugMessenger = new XrDebugUtilsMessengerEXT(pp.get(0), this.xrInstance);
            }
        }
    }

    public void createOpenXRReferenceSpace() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            this.check(XR10.xrCreateReferenceSpace((XrSession)this.xrSession, (XrReferenceSpaceCreateInfo)XrReferenceSpaceCreateInfo.malloc((MemoryStack)stack).type$Default().next(0L).referenceSpaceType(2).poseInReferenceSpace(XrPosef.malloc((MemoryStack)stack).orientation(XrQuaternionf.malloc((MemoryStack)stack).x(0.0f).y(0.0f).z(0.0f).w(1.0f)).position$(XrVector3f.calloc((MemoryStack)stack))), (PointerBuffer)pp));
            this.xrAppSpace = new XrSpace(pp.get(0), this.xrSession);
        }
    }

    public void createOpenXRSwapchains() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrSystemProperties systemProperties = XrSystemProperties.calloc((MemoryStack)stack);
            MemoryUtil.memPutInt((long)systemProperties.address(), (int)5);
            this.check(XR10.xrGetSystemProperties((XrInstance)this.xrInstance, (long)this.systemId, (XrSystemProperties)systemProperties));
            this.hmdName = MemoryUtil.memUTF8((long)MemoryUtil.memAddress((ByteBuffer)systemProperties.systemName()));
            this.systemString = systemProperties.systemNameString();
            logger.info(I18n.msg("vr.name", this.hmdName));
            logger.info(I18n.msg("vr.vendor", systemProperties.vendorId()));
            logger.info(I18n.msg("vr.system.string", this.systemString));
            XrSystemTrackingProperties trackingProperties = systemProperties.trackingProperties();
            logger.info(I18n.msg("vr.orientation", trackingProperties.orientationTracking()));
            logger.info(I18n.msg("vr.position", trackingProperties.positionTracking()));
            XrSystemGraphicsProperties graphicsProperties = systemProperties.graphicsProperties();
            logger.info(I18n.msg("vr.width", graphicsProperties.maxSwapchainImageWidth()));
            logger.info(I18n.msg("vr.height", graphicsProperties.maxSwapchainImageHeight()));
            logger.info(I18n.msg("vr.layer", graphicsProperties.maxLayerCount()));
            IntBuffer pi = stack.mallocInt(1);
            this.check(XR10.xrEnumerateViewConfigurationViews((XrInstance)this.xrInstance, (long)this.systemId, (int)2, (IntBuffer)pi, null));
            this.viewConfigs = XrHelper.fill(XrViewConfigurationView.calloc((int)pi.get(0)), XrViewConfigurationView.TYPE, 41);
            this.check(XR10.xrEnumerateViewConfigurationViews((XrInstance)this.xrInstance, (long)this.systemId, (int)2, (IntBuffer)pi, (XrViewConfigurationView.Buffer)this.viewConfigs));
            int viewCountNumber = pi.get(0);
            this.views = XrHelper.fill(XrView.calloc((int)viewCountNumber), XrView.TYPE, 7);
            if (viewCountNumber > 0) {
                long[] desiredSwapchainFormats;
                this.check(XR10.xrEnumerateSwapchainFormats((XrSession)this.xrSession, (IntBuffer)pi, null));
                LongBuffer swapchainFormats = stack.mallocLong(pi.get(0));
                this.check(XR10.xrEnumerateSwapchainFormats((XrSession)this.xrSession, (IntBuffer)pi, (LongBuffer)swapchainFormats));
                block5: for (long glFormatIter : desiredSwapchainFormats = new long[]{35907L, 32857L, 34842L, 32856L, 36759L}) {
                    for (int i = 0; i < swapchainFormats.limit(); ++i) {
                        if (glFormatIter != swapchainFormats.get(i)) continue;
                        this.glColorFormat = glFormatIter;
                        break block5;
                    }
                }
                if (this.glColorFormat == 0L) {
                    throw new IllegalStateException("No compatible swapchain / framebuffer format available");
                }
                this.swapChains = new SwapChain[viewCountNumber];
                for (int i = 0; i < viewCountNumber; ++i) {
                    XrViewConfigurationView viewConfig = (XrViewConfigurationView)this.viewConfigs.get(i);
                    SwapChain swapchainWrapper = new SwapChain();
                    XrSwapchainCreateInfo swapchainCreateInfo = XrSwapchainCreateInfo.malloc((MemoryStack)stack).type$Default().next(0L).createFlags(0L).usageFlags(33L).format(this.glColorFormat).sampleCount(viewConfig.recommendedSwapchainSampleCount()).width(viewConfig.recommendedImageRectWidth()).height(viewConfig.recommendedImageRectHeight()).faceCount(1).arraySize(1).mipCount(1);
                    PointerBuffer pp = stack.mallocPointer(1);
                    this.check(XR10.xrCreateSwapchain((XrSession)this.xrSession, (XrSwapchainCreateInfo)swapchainCreateInfo, (PointerBuffer)pp));
                    swapchainWrapper.handle = new XrSwapchain(pp.get(0), this.xrSession);
                    swapchainWrapper.width = swapchainCreateInfo.width();
                    swapchainWrapper.height = swapchainCreateInfo.height();
                    this.check(XR10.xrEnumerateSwapchainImages((XrSwapchain)swapchainWrapper.handle, (IntBuffer)pi, null));
                    int imageCount = pi.get(0);
                    XrSwapchainImageOpenGLKHR.Buffer swapchainImageBuffer = XrHelper.fill(XrSwapchainImageOpenGLKHR.create((int)imageCount), XrSwapchainImageOpenGLKHR.TYPE, 1000023004);
                    this.check(XR10.xrEnumerateSwapchainImages((XrSwapchain)swapchainWrapper.handle, (IntBuffer)pi, (XrSwapchainImageBaseHeader.Buffer)XrSwapchainImageBaseHeader.create((long)swapchainImageBuffer.address(), (int)swapchainImageBuffer.capacity())));
                    swapchainWrapper.images = swapchainImageBuffer;
                    this.swapChains[i] = swapchainWrapper;
                }
            }
        }
    }

    public void initializeOpenGLFrameBuffers() {
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(this.getWidth(), this.getHeight());
        int internalFormat = 32856;
        if (Settings.settings.graphics.useSRGB) {
            internalFormat = 35907;
        }
        frameBufferBuilder.addColorTextureAttachment(internalFormat, 6408, 5121);
        frameBufferBuilder.addBasicDepthRenderBuffer();
        int count = this.swapChains.length;
        this.viewFrameBuffers = new FrameBuffer[count];
        for (int view = 0; view < count; ++view) {
            this.viewFrameBuffers[view] = frameBufferBuilder.build();
        }
    }

    public void initializeInput() {
        XrControllerDevice deviceLeft = new XrControllerDevice(XrControllerDevice.DeviceType.Left);
        XrControllerDevice deviceRight = new XrControllerDevice(XrControllerDevice.DeviceType.Right);
        this.devices = new Array();
        this.devices.add((Object)deviceLeft, (Object)deviceRight);
        this.eventDataBuffer = XrEventDataBuffer.calloc().type$Default();
        this.actions = new GaiaSkyActionSet(deviceLeft, deviceRight);
        this.actions.createHandle(this);
        HashMap<String, List<Pair<Action, String>>> bindingsMap = new HashMap<String, List<Pair<Action, String>>>();
        this.actions.getDefaultBindings(bindingsMap);
        try (MemoryStack stack = MemoryStack.stackPush();){
            Set<String> devices = bindingsMap.keySet();
            for (String device : devices) {
                List<Pair<Action, String>> bindings = bindingsMap.get(device);
                XrActionSuggestedBinding.Buffer bindingsBuffer = XrActionSuggestedBinding.calloc((int)bindings.size(), (MemoryStack)stack);
                int l = 0;
                for (Pair<Action, String> binding : bindings) {
                    ((XrActionSuggestedBinding)bindingsBuffer.get(l++)).set(((Action)binding.getA()).getHandle(), this.getPath((String)binding.getB()));
                }
                XrInteractionProfileSuggestedBinding suggestedBinding = XrInteractionProfileSuggestedBinding.malloc((MemoryStack)stack).type$Default().next(0L).interactionProfile(this.getPath(device)).suggestedBindings(bindingsBuffer);
                this.check(XR10.xrSuggestInteractionProfileBindings((XrInstance)this.xrInstance, (XrInteractionProfileSuggestedBinding)suggestedBinding));
            }
            XrSessionActionSetsAttachInfo attachInfo = XrSessionActionSetsAttachInfo.calloc((MemoryStack)stack).set(60, 0L, MemoryStack.stackPointers((Pointer)this.actions.getHandle()));
            this.check(XR10.xrAttachSessionActionSets((XrSession)this.xrSession, (XrSessionActionSetsAttachInfo)attachInfo));
        }
    }

    private XrFrameState getFrameState(MemoryStack stack) {
        XrFrameState frameState = XrFrameState.calloc((MemoryStack)stack).type$Default();
        this.check(XR10.xrWaitFrame((XrSession)this.xrSession, (XrFrameWaitInfo)XrFrameWaitInfo.calloc((MemoryStack)stack).type$Default(), (XrFrameState)frameState));
        return frameState;
    }

    public void renderFrameOpenXR() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrFrameState frameState = this.getFrameState(stack);
            this.check(XR10.xrBeginFrame((XrSession)this.xrSession, (XrFrameBeginInfo)XrFrameBeginInfo.calloc((MemoryStack)stack).type$Default()));
            XrCompositionLayerProjection layerProjection = XrCompositionLayerProjection.calloc((MemoryStack)stack).type$Default();
            PointerBuffer layers = stack.callocPointer(1);
            boolean didRender = false;
            this.currentFrameTime = frameState.predictedDisplayTime();
            if (frameState.shouldRender() && this.renderLayerOpenXR(stack, this.currentFrameTime, layerProjection)) {
                layers.put(0, layerProjection.address());
                didRender = true;
            }
            this.check(XR10.xrEndFrame((XrSession)this.xrSession, (XrFrameEndInfo)XrFrameEndInfo.malloc((MemoryStack)stack).type$Default().next(0L).displayTime(this.currentFrameTime).environmentBlendMode(1).layers(layers).layerCount(didRender ? layers.remaining() : 0)));
        }
    }

    private boolean renderLayerOpenXR(MemoryStack stack, long predictedDisplayTime, XrCompositionLayerProjection layer) {
        XrViewState viewState = XrViewState.calloc((MemoryStack)stack).type$Default();
        IntBuffer pi = stack.mallocInt(1);
        this.check(XR10.xrLocateViews((XrSession)this.xrSession, (XrViewLocateInfo)XrViewLocateInfo.malloc((MemoryStack)stack).type$Default().next(0L).viewConfigurationType(2).displayTime(predictedDisplayTime).space(this.xrAppSpace), (XrViewState)viewState, (IntBuffer)pi, (XrView.Buffer)this.views));
        if ((viewState.viewStateFlags() & 2L) == 0L || (viewState.viewStateFlags() & 1L) == 0L) {
            return false;
        }
        int viewCountOutput = pi.get(0);
        assert (viewCountOutput == this.views.capacity());
        assert (viewCountOutput == this.viewConfigs.capacity());
        assert (viewCountOutput == this.swapChains.length);
        XrCompositionLayerProjectionView.Buffer projectionLayerViews = XrHelper.fill(XrCompositionLayerProjectionView.calloc((int)viewCountOutput, (MemoryStack)stack), XrCompositionLayerProjectionView.TYPE, 48);
        for (int viewIndex = 0; viewIndex < viewCountOutput; ++viewIndex) {
            SwapChain viewSwapchain = this.swapChains[viewIndex];
            this.check(XR10.xrAcquireSwapchainImage((XrSwapchain)viewSwapchain.handle, (XrSwapchainImageAcquireInfo)XrSwapchainImageAcquireInfo.calloc((MemoryStack)stack).type$Default(), (IntBuffer)pi));
            int swapchainImageIndex = pi.get(0);
            this.check(XR10.xrWaitSwapchainImage((XrSwapchain)viewSwapchain.handle, (XrSwapchainImageWaitInfo)XrSwapchainImageWaitInfo.malloc((MemoryStack)stack).type$Default().next(0L).timeout(Long.MAX_VALUE)));
            XrCompositionLayerProjectionView projectionLayerView = ((XrCompositionLayerProjectionView)projectionLayerViews.get(viewIndex)).pose(((XrView)this.views.get(viewIndex)).pose()).fov(((XrView)this.views.get(viewIndex)).fov()).subImage(si -> si.swapchain(viewSwapchain.handle).imageRect(rect -> rect.offset(offset -> offset.x(0).y(0)).extent(extent -> extent.width(viewSwapchain.width).height(viewSwapchain.height))));
            if (this.currentRenderer.get() != null) {
                this.currentRenderer.get().renderOpenXRView(projectionLayerView, (XrSwapchainImageOpenGLKHR)viewSwapchain.images.get(swapchainImageIndex), this.viewFrameBuffers == null ? null : this.viewFrameBuffers[viewIndex], viewIndex);
            }
            this.check(XR10.xrReleaseSwapchainImage((XrSwapchain)viewSwapchain.handle, (XrSwapchainImageReleaseInfo)XrSwapchainImageReleaseInfo.calloc((MemoryStack)stack).type$Default()));
        }
        layer.space(this.xrAppSpace);
        layer.views(projectionLayerViews);
        return true;
    }

    public long getPath(String name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer path = stack.longs(0L);
            this.check(XR10.xrStringToPath((XrInstance)this.xrInstance, (ByteBuffer)stack.UTF8((CharSequence)name), (LongBuffer)path));
            long l = path.get();
            return l;
        }
    }

    public boolean getLastPollEventsResult() {
        return this.lastPollResult;
    }

    public boolean pollEvents() {
        this.lastPollResult = this.pollEventsInternal();
        return this.lastPollResult;
    }

    private boolean pollEventsInternal() {
        if (!this.disposing) {
            XrEventDataBaseHeader event = this.readNextOpenXREvent();
            while (event != null) {
                switch (event.type()) {
                    case 17: {
                        XrEventDataInstanceLossPending instanceLossPending = XrEventDataInstanceLossPending.create((long)event.address());
                        logger.error("XrEventDataInstanceLossPending by " + instanceLossPending.lossTime());
                        instanceLossPending.close();
                        return true;
                    }
                    case 18: {
                        XrEventDataSessionStateChanged sessionStateChangedEvent = XrEventDataSessionStateChanged.create((long)event.address());
                        return this.OpenXRHandleSessionStateChangedEvent(sessionStateChangedEvent);
                    }
                    case 52: {
                        break;
                    }
                    default: {
                        logger.info("Ignoring event type " + event.type());
                    }
                }
                event.close();
                event = this.readNextOpenXREvent();
            }
            this.pollInput();
        }
        return false;
    }

    private void pollInput() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActiveActionSet.Buffer sets = XrActiveActionSet.calloc((int)1, (MemoryStack)stack);
            sets.actionSet(this.actions.getHandle());
            XrActionsSyncInfo syncInfo = XrActionsSyncInfo.calloc((MemoryStack)stack).type(61).activeActionSets(sets);
            this.check(XR10.xrSyncActions((XrSession)this.xrSession, (XrActionsSyncInfo)syncInfo));
            if (this.actions != null) {
                this.actions.sync(this);
                GaiaSkyActionSet gsActions = this.actions;
                for (XrInputListener listener : this.listeners) {
                    gsActions.processListener(listener);
                }
            }
        }
    }

    boolean OpenXRHandleSessionStateChangedEvent(XrEventDataSessionStateChanged stateChangedEvent) {
        int oldState = this.sessionState;
        this.sessionState = stateChangedEvent.state();
        logger.debug("XrEventDataSessionStateChanged: state " + oldState + "->" + this.sessionState + " session=" + stateChangedEvent.session() + " time=" + stateChangedEvent.time());
        if (stateChangedEvent.session() != 0L && stateChangedEvent.session() != this.xrSession.address()) {
            logger.error("XrEventDataSessionStateChanged for unknown session");
            return false;
        }
        switch (this.sessionState) {
            case 2: {
                assert (this.xrSession != null);
                try (MemoryStack stack = MemoryStack.stackPush();){
                    this.check(XR10.xrBeginSession((XrSession)this.xrSession, (XrSessionBeginInfo)XrSessionBeginInfo.malloc((MemoryStack)stack).type$Default().next(0L).primaryViewConfigurationType(2)));
                    this.sessionRunning = true;
                    boolean bl = false;
                    return bl;
                }
            }
            case 6: {
                assert (this.xrSession != null);
                this.sessionRunning = false;
                this.check(XR10.xrEndSession((XrSession)this.xrSession));
                return false;
            }
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private XrEventDataBaseHeader readNextOpenXREvent() {
        this.eventDataBuffer.clear();
        this.eventDataBuffer.type$Default();
        int result = XR10.xrPollEvent((XrInstance)this.xrInstance, (XrEventDataBuffer)this.eventDataBuffer);
        if (result == 0) {
            if (this.eventDataBuffer.type() == 49) {
                try (XrEventDataEventsLost dataEventsLost = XrEventDataEventsLost.create((long)this.eventDataBuffer.address());){
                    logger.debug(dataEventsLost.lostEventCount() + " events lost");
                }
            }
            return XrEventDataBaseHeader.create((long)this.eventDataBuffer.address());
        }
        if (result == 4) {
            return null;
        }
        throw new IllegalStateException(String.format("[XrResult failure %d in xrPollEvent]", result));
    }

    public void dispose() {
        logger.info("Disposing OpenXR context.");
        this.disposing = true;
        this.sessionRunning = false;
        this.disposeInput();
        if (this.eventDataBuffer != null) {
            this.eventDataBuffer.free();
        }
        if (this.views != null) {
            this.views.free();
        }
        if (this.viewConfigs != null) {
            this.viewConfigs.free();
        }
        if (this.swapChains != null) {
            for (SwapChain swapChain : this.swapChains) {
                if (swapChain == null) continue;
                XR10.xrDestroySwapchain((XrSwapchain)swapChain.handle);
                swapChain.images.free();
            }
        }
        if (this.xrAppSpace != null) {
            XR10.xrDestroySpace((XrSpace)this.xrAppSpace);
        }
        if (this.xrDebugMessenger != null) {
            EXTDebugUtils.xrDestroyDebugUtilsMessengerEXT((XrDebugUtilsMessengerEXT)this.xrDebugMessenger);
        }
        if (this.xrSession != null) {
            XR10.xrDestroySession((XrSession)this.xrSession);
        }
        if (this.xrInstance != null) {
            XR10.xrDestroyInstance((XrInstance)this.xrInstance);
        }
        if (this.viewFrameBuffers != null) {
            for (SwapChain swapChain : this.viewFrameBuffers) {
                swapChain.dispose();
            }
        }
    }

    public void disposeInput() {
        if (this.actions != null) {
            this.actions.close();
        }
    }

    public void check(int result) throws IllegalStateException {
        this.check(result, null);
    }

    public void check(int result, String method) {
        ByteBuffer str;
        if (XR10.XR_SUCCEEDED((int)result)) {
            return;
        }
        if (this.xrInstance != null && XR10.xrResultToString((XrInstance)this.xrInstance, (int)result, (ByteBuffer)(str = MemoryStack.stackCalloc((int)64))) >= 0) {
            if (method == null) {
                throw new XrResultException(MemoryUtil.memUTF8((ByteBuffer)str, (int)MemoryUtil.memLengthNT1((ByteBuffer)str)));
            }
            throw new XrResultException(method + " : " + MemoryUtil.memUTF8((ByteBuffer)str, (int)MemoryUtil.memLengthNT1((ByteBuffer)str)));
        }
        throw new XrResultException("XR method returned " + result);
    }

    public void checkNoException(int result) {
        this.checkNoException(result, null);
    }

    public void checkNoException(int result, String method) {
        ByteBuffer str;
        if (XR10.XR_SUCCEEDED((int)result)) {
            return;
        }
        if (this.xrInstance != null && XR10.xrResultToString((XrInstance)this.xrInstance, (int)result, (ByteBuffer)(str = MemoryStack.stackCalloc((int)64))) >= 0) {
            if (method == null) {
                logger.error(MemoryUtil.memUTF8((ByteBuffer)str, (int)MemoryUtil.memLengthNT1((ByteBuffer)str)));
            } else {
                logger.error(method + " : " + MemoryUtil.memUTF8((ByteBuffer)str, (int)MemoryUtil.memLengthNT1((ByteBuffer)str)));
            }
            return;
        }
        logger.error("XR method returned " + result);
    }

    public int getWidth() {
        return this.swapChains[0].width;
    }

    public int getHeight() {
        return this.swapChains[0].height;
    }

    public Array<XrControllerDevice> getControllerDevices() {
        return this.devices;
    }

    public void addListener(XrInputListener listener) {
        if (!this.listeners.contains((Object)listener, true)) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(XrInputListener listener) {
        this.listeners.removeValue((Object)listener, true);
    }

    public void setRenderer(XrRenderer renderer) {
        this.currentRenderer.set(renderer);
    }

    public boolean hasRenderer() {
        return this.currentRenderer.get() != null;
    }

    public boolean isRunning() {
        return this.sessionRunning;
    }

    public static class SwapChain {
        public XrSwapchain handle;
        public int width;
        public int height;
        public XrSwapchainImageOpenGLKHR.Buffer images;
    }

    public static class XrResultException
    extends RuntimeException {
        public XrResultException(String s) {
            super(s);
        }
    }
}

