/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr;

import gaiasky.util.Settings;
import gaiasky.util.gdx.loader.OwnObjLoader;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.input.XrControllerDevice;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import net.jafama.FastMath;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFWNativeGLX;
import org.lwjgl.glfw.GLFWNativeWGL;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.glfw.GLFWNativeX11;
import org.lwjgl.opengl.GLX13;
import org.lwjgl.openxr.XrActionSuggestedBinding;
import org.lwjgl.openxr.XrApiLayerProperties;
import org.lwjgl.openxr.XrExtensionProperties;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLWin32KHR;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLXlibKHR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.X11;
import org.lwjgl.system.windows.User32;

public final class XrHelper {
    private XrHelper() {
    }

    public static <T extends StructBuffer> T fill(T buffer, int offset, int value) {
        long ptr = buffer.address() + (long)offset;
        int stride = buffer.sizeof();
        for (long i = 0L; i < (long)buffer.limit(); ++i) {
            MemoryUtil.memPutInt((long)(ptr + i * (long)stride), (int)value);
        }
        return buffer;
    }

    public static XrApiLayerProperties.Buffer prepareApiLayerProperties(MemoryStack stack, int numLayers) {
        return XrHelper.fill(XrApiLayerProperties.malloc((int)numLayers, (MemoryStack)stack), XrApiLayerProperties.TYPE, 1);
    }

    public static XrExtensionProperties.Buffer prepareExtensionProperties(MemoryStack stack, int numExtensions) {
        return XrHelper.fill(XrExtensionProperties.malloc((int)numExtensions, (MemoryStack)stack), XrExtensionProperties.TYPE, 2);
    }

    public static XrActionSuggestedBinding.Buffer prepareActionSuggestedBindings(MemoryStack stack, int numBindings) {
        return XrActionSuggestedBinding.malloc((int)numBindings, (MemoryStack)stack);
    }

    public static FloatBuffer createProjectionMatrixBuffer(MemoryStack stack, XrFovf fov, float nearZ, float farZ, boolean zZeroToOne) {
        float tanLeft = (float)FastMath.tan((double)fov.angleLeft());
        float tanRight = (float)FastMath.tan((double)fov.angleRight());
        float tanDown = (float)FastMath.tan((double)fov.angleDown());
        float tanUp = (float)FastMath.tan((double)fov.angleUp());
        float tanAngleWidth = tanRight - tanLeft;
        float tanAngleHeight = zZeroToOne ? tanDown - tanUp : tanUp - tanDown;
        FloatBuffer m = stack.mallocFloat(16);
        m.put(0, 2.0f / tanAngleWidth);
        m.put(4, 0.0f);
        m.put(8, (tanRight + tanLeft) / tanAngleWidth);
        m.put(12, 0.0f);
        m.put(1, 0.0f);
        m.put(5, 2.0f / tanAngleHeight);
        m.put(9, (tanUp + tanDown) / tanAngleHeight);
        m.put(13, 0.0f);
        m.put(2, 0.0f);
        m.put(6, 0.0f);
        if (zZeroToOne) {
            m.put(10, -farZ / (farZ - nearZ));
            m.put(14, -(farZ * nearZ) / (farZ - nearZ));
        } else {
            m.put(10, -(farZ + nearZ) / (farZ - nearZ));
            m.put(14, -(farZ * (nearZ + nearZ)) / (farZ - nearZ));
        }
        m.put(3, 0.0f);
        m.put(7, 0.0f);
        m.put(11, -1.0f);
        m.put(15, 0.0f);
        return m;
    }

    public static Struct createOpenGLBinding(MemoryStack stack, long window) {
        if (Platform.get() == Platform.WINDOWS) {
            return XrGraphicsBindingOpenGLWin32KHR.calloc((MemoryStack)stack).set(1000023000, 0L, User32.GetDC((long)GLFWNativeWin32.glfwGetWin32Window((long)window)), GLFWNativeWGL.glfwGetWGLContext((long)window));
        }
        if (Platform.get() == Platform.LINUX) {
            long xDisplay = GLFWNativeX11.glfwGetX11Display();
            long glXContext = GLFWNativeGLX.glfwGetGLXContext((long)window);
            long glXWindowHandle = GLFWNativeGLX.glfwGetGLXWindow((long)window);
            int fbXID = GLX13.glXQueryDrawable((long)xDisplay, (long)glXWindowHandle, (int)32787);
            PointerBuffer fbConfigBuf = GLX13.glXChooseFBConfig((long)xDisplay, (int)X11.XDefaultScreen((long)xDisplay), (IntBuffer)MemoryStack.stackInts((int)32787, (int)fbXID, (int)0));
            if (fbConfigBuf == null) {
                throw new IllegalStateException("Your framebuffer config was null, make a github issue");
            }
            long fbConfig = fbConfigBuf.get();
            return XrGraphicsBindingOpenGLXlibKHR.calloc((MemoryStack)stack).set(1000023001, 0L, xDisplay, (int)Objects.requireNonNull(GLX13.glXGetVisualFromFBConfig((long)xDisplay, (long)fbConfig)).visualid(), fbConfig, glXWindowHandle, glXContext);
        }
        throw new IllegalStateException("macOS not supported");
    }

    public static IntModel loadRenderModel(XrDriver driver, XrControllerDevice controllerDevice) {
        IntModel model = null;
        OwnObjLoader ol = new OwnObjLoader();
        model = driver != null && (driver.hmdName.contains("oculus") || driver.hmdName.contains("Oculus") || driver.hmdName.contains("Rift")) ? (controllerDevice.deviceType.isLeft() ? ol.loadModel(Settings.settings.data.dataFileHandle("$data/default-data/models/controllers/oculus/oculus-left.obj")) : ol.loadModel(Settings.settings.data.dataFileHandle("$data/default-data/models/controllers/oculus/oculus-right.obj"))) : (driver != null && (driver.hmdName.contains("SteamVR") || driver.hmdName.contains("Index") || driver.hmdName.contains("index")) ? (controllerDevice.deviceType.isLeft() ? ol.loadModel(Settings.settings.data.dataFileHandle("$data/default-data/models/controllers/index/index-left.obj")) : ol.loadModel(Settings.settings.data.dataFileHandle("$data/default-data/models/controllers/index/index-right.obj"))) : (driver != null && (driver.hmdName.contains("HTC") || driver.hmdName.contains("htc") || driver.hmdName.contains("vive") || driver.hmdName.contains("Vive")) ? ol.loadModel(Settings.settings.data.dataFileHandle("$data/default-data/models/controllers/vive/vr_controller_vive.obj")) : ol.loadModel(Settings.settings.data.dataFileHandle("$data/default-data/models/controllers/generic/generic_vr_controller.obj"))));
        return model;
    }
}

