/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr;

import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import gaiasky.render.RenderingContext;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.util.Constants;
import gaiasky.util.math.Matrix4Utils;
import gaiasky.vr.openxr.XrHelper;
import org.lwjgl.openxr.XrCompositionLayerProjectionView;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;

public class XrViewManager {
    private final Quaternion quaternion = new Quaternion();

    public void updateCamera(XrCompositionLayerProjectionView layerView, PerspectiveCamera camera) {
        this.updateCamera(layerView, camera, null, null);
    }

    public void updateCamera(XrCompositionLayerProjectionView layerView, PerspectiveCamera camera, NaturalCamera naturalCamera, RenderingContext rc) {
        XrPosef pose = layerView.pose();
        XrVector3f position = pose.position$();
        XrQuaternionf orientation = pose.orientation();
        try (MemoryStack stack = MemoryStack.stackPush();){
            Matrix4Utils.put(camera.projection, XrHelper.createProjectionMatrixBuffer(stack, layerView.fov(), camera.near, camera.far, false));
        }
        this.quaternion.set(orientation.x(), orientation.y(), orientation.z(), orientation.w());
        camera.view.idt().translate(position.x(), position.y(), position.z()).rotate(this.quaternion).inv();
        camera.combined.set(camera.projection);
        Matrix4.mul((float[])camera.combined.val, (float[])camera.view.val);
        camera.position.set(position.x(), position.y(), position.z());
        camera.direction.set(0.0f, 0.0f, -1.0f).mul(this.quaternion);
        camera.up.set(0.0f, 1.0f, 0.0f).mul(this.quaternion);
        if (naturalCamera != null) {
            naturalCamera.vrOffset.set(camera.position).scl(Constants.M_TO_U);
            naturalCamera.direction.set(camera.direction);
            naturalCamera.up.set(camera.up);
            rc.vrOffset = naturalCamera.vrOffset;
        }
    }
}

