/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr.input;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.XrHelper;
import gaiasky.vr.openxr.input.XrInputListener;
import gaiasky.vr.openxr.input.actions.BoolAction;
import gaiasky.vr.openxr.input.actions.FloatAction;
import gaiasky.vr.openxr.input.actions.HapticsAction;
import gaiasky.vr.openxr.input.actions.PoseAction;
import gaiasky.vr.openxr.input.actions.Vec2fAction;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrVector3f;

public class XrControllerDevice {
    public final DeviceType deviceType;
    public boolean active = false;
    private boolean initialized = false;
    public Vector3 position = new Vector3();
    public Quaternion orientation = new Quaternion();
    public IntModelInstance modelInstance;
    public Matrix4 aimTransform;
    public BoolAction showUi;
    public BoolAction accept;
    public BoolAction cameraMode;
    public FloatAction select;
    public Vec2fAction move;
    public PoseAction gripPose;
    public PoseAction aimPose;
    public HapticsAction haptics;

    public XrControllerDevice(DeviceType type) {
        this.deviceType = type;
    }

    public void initialize(XrDriver driver) {
        IntModel model = XrHelper.loadRenderModel(driver, this);
        if (model != null) {
            this.modelInstance = new IntModelInstance(model);
        }
        this.aimTransform = new Matrix4();
        this.initialized = model != null && this.modelInstance != null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return this.active;
    }

    public void sendHapticPulse(XrDriver driver, long nanoseconds, float frequency, float amplitude) {
        if (this.haptics != null) {
            this.haptics.sendHapticPulse(driver, nanoseconds, frequency, amplitude);
        }
    }

    public void setGripPose(XrPosef grip) {
        if (this.modelInstance != null) {
            this.setFromXrPose(grip, this.modelInstance.transform);
        }
    }

    public void setAim(XrPosef aim) {
        this.setFromXrPose(aim, this.aimTransform);
        this.aimTransform.rotate(1.0f, 0.0f, 0.0f, 20.0f);
    }

    private void setFromXrPose(XrPosef pose, Matrix4 transform) {
        XrVector3f pos = pose.position$();
        XrQuaternionf ori = pose.orientation();
        this.position.set(pos.x(), pos.y(), pos.z());
        this.orientation.set(ori.x(), ori.y(), ori.z(), ori.w());
        transform.idt().translate(this.position).rotate(this.orientation);
    }

    public IntModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public void processListener(XrInputListener listener) {
        this.processShowUIAction(this.showUi, listener);
        this.processCameraModeAction(this.cameraMode, listener);
        this.processAcceptAction(this.accept, listener);
        this.processSelectAction(this.select, listener);
        this.processMoveAction(this.move, listener);
    }

    private void processShowUIAction(BoolAction action, XrInputListener listener) {
        if (action.isActive && action.changedSinceLastSync) {
            listener.showUI((Boolean)action.currentState, action.getControllerDevice());
        }
    }

    private void processCameraModeAction(BoolAction action, XrInputListener listener) {
        if (action.isActive && action.changedSinceLastSync) {
            listener.cameraMode((Boolean)action.currentState, action.getControllerDevice());
        }
    }

    private void processAcceptAction(BoolAction action, XrInputListener listener) {
        if (action.isActive && action.changedSinceLastSync) {
            listener.accept((Boolean)action.currentState, action.getControllerDevice());
        }
    }

    private void processSelectAction(FloatAction action, XrInputListener listener) {
        if (action.isActive && action.changedSinceLastSync) {
            listener.select(((Float)action.currentState).floatValue(), action.getControllerDevice());
        }
    }

    private void processMoveAction(Vec2fAction action, XrInputListener listener) {
        if (action.isActive) {
            listener.move((Vector2)action.currentState, action.getControllerDevice());
        }
    }

    public static enum DeviceType {
        Left,
        Right;


        public boolean isLeft() {
            return this == Left;
        }

        public boolean isRight() {
            return this == Right;
        }
    }
}

