/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr.input.actions;

import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.actions.SpaceAwareAction;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrActionCreateInfo;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.system.MemoryStack;

public abstract class Action
implements AutoCloseable {
    protected XrAction handle;
    public final String name;
    public final String localizedName;
    public final int xrActionType;
    protected final XrControllerDevice controllerDevice;

    protected Action(String name, String localizedName, int type, XrControllerDevice device) {
        this.name = name;
        this.localizedName = localizedName;
        this.xrActionType = type;
        this.controllerDevice = device;
    }

    public void createHandle(XrActionSet actionSet, XrDriver driver) {
        this.handle = this.createAction(driver, actionSet, this.xrActionType);
        if (this instanceof SpaceAwareAction) {
            ((SpaceAwareAction)((Object)this)).createActionSpace(driver);
        }
    }

    protected XrAction createAction(XrDriver driver, XrActionSet actionSet, int type) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActionCreateInfo createInfo = XrActionCreateInfo.malloc((MemoryStack)stack).type$Default().next(0L).actionName(stack.UTF8((CharSequence)this.name)).localizedActionName(stack.UTF8((CharSequence)this.localizedName)).countSubactionPaths(0).actionType(type);
            PointerBuffer pp = stack.mallocPointer(1);
            driver.check(XR10.xrCreateAction((XrActionSet)actionSet, (XrActionCreateInfo)createInfo, (PointerBuffer)pp));
            XrAction xrAction = new XrAction(pp.get(0), actionSet);
            return xrAction;
        }
    }

    public XrAction getHandle() {
        return this.handle;
    }

    public void destroyHandle() {
        XR10.xrDestroyAction((XrAction)this.handle);
        if (this instanceof SpaceAwareAction) {
            ((SpaceAwareAction)((Object)this)).destroyActionSpace();
        }
    }

    @Override
    public void close() {
        this.destroyHandle();
    }

    public XrControllerDevice getControllerDevice() {
        return this.controllerDevice;
    }

    public XrControllerDevice.DeviceType getDeviceType() {
        return this.controllerDevice.deviceType;
    }
}

