/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr.input.actions;

import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.actions.Action;
import gaiasky.vr.openxr.input.actions.InputAction;
import gaiasky.vr.openxr.input.actions.SpaceAwareAction;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionSpaceCreateInfo;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.openxr.XrActionStatePose;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpaceLocation;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;

public class PoseAction
extends Action
implements SpaceAwareAction,
InputAction {
    private static final XrActionStateGetInfo getInfo = XrActionStateGetInfo.calloc().type(58);
    private static final XrActionStatePose state = XrActionStatePose.calloc().type(27);
    private static final XrSpaceLocation location = XrSpaceLocation.calloc();
    private static final XrPosef pose = XrPosef.calloc();
    public XrSpace space;
    public final PoseType poseType;

    public PoseAction(String name, String localizedName, PoseType poseType, XrControllerDevice device) {
        super(name, localizedName, 4, device);
        this.poseType = poseType;
    }

    @Override
    public void createActionSpace(XrDriver driver) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActionSpaceCreateInfo createInfo = XrActionSpaceCreateInfo.malloc((MemoryStack)stack).type$Default().next(0L).poseInActionSpace(XrPosef.malloc((MemoryStack)stack).position$(XrVector3f.calloc((MemoryStack)stack).set(0.0f, 0.0f, 0.0f)).orientation(XrQuaternionf.malloc((MemoryStack)stack).x(0.0f).y(0.0f).z(0.0f).w(1.0f))).action(this.handle);
            PointerBuffer pp = stack.mallocPointer(1);
            driver.check(XR10.xrCreateActionSpace((XrSession)driver.xrSession, (XrActionSpaceCreateInfo)createInfo, (PointerBuffer)pp), "xrCreateActionSpace");
            this.space = new XrSpace(pp.get(0), driver.xrSession);
        }
    }

    @Override
    public void sync(XrDriver driver) {
        getInfo.action(this.handle);
        driver.check(XR10.xrGetActionStatePose((XrSession)driver.xrSession, (XrActionStateGetInfo)getInfo, (XrActionStatePose)state), "xrGetActionStatePose");
        this.controllerDevice.active = state.isActive();
        if (this.controllerDevice.active && driver.currentFrameTime > 0L) {
            location.set(42, 0L, 0L, pose);
            driver.checkNoException(XR10.xrLocateSpace((XrSpace)this.space, (XrSpace)driver.xrAppSpace, (long)driver.currentFrameTime, (XrSpaceLocation)location));
            if ((location.locationFlags() & 2L) != 0L && (location.locationFlags() & 1L) != 0L) {
                if (this.poseType.isGrip()) {
                    this.controllerDevice.setGripPose(location.pose());
                } else {
                    this.controllerDevice.setAim(location.pose());
                }
            }
        }
    }

    @Override
    public void destroyActionSpace() {
    }

    public static enum PoseType {
        AIM,
        GRIP;


        public boolean isGrip() {
            return this == GRIP;
        }

        public boolean isAim() {
            return this == AIM;
        }
    }
}

