/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr.input.actionsets;

import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.input.actions.Action;
import gaiasky.vr.openxr.input.actions.InputAction;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.openxr.XrActionSetCreateInfo;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSessionActionSetsAttachInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Pointer;
import oshi.util.tuples.Pair;

public abstract class ActionSet
implements AutoCloseable {
    protected XrDriver driver;
    public final String name;
    public final String localizedName;
    private XrActionSet handle;
    private final int priority;

    protected ActionSet(String name, String localizedName, int priority) {
        this.name = name;
        this.localizedName = localizedName;
        this.priority = priority;
    }

    public abstract List<Action> actions();

    public boolean shouldSync() {
        return true;
    }

    public abstract void getDefaultBindings(HashMap<String, List<Pair<Action, String>>> var1);

    public void sync(XrDriver driver) {
        for (Action action : this.actions()) {
            if (!(action instanceof InputAction)) continue;
            ((InputAction)((Object)action)).sync(driver);
        }
    }

    public final void createHandle(XrDriver driver) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActionSetCreateInfo setCreateInfo = XrActionSetCreateInfo.malloc((MemoryStack)stack).type$Default().actionSetName(stack.UTF8((CharSequence)this.name)).localizedActionSetName(stack.UTF8((CharSequence)this.localizedName)).priority(this.priority);
            PointerBuffer pp = stack.mallocPointer(1);
            driver.check(XR10.xrCreateActionSet((XrInstance)driver.xrInstance, (XrActionSetCreateInfo)setCreateInfo, (PointerBuffer)pp));
            this.handle = new XrActionSet(pp.get(0), driver.xrInstance);
            for (Action action : this.actions()) {
                action.createHandle(this.handle, driver);
            }
        }
    }

    public void attachToSession(XrDriver driver, MemoryStack stack) {
        XrSessionActionSetsAttachInfo attachInfo = XrSessionActionSetsAttachInfo.calloc((MemoryStack)stack).set(60, 0L, MemoryStack.stackPointers((Pointer)this.handle));
        driver.check(XR10.xrAttachSessionActionSets((XrSession)driver.xrSession, (XrSessionActionSetsAttachInfo)attachInfo));
    }

    public final XrActionSet getHandle() {
        return this.handle;
    }

    public final void destroyHandles() {
        if (this.handle != null) {
            XR10.xrDestroyActionSet((XrActionSet)this.handle);
        }
    }

    @Override
    public final void close() {
        this.destroyHandles();
        for (Action action : this.actions()) {
            action.close();
        }
    }
}

