/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.vr.openxr.input.actionsets;

import gaiasky.vr.openxr.input.XrControllerDevice;
import gaiasky.vr.openxr.input.XrInputListener;
import gaiasky.vr.openxr.input.actions.Action;
import gaiasky.vr.openxr.input.actions.BoolAction;
import gaiasky.vr.openxr.input.actions.FloatAction;
import gaiasky.vr.openxr.input.actions.HapticsAction;
import gaiasky.vr.openxr.input.actions.PoseAction;
import gaiasky.vr.openxr.input.actions.Vec2fAction;
import gaiasky.vr.openxr.input.actionsets.ActionSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oshi.util.tuples.Pair;

public class GaiaSkyActionSet
extends ActionSet {
    public final XrControllerDevice deviceLeft;
    public final XrControllerDevice deviceRight;
    public final List<Action> actions;

    public GaiaSkyActionSet(XrControllerDevice deviceLeft, XrControllerDevice deviceRight) {
        super("gaiasky", "Gaia Sky actions", 0);
        this.deviceLeft = deviceLeft;
        this.deviceRight = deviceRight;
        deviceLeft.showUi = new BoolAction("show-ui-left", "Show UI (left)", deviceLeft);
        deviceRight.showUi = new BoolAction("show-ui-right", "Show UI (right)", deviceRight);
        deviceLeft.accept = new BoolAction("accept-left", "Accept (left)", deviceLeft);
        deviceRight.accept = new BoolAction("accept-right", "Accept (right)", deviceRight);
        deviceLeft.cameraMode = new BoolAction("camera-mode-left", "Camera mode (left)", deviceLeft);
        deviceRight.cameraMode = new BoolAction("camera-mode-right", "Camera mode (right)", deviceRight);
        deviceLeft.select = new FloatAction("select-object-left", "Select object/UI (left)", deviceLeft);
        deviceRight.select = new FloatAction("select-object-right", "Select object/UI (right)", deviceRight);
        deviceLeft.move = new Vec2fAction("move-left", "Move (left)", deviceLeft);
        deviceRight.move = new Vec2fAction("move-right", "Move (right)", deviceRight);
        deviceLeft.gripPose = new PoseAction("left-grip", "Left grip pose", PoseAction.PoseType.GRIP, deviceLeft);
        deviceRight.gripPose = new PoseAction("right-grip", "Right grip pose", PoseAction.PoseType.GRIP, deviceRight);
        deviceLeft.aimPose = new PoseAction("left-aim", "Left aim pose", PoseAction.PoseType.AIM, deviceLeft);
        deviceRight.aimPose = new PoseAction("right-aim", "Right aim pose", PoseAction.PoseType.AIM, deviceRight);
        deviceLeft.haptics = new HapticsAction("haptics-left", "Haptic left", deviceLeft);
        deviceRight.haptics = new HapticsAction("haptics-right", "Haptic right", deviceRight);
        this.actions = List.of(deviceLeft.gripPose, deviceRight.gripPose, deviceLeft.aimPose, deviceRight.aimPose, deviceLeft.haptics, deviceRight.haptics, deviceLeft.showUi, deviceRight.showUi, deviceLeft.accept, deviceRight.accept, deviceLeft.cameraMode, deviceRight.cameraMode, deviceLeft.select, deviceRight.select, deviceLeft.move, deviceRight.move);
    }

    public void processListener(XrInputListener listener) {
        this.deviceLeft.processListener(listener);
        this.deviceRight.processListener(listener);
    }

    @Override
    public List<Action> actions() {
        return this.actions;
    }

    @Override
    public void getDefaultBindings(HashMap<String, List<Pair<Action, String>>> map) {
        map.computeIfAbsent("/interaction_profiles/oculus/touch_controller", aLong -> new ArrayList()).addAll(List.of(new Pair((Object)this.deviceLeft.aimPose, (Object)"/user/hand/left/input/aim/pose"), new Pair((Object)this.deviceRight.aimPose, (Object)"/user/hand/right/input/aim/pose"), new Pair((Object)this.deviceLeft.gripPose, (Object)"/user/hand/left/input/grip/pose"), new Pair((Object)this.deviceRight.gripPose, (Object)"/user/hand/right/input/grip/pose"), new Pair((Object)this.deviceLeft.haptics, (Object)"/user/hand/left/output/haptic"), new Pair((Object)this.deviceRight.haptics, (Object)"/user/hand/right/output/haptic"), new Pair((Object)this.deviceLeft.showUi, (Object)"/user/hand/left/input/y/click"), new Pair((Object)this.deviceRight.showUi, (Object)"/user/hand/right/input/b/click"), new Pair((Object)this.deviceLeft.accept, (Object)"/user/hand/left/input/y/click"), new Pair((Object)this.deviceRight.accept, (Object)"/user/hand/right/input/b/click"), new Pair((Object)this.deviceLeft.cameraMode, (Object)"/user/hand/left/input/x/click"), new Pair((Object)this.deviceRight.cameraMode, (Object)"/user/hand/right/input/a/click"), new Pair((Object)this.deviceLeft.select, (Object)"/user/hand/left/input/trigger/value"), new Pair((Object)this.deviceRight.select, (Object)"/user/hand/right/input/trigger/value"), new Pair((Object)this.deviceLeft.move, (Object)"/user/hand/left/input/thumbstick"), new Pair((Object)this.deviceRight.move, (Object)"/user/hand/right/input/thumbstick")));
        map.computeIfAbsent("/interaction_profiles/valve/index_controller", aLong -> new ArrayList()).addAll(List.of(new Pair((Object)this.deviceLeft.aimPose, (Object)"/user/hand/left/input/aim/pose"), new Pair((Object)this.deviceRight.aimPose, (Object)"/user/hand/right/input/aim/pose"), new Pair((Object)this.deviceLeft.gripPose, (Object)"/user/hand/left/input/grip/pose"), new Pair((Object)this.deviceRight.gripPose, (Object)"/user/hand/right/input/grip/pose"), new Pair((Object)this.deviceLeft.haptics, (Object)"/user/hand/left/output/haptic"), new Pair((Object)this.deviceRight.haptics, (Object)"/user/hand/right/output/haptic"), new Pair((Object)this.deviceLeft.showUi, (Object)"/user/hand/left/input/b/click"), new Pair((Object)this.deviceRight.showUi, (Object)"/user/hand/right/input/b/click"), new Pair((Object)this.deviceLeft.accept, (Object)"/user/hand/left/input/b/click"), new Pair((Object)this.deviceRight.accept, (Object)"/user/hand/right/input/b/click"), new Pair((Object)this.deviceLeft.cameraMode, (Object)"/user/hand/left/input/a/click"), new Pair((Object)this.deviceRight.cameraMode, (Object)"/user/hand/right/input/a/click"), new Pair((Object)this.deviceLeft.select, (Object)"/user/hand/left/input/trigger/value"), new Pair((Object)this.deviceRight.select, (Object)"/user/hand/right/input/trigger/value"), new Pair((Object)this.deviceLeft.move, (Object)"/user/hand/left/input/thumbstick"), new Pair((Object)this.deviceRight.move, (Object)"/user/hand/right/input/thumbstick")));
        map.computeIfAbsent("/interaction_profiles/htc/vive_controller", aLong -> new ArrayList()).addAll(List.of(new Pair((Object)this.deviceLeft.aimPose, (Object)"/user/hand/left/input/aim/pose"), new Pair((Object)this.deviceRight.aimPose, (Object)"/user/hand/right/input/aim/pose"), new Pair((Object)this.deviceLeft.gripPose, (Object)"/user/hand/left/input/grip/pose"), new Pair((Object)this.deviceRight.gripPose, (Object)"/user/hand/right/input/grip/pose"), new Pair((Object)this.deviceLeft.haptics, (Object)"/user/hand/left/output/haptic"), new Pair((Object)this.deviceRight.haptics, (Object)"/user/hand/right/output/haptic"), new Pair((Object)this.deviceLeft.showUi, (Object)"/user/hand/left/input/menu/click"), new Pair((Object)this.deviceRight.showUi, (Object)"/user/hand/right/input/menu/click"), new Pair((Object)this.deviceLeft.accept, (Object)"/user/hand/left/input/menu/click"), new Pair((Object)this.deviceRight.accept, (Object)"/user/hand/right/input/menu/click"), new Pair((Object)this.deviceLeft.cameraMode, (Object)"/user/hand/left/input/trackpad/click"), new Pair((Object)this.deviceRight.cameraMode, (Object)"/user/hand/right/input/trackpad/click"), new Pair((Object)this.deviceLeft.select, (Object)"/user/hand/left/input/trigger/value"), new Pair((Object)this.deviceRight.select, (Object)"/user/hand/right/input/trigger/value"), new Pair((Object)this.deviceLeft.move, (Object)"/user/hand/left/input/trackpad"), new Pair((Object)this.deviceRight.move, (Object)"/user/hand/right/input/trackpad")));
        map.computeIfAbsent("/interaction_profiles/microsoft/motion_controller", aLong -> new ArrayList()).addAll(List.of(new Pair((Object)this.deviceLeft.aimPose, (Object)"/user/hand/left/input/aim/pose"), new Pair((Object)this.deviceRight.aimPose, (Object)"/user/hand/right/input/aim/pose"), new Pair((Object)this.deviceLeft.gripPose, (Object)"/user/hand/left/input/grip/pose"), new Pair((Object)this.deviceRight.gripPose, (Object)"/user/hand/right/input/grip/pose"), new Pair((Object)this.deviceLeft.haptics, (Object)"/user/hand/left/output/haptic"), new Pair((Object)this.deviceRight.haptics, (Object)"/user/hand/right/output/haptic"), new Pair((Object)this.deviceLeft.showUi, (Object)"/user/hand/left/input/trackpad/click"), new Pair((Object)this.deviceRight.showUi, (Object)"/user/hand/right/input/trackpad/click"), new Pair((Object)this.deviceLeft.accept, (Object)"/user/hand/left/input/trackpad/click"), new Pair((Object)this.deviceRight.accept, (Object)"/user/hand/right/input/trackpad/click"), new Pair((Object)this.deviceLeft.cameraMode, (Object)"/user/hand/left/input/thumbstick/click"), new Pair((Object)this.deviceRight.cameraMode, (Object)"/user/hand/right/input/thumbstick/click"), new Pair((Object)this.deviceLeft.select, (Object)"/user/hand/left/input/trigger/value"), new Pair((Object)this.deviceRight.select, (Object)"/user/hand/right/input/trigger/value"), new Pair((Object)this.deviceLeft.move, (Object)"/user/hand/left/input/thumbstick"), new Pair((Object)this.deviceRight.move, (Object)"/user/hand/right/input/thumbstick")));
    }
}

