/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrActionCreateInfo;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.openxr.XrActionSetCreateInfo;
import org.lwjgl.openxr.XrActionSpaceCreateInfo;
import org.lwjgl.openxr.XrActionStateBoolean;
import org.lwjgl.openxr.XrActionStateFloat;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.openxr.XrActionStatePose;
import org.lwjgl.openxr.XrActionStateVector2f;
import org.lwjgl.openxr.XrActionsSyncInfo;
import org.lwjgl.openxr.XrApiLayerProperties;
import org.lwjgl.openxr.XrBoundSourcesForActionEnumerateInfo;
import org.lwjgl.openxr.XrEventDataBuffer;
import org.lwjgl.openxr.XrExtensionProperties;
import org.lwjgl.openxr.XrExtent2Df;
import org.lwjgl.openxr.XrFrameBeginInfo;
import org.lwjgl.openxr.XrFrameEndInfo;
import org.lwjgl.openxr.XrFrameState;
import org.lwjgl.openxr.XrFrameWaitInfo;
import org.lwjgl.openxr.XrHapticActionInfo;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.openxr.XrInputSourceLocalizedNameGetInfo;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrInstanceCreateInfo;
import org.lwjgl.openxr.XrInstanceProperties;
import org.lwjgl.openxr.XrInteractionProfileState;
import org.lwjgl.openxr.XrInteractionProfileSuggestedBinding;
import org.lwjgl.openxr.XrReferenceSpaceCreateInfo;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSessionActionSetsAttachInfo;
import org.lwjgl.openxr.XrSessionBeginInfo;
import org.lwjgl.openxr.XrSessionCreateInfo;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpaceLocation;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.openxr.XrSwapchainCreateInfo;
import org.lwjgl.openxr.XrSwapchainImageAcquireInfo;
import org.lwjgl.openxr.XrSwapchainImageBaseHeader;
import org.lwjgl.openxr.XrSwapchainImageReleaseInfo;
import org.lwjgl.openxr.XrSwapchainImageWaitInfo;
import org.lwjgl.openxr.XrSystemGetInfo;
import org.lwjgl.openxr.XrSystemProperties;
import org.lwjgl.openxr.XrView;
import org.lwjgl.openxr.XrViewConfigurationProperties;
import org.lwjgl.openxr.XrViewConfigurationView;
import org.lwjgl.openxr.XrViewLocateInfo;
import org.lwjgl.openxr.XrViewState;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class XR10 {
    public static final int XR_SUCCESS = 0;
    public static final int XR_TIMEOUT_EXPIRED = 1;
    public static final int XR_SESSION_LOSS_PENDING = 3;
    public static final int XR_EVENT_UNAVAILABLE = 4;
    public static final int XR_SPACE_BOUNDS_UNAVAILABLE = 7;
    public static final int XR_SESSION_NOT_FOCUSED = 8;
    public static final int XR_FRAME_DISCARDED = 9;
    public static final int XR_ERROR_VALIDATION_FAILURE = -1;
    public static final int XR_ERROR_RUNTIME_FAILURE = -2;
    public static final int XR_ERROR_OUT_OF_MEMORY = -3;
    public static final int XR_ERROR_API_VERSION_UNSUPPORTED = -4;
    public static final int XR_ERROR_INITIALIZATION_FAILED = -6;
    public static final int XR_ERROR_FUNCTION_UNSUPPORTED = -7;
    public static final int XR_ERROR_FEATURE_UNSUPPORTED = -8;
    public static final int XR_ERROR_EXTENSION_NOT_PRESENT = -9;
    public static final int XR_ERROR_LIMIT_REACHED = -10;
    public static final int XR_ERROR_SIZE_INSUFFICIENT = -11;
    public static final int XR_ERROR_HANDLE_INVALID = -12;
    public static final int XR_ERROR_INSTANCE_LOST = -13;
    public static final int XR_ERROR_SESSION_RUNNING = -14;
    public static final int XR_ERROR_SESSION_NOT_RUNNING = -16;
    public static final int XR_ERROR_SESSION_LOST = -17;
    public static final int XR_ERROR_SYSTEM_INVALID = -18;
    public static final int XR_ERROR_PATH_INVALID = -19;
    public static final int XR_ERROR_PATH_COUNT_EXCEEDED = -20;
    public static final int XR_ERROR_PATH_FORMAT_INVALID = -21;
    public static final int XR_ERROR_PATH_UNSUPPORTED = -22;
    public static final int XR_ERROR_LAYER_INVALID = -23;
    public static final int XR_ERROR_LAYER_LIMIT_EXCEEDED = -24;
    public static final int XR_ERROR_SWAPCHAIN_RECT_INVALID = -25;
    public static final int XR_ERROR_SWAPCHAIN_FORMAT_UNSUPPORTED = -26;
    public static final int XR_ERROR_ACTION_TYPE_MISMATCH = -27;
    public static final int XR_ERROR_SESSION_NOT_READY = -28;
    public static final int XR_ERROR_SESSION_NOT_STOPPING = -29;
    public static final int XR_ERROR_TIME_INVALID = -30;
    public static final int XR_ERROR_REFERENCE_SPACE_UNSUPPORTED = -31;
    public static final int XR_ERROR_FILE_ACCESS_ERROR = -32;
    public static final int XR_ERROR_FILE_CONTENTS_INVALID = -33;
    public static final int XR_ERROR_FORM_FACTOR_UNSUPPORTED = -34;
    public static final int XR_ERROR_FORM_FACTOR_UNAVAILABLE = -35;
    public static final int XR_ERROR_API_LAYER_NOT_PRESENT = -36;
    public static final int XR_ERROR_CALL_ORDER_INVALID = -37;
    public static final int XR_ERROR_GRAPHICS_DEVICE_INVALID = -38;
    public static final int XR_ERROR_POSE_INVALID = -39;
    public static final int XR_ERROR_INDEX_OUT_OF_RANGE = -40;
    public static final int XR_ERROR_VIEW_CONFIGURATION_TYPE_UNSUPPORTED = -41;
    public static final int XR_ERROR_ENVIRONMENT_BLEND_MODE_UNSUPPORTED = -42;
    public static final int XR_ERROR_NAME_DUPLICATED = -44;
    public static final int XR_ERROR_NAME_INVALID = -45;
    public static final int XR_ERROR_ACTIONSET_NOT_ATTACHED = -46;
    public static final int XR_ERROR_ACTIONSETS_ALREADY_ATTACHED = -47;
    public static final int XR_ERROR_LOCALIZED_NAME_DUPLICATED = -48;
    public static final int XR_ERROR_LOCALIZED_NAME_INVALID = -49;
    public static final int XR_ERROR_GRAPHICS_REQUIREMENTS_CALL_MISSING = -50;
    public static final int XR_ERROR_RUNTIME_UNAVAILABLE = -51;
    public static final int XR_TYPE_UNKNOWN = 0;
    public static final int XR_TYPE_API_LAYER_PROPERTIES = 1;
    public static final int XR_TYPE_EXTENSION_PROPERTIES = 2;
    public static final int XR_TYPE_INSTANCE_CREATE_INFO = 3;
    public static final int XR_TYPE_SYSTEM_GET_INFO = 4;
    public static final int XR_TYPE_SYSTEM_PROPERTIES = 5;
    public static final int XR_TYPE_VIEW_LOCATE_INFO = 6;
    public static final int XR_TYPE_VIEW = 7;
    public static final int XR_TYPE_SESSION_CREATE_INFO = 8;
    public static final int XR_TYPE_SWAPCHAIN_CREATE_INFO = 9;
    public static final int XR_TYPE_SESSION_BEGIN_INFO = 10;
    public static final int XR_TYPE_VIEW_STATE = 11;
    public static final int XR_TYPE_FRAME_END_INFO = 12;
    public static final int XR_TYPE_HAPTIC_VIBRATION = 13;
    public static final int XR_TYPE_EVENT_DATA_BUFFER = 16;
    public static final int XR_TYPE_EVENT_DATA_INSTANCE_LOSS_PENDING = 17;
    public static final int XR_TYPE_EVENT_DATA_SESSION_STATE_CHANGED = 18;
    public static final int XR_TYPE_ACTION_STATE_BOOLEAN = 23;
    public static final int XR_TYPE_ACTION_STATE_FLOAT = 24;
    public static final int XR_TYPE_ACTION_STATE_VECTOR2F = 25;
    public static final int XR_TYPE_ACTION_STATE_POSE = 27;
    public static final int XR_TYPE_ACTION_SET_CREATE_INFO = 28;
    public static final int XR_TYPE_ACTION_CREATE_INFO = 29;
    public static final int XR_TYPE_INSTANCE_PROPERTIES = 32;
    public static final int XR_TYPE_FRAME_WAIT_INFO = 33;
    public static final int XR_TYPE_COMPOSITION_LAYER_PROJECTION = 35;
    public static final int XR_TYPE_COMPOSITION_LAYER_QUAD = 36;
    public static final int XR_TYPE_REFERENCE_SPACE_CREATE_INFO = 37;
    public static final int XR_TYPE_ACTION_SPACE_CREATE_INFO = 38;
    public static final int XR_TYPE_EVENT_DATA_REFERENCE_SPACE_CHANGE_PENDING = 40;
    public static final int XR_TYPE_VIEW_CONFIGURATION_VIEW = 41;
    public static final int XR_TYPE_SPACE_LOCATION = 42;
    public static final int XR_TYPE_SPACE_VELOCITY = 43;
    public static final int XR_TYPE_FRAME_STATE = 44;
    public static final int XR_TYPE_VIEW_CONFIGURATION_PROPERTIES = 45;
    public static final int XR_TYPE_FRAME_BEGIN_INFO = 46;
    public static final int XR_TYPE_COMPOSITION_LAYER_PROJECTION_VIEW = 48;
    public static final int XR_TYPE_EVENT_DATA_EVENTS_LOST = 49;
    public static final int XR_TYPE_INTERACTION_PROFILE_SUGGESTED_BINDING = 51;
    public static final int XR_TYPE_EVENT_DATA_INTERACTION_PROFILE_CHANGED = 52;
    public static final int XR_TYPE_INTERACTION_PROFILE_STATE = 53;
    public static final int XR_TYPE_SWAPCHAIN_IMAGE_ACQUIRE_INFO = 55;
    public static final int XR_TYPE_SWAPCHAIN_IMAGE_WAIT_INFO = 56;
    public static final int XR_TYPE_SWAPCHAIN_IMAGE_RELEASE_INFO = 57;
    public static final int XR_TYPE_ACTION_STATE_GET_INFO = 58;
    public static final int XR_TYPE_HAPTIC_ACTION_INFO = 59;
    public static final int XR_TYPE_SESSION_ACTION_SETS_ATTACH_INFO = 60;
    public static final int XR_TYPE_ACTIONS_SYNC_INFO = 61;
    public static final int XR_TYPE_BOUND_SOURCES_FOR_ACTION_ENUMERATE_INFO = 62;
    public static final int XR_TYPE_INPUT_SOURCE_LOCALIZED_NAME_GET_INFO = 63;
    public static final int XR_FORM_FACTOR_HEAD_MOUNTED_DISPLAY = 1;
    public static final int XR_FORM_FACTOR_HANDHELD_DISPLAY = 2;
    public static final int XR_VIEW_CONFIGURATION_TYPE_PRIMARY_MONO = 1;
    public static final int XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO = 2;
    public static final int XR_ENVIRONMENT_BLEND_MODE_OPAQUE = 1;
    public static final int XR_ENVIRONMENT_BLEND_MODE_ADDITIVE = 2;
    public static final int XR_ENVIRONMENT_BLEND_MODE_ALPHA_BLEND = 3;
    public static final int XR_SPACE_VELOCITY_LINEAR_VALID_BIT = 1;
    public static final int XR_SPACE_VELOCITY_ANGULAR_VALID_BIT = 2;
    public static final int XR_REFERENCE_SPACE_TYPE_VIEW = 1;
    public static final int XR_REFERENCE_SPACE_TYPE_LOCAL = 2;
    public static final int XR_REFERENCE_SPACE_TYPE_STAGE = 3;
    public static final int XR_SPACE_LOCATION_ORIENTATION_VALID_BIT = 1;
    public static final int XR_SPACE_LOCATION_POSITION_VALID_BIT = 2;
    public static final int XR_SPACE_LOCATION_ORIENTATION_TRACKED_BIT = 4;
    public static final int XR_SPACE_LOCATION_POSITION_TRACKED_BIT = 8;
    public static final int XR_SWAPCHAIN_CREATE_PROTECTED_CONTENT_BIT = 1;
    public static final int XR_SWAPCHAIN_CREATE_STATIC_IMAGE_BIT = 2;
    public static final int XR_SWAPCHAIN_USAGE_COLOR_ATTACHMENT_BIT = 1;
    public static final int XR_SWAPCHAIN_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT = 2;
    public static final int XR_SWAPCHAIN_USAGE_UNORDERED_ACCESS_BIT = 4;
    public static final int XR_SWAPCHAIN_USAGE_TRANSFER_SRC_BIT = 8;
    public static final int XR_SWAPCHAIN_USAGE_TRANSFER_DST_BIT = 16;
    public static final int XR_SWAPCHAIN_USAGE_SAMPLED_BIT = 32;
    public static final int XR_SWAPCHAIN_USAGE_MUTABLE_FORMAT_BIT = 64;
    public static final int XR_COMPOSITION_LAYER_CORRECT_CHROMATIC_ABERRATION_BIT = 1;
    public static final int XR_COMPOSITION_LAYER_BLEND_TEXTURE_SOURCE_ALPHA_BIT = 2;
    public static final int XR_COMPOSITION_LAYER_UNPREMULTIPLIED_ALPHA_BIT = 4;
    public static final int XR_VIEW_STATE_ORIENTATION_VALID_BIT = 1;
    public static final int XR_VIEW_STATE_POSITION_VALID_BIT = 2;
    public static final int XR_VIEW_STATE_ORIENTATION_TRACKED_BIT = 4;
    public static final int XR_VIEW_STATE_POSITION_TRACKED_BIT = 8;
    public static final int XR_ACTION_TYPE_BOOLEAN_INPUT = 1;
    public static final int XR_ACTION_TYPE_FLOAT_INPUT = 2;
    public static final int XR_ACTION_TYPE_VECTOR2F_INPUT = 3;
    public static final int XR_ACTION_TYPE_POSE_INPUT = 4;
    public static final int XR_ACTION_TYPE_VIBRATION_OUTPUT = 100;
    public static final int XR_INPUT_SOURCE_LOCALIZED_NAME_USER_PATH_BIT = 1;
    public static final int XR_INPUT_SOURCE_LOCALIZED_NAME_INTERACTION_PROFILE_BIT = 2;
    public static final int XR_INPUT_SOURCE_LOCALIZED_NAME_COMPONENT_BIT = 4;
    public static final int XR_EYE_VISIBILITY_BOTH = 0;
    public static final int XR_EYE_VISIBILITY_LEFT = 1;
    public static final int XR_EYE_VISIBILITY_RIGHT = 2;
    public static final int XR_SESSION_STATE_UNKNOWN = 0;
    public static final int XR_SESSION_STATE_IDLE = 1;
    public static final int XR_SESSION_STATE_READY = 2;
    public static final int XR_SESSION_STATE_SYNCHRONIZED = 3;
    public static final int XR_SESSION_STATE_VISIBLE = 4;
    public static final int XR_SESSION_STATE_FOCUSED = 5;
    public static final int XR_SESSION_STATE_STOPPING = 6;
    public static final int XR_SESSION_STATE_LOSS_PENDING = 7;
    public static final int XR_SESSION_STATE_EXITING = 8;
    public static final int XR_OBJECT_TYPE_UNKNOWN = 0;
    public static final int XR_OBJECT_TYPE_INSTANCE = 1;
    public static final int XR_OBJECT_TYPE_SESSION = 2;
    public static final int XR_OBJECT_TYPE_SWAPCHAIN = 3;
    public static final int XR_OBJECT_TYPE_SPACE = 4;
    public static final int XR_OBJECT_TYPE_ACTION_SET = 5;
    public static final int XR_OBJECT_TYPE_ACTION = 6;
    public static final long XR_CURRENT_API_VERSION = XR10.XR_MAKE_VERSION(1, 0, 29);
    public static final int XR_USE_GRAPHICS_API_OPENGL = 0;
    public static final int XR_USE_GRAPHICS_API_OPENGL_ES = 0;
    public static final int XR_USE_GRAPHICS_API_VULKAN = 0;
    public static final int XR_USE_PLATFORM_EGL = 0;
    public static final int XR_USE_PLATFORM_WIN32 = 0;
    public static final int XR_USE_PLATFORM_XLIB = 0;
    public static final int XR_USE_PLATFORM_XCB = 0;
    public static final int XR_USE_PLATFORM_WAYLAND = 0;
    public static final long XR_NULL_HANDLE = 0L;
    public static final long XR_NULL_PATH = 0L;
    public static final long XR_NULL_SYSTEM_ID = 0L;
    public static final long XR_NO_DURATION = 0L;
    public static final long XR_INFINITE_DURATION = Long.MAX_VALUE;
    public static final long XR_MIN_HAPTIC_DURATION = -1L;
    public static final long XR_MAX_EVENT_DATA_SIZE = XrEventDataBuffer.SIZEOF;
    public static final float XR_FREQUENCY_UNSPECIFIED = 0.0f;
    public static final int XR_TRUE = 1;
    public static final int XR_FALSE = 0;
    public static final int XR_MAX_EXTENSION_NAME_SIZE = 128;
    public static final int XR_MAX_API_LAYER_NAME_SIZE = 256;
    public static final int XR_MAX_API_LAYER_DESCRIPTION_SIZE = 256;
    public static final int XR_MAX_SYSTEM_NAME_SIZE = 256;
    public static final int XR_MAX_APPLICATION_NAME_SIZE = 128;
    public static final int XR_MAX_ENGINE_NAME_SIZE = 128;
    public static final int XR_MAX_RUNTIME_NAME_SIZE = 128;
    public static final int XR_MAX_PATH_LENGTH = 256;
    public static final int XR_MAX_STRUCTURE_NAME_SIZE = 64;
    public static final int XR_MAX_RESULT_STRING_SIZE = 64;
    public static final int XR_MAX_GRAPHICS_APIS_SUPPORTED = 32;
    public static final int XR_MAX_ACTION_SET_NAME_SIZE = 64;
    public static final int XR_MAX_ACTION_NAME_SIZE = 64;
    public static final int XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE = 128;
    public static final int XR_MAX_LOCALIZED_ACTION_NAME_SIZE = 128;
    public static final int XR_MIN_COMPOSITION_LAYERS_SUPPORTED = 16;

    protected XR10() {
        throw new UnsupportedOperationException();
    }

    public static int nxrGetInstanceProcAddr(long instance, long name, long function) {
        long __functionAddress = XR.getGlobalCommands().xrGetInstanceProcAddr;
        return JNI.callPPPI((long)instance, (long)name, (long)function, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetInstanceProcAddr(@Nullable XrInstance instance, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="PFN_xrVoidFunction *") PointerBuffer function) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.check((CustomBuffer)function, (int)1);
        }
        return XR10.nxrGetInstanceProcAddr(MemoryUtil.memAddressSafe((Pointer)instance), MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddress((CustomBuffer)function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="XrResult")
    public static int xrGetInstanceProcAddr(@Nullable XrInstance instance, @NativeType(value="char const *") CharSequence name, @NativeType(value="PFN_xrVoidFunction *") PointerBuffer function) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)function, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = XR10.nxrGetInstanceProcAddr(MemoryUtil.memAddressSafe((Pointer)instance), nameEncoded, MemoryUtil.memAddress((CustomBuffer)function));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nxrEnumerateApiLayerProperties(int propertyCapacityInput, long propertyCountOutput, long properties) {
        long __functionAddress = XR.getGlobalCommands().xrEnumerateApiLayerProperties;
        return JNI.callPPI((int)propertyCapacityInput, (long)propertyCountOutput, (long)properties, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateApiLayerProperties(@NativeType(value="uint32_t *") IntBuffer propertyCountOutput, @Nullable @NativeType(value="XrApiLayerProperties *") XrApiLayerProperties.Buffer properties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)propertyCountOutput, (int)1);
        }
        return XR10.nxrEnumerateApiLayerProperties(Checks.remainingSafe((CustomBuffer)properties), MemoryUtil.memAddress((IntBuffer)propertyCountOutput), MemoryUtil.memAddressSafe((Pointer)properties));
    }

    public static int nxrEnumerateInstanceExtensionProperties(long layerName, int propertyCapacityInput, long propertyCountOutput, long properties) {
        long __functionAddress = XR.getGlobalCommands().xrEnumerateInstanceExtensionProperties;
        return JNI.callPPPI((long)layerName, (int)propertyCapacityInput, (long)propertyCountOutput, (long)properties, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateInstanceExtensionProperties(@Nullable @NativeType(value="char const *") ByteBuffer layerName, @NativeType(value="uint32_t *") IntBuffer propertyCountOutput, @Nullable @NativeType(value="XrExtensionProperties *") XrExtensionProperties.Buffer properties) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)layerName);
            Checks.check((Buffer)propertyCountOutput, (int)1);
        }
        return XR10.nxrEnumerateInstanceExtensionProperties(MemoryUtil.memAddressSafe((ByteBuffer)layerName), Checks.remainingSafe((CustomBuffer)properties), MemoryUtil.memAddress((IntBuffer)propertyCountOutput), MemoryUtil.memAddressSafe((Pointer)properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="XrResult")
    public static int xrEnumerateInstanceExtensionProperties(@Nullable @NativeType(value="char const *") CharSequence layerName, @NativeType(value="uint32_t *") IntBuffer propertyCountOutput, @Nullable @NativeType(value="XrExtensionProperties *") XrExtensionProperties.Buffer properties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)propertyCountOutput, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(layerName, true);
            long layerNameEncoded = layerName == null ? 0L : stack.getPointerAddress();
            int n = XR10.nxrEnumerateInstanceExtensionProperties(layerNameEncoded, Checks.remainingSafe((CustomBuffer)properties), MemoryUtil.memAddress((IntBuffer)propertyCountOutput), MemoryUtil.memAddressSafe((Pointer)properties));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nxrCreateInstance(long createInfo, long instance) {
        long __functionAddress = XR.getGlobalCommands().xrCreateInstance;
        if (Checks.CHECKS) {
            XrInstanceCreateInfo.validate(createInfo);
        }
        return JNI.callPPI((long)createInfo, (long)instance, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateInstance(@NativeType(value="XrInstanceCreateInfo const *") XrInstanceCreateInfo createInfo, @NativeType(value="XrInstance *") PointerBuffer instance) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)instance, (int)1);
        }
        return XR10.nxrCreateInstance(createInfo.address(), MemoryUtil.memAddress((CustomBuffer)instance));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyInstance(XrInstance instance) {
        long __functionAddress = instance.getCapabilities().xrDestroyInstance;
        return JNI.callPI((long)instance.address(), (long)__functionAddress);
    }

    public static int nxrGetInstanceProperties(XrInstance instance, long instanceProperties) {
        long __functionAddress = instance.getCapabilities().xrGetInstanceProperties;
        return JNI.callPPI((long)instance.address(), (long)instanceProperties, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetInstanceProperties(XrInstance instance, @NativeType(value="XrInstanceProperties *") XrInstanceProperties instanceProperties) {
        return XR10.nxrGetInstanceProperties(instance, instanceProperties.address());
    }

    public static int nxrPollEvent(XrInstance instance, long eventData) {
        long __functionAddress = instance.getCapabilities().xrPollEvent;
        return JNI.callPPI((long)instance.address(), (long)eventData, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPollEvent(XrInstance instance, @NativeType(value="XrEventDataBuffer *") XrEventDataBuffer eventData) {
        return XR10.nxrPollEvent(instance, eventData.address());
    }

    public static int nxrResultToString(XrInstance instance, int value, long buffer) {
        long __functionAddress = instance.getCapabilities().xrResultToString;
        return JNI.callPPI((long)instance.address(), (int)value, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrResultToString(XrInstance instance, @NativeType(value="XrResult") int value, @NativeType(value="char *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (int)64);
        }
        return XR10.nxrResultToString(instance, value, MemoryUtil.memAddress((ByteBuffer)buffer));
    }

    public static int nxrStructureTypeToString(XrInstance instance, int value, long buffer) {
        long __functionAddress = instance.getCapabilities().xrStructureTypeToString;
        return JNI.callPPI((long)instance.address(), (int)value, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrStructureTypeToString(XrInstance instance, @NativeType(value="XrStructureType") int value, @NativeType(value="char *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (int)64);
        }
        return XR10.nxrStructureTypeToString(instance, value, MemoryUtil.memAddress((ByteBuffer)buffer));
    }

    public static int nxrGetSystem(XrInstance instance, long getInfo, long systemId) {
        long __functionAddress = instance.getCapabilities().xrGetSystem;
        return JNI.callPPPI((long)instance.address(), (long)getInfo, (long)systemId, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSystem(XrInstance instance, @NativeType(value="XrSystemGetInfo const *") XrSystemGetInfo getInfo, @NativeType(value="XrSystemId *") LongBuffer systemId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)systemId, (int)1);
        }
        return XR10.nxrGetSystem(instance, getInfo.address(), MemoryUtil.memAddress((LongBuffer)systemId));
    }

    public static int nxrGetSystemProperties(XrInstance instance, long systemId, long properties) {
        long __functionAddress = instance.getCapabilities().xrGetSystemProperties;
        return JNI.callPJPI((long)instance.address(), (long)systemId, (long)properties, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetSystemProperties(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="XrSystemProperties *") XrSystemProperties properties) {
        return XR10.nxrGetSystemProperties(instance, systemId, properties.address());
    }

    public static int nxrEnumerateEnvironmentBlendModes(XrInstance instance, long systemId, int viewConfigurationType, int environmentBlendModeCapacityInput, long environmentBlendModeCountOutput, long environmentBlendModes) {
        long __functionAddress = instance.getCapabilities().xrEnumerateEnvironmentBlendModes;
        return JNI.callPJPPI((long)instance.address(), (long)systemId, (int)viewConfigurationType, (int)environmentBlendModeCapacityInput, (long)environmentBlendModeCountOutput, (long)environmentBlendModes, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateEnvironmentBlendModes(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="XrViewConfigurationType") int viewConfigurationType, @NativeType(value="uint32_t *") IntBuffer environmentBlendModeCountOutput, @Nullable @NativeType(value="XrEnvironmentBlendMode *") IntBuffer environmentBlendModes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)environmentBlendModeCountOutput, (int)1);
        }
        return XR10.nxrEnumerateEnvironmentBlendModes(instance, systemId, viewConfigurationType, Checks.remainingSafe((Buffer)environmentBlendModes), MemoryUtil.memAddress((IntBuffer)environmentBlendModeCountOutput), MemoryUtil.memAddressSafe((IntBuffer)environmentBlendModes));
    }

    public static int nxrCreateSession(XrInstance instance, long createInfo, long session) {
        long __functionAddress = instance.getCapabilities().xrCreateSession;
        return JNI.callPPPI((long)instance.address(), (long)createInfo, (long)session, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSession(XrInstance instance, @NativeType(value="XrSessionCreateInfo const *") XrSessionCreateInfo createInfo, @NativeType(value="XrSession *") PointerBuffer session) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)session, (int)1);
        }
        return XR10.nxrCreateSession(instance, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)session));
    }

    @NativeType(value="XrResult")
    public static int xrDestroySession(XrSession session) {
        long __functionAddress = session.getCapabilities().xrDestroySession;
        return JNI.callPI((long)session.address(), (long)__functionAddress);
    }

    public static int nxrEnumerateReferenceSpaces(XrSession session, int spaceCapacityInput, long spaceCountOutput, long spaces) {
        long __functionAddress = session.getCapabilities().xrEnumerateReferenceSpaces;
        return JNI.callPPPI((long)session.address(), (int)spaceCapacityInput, (long)spaceCountOutput, (long)spaces, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateReferenceSpaces(XrSession session, @NativeType(value="uint32_t *") IntBuffer spaceCountOutput, @Nullable @NativeType(value="XrReferenceSpaceType *") IntBuffer spaces) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)spaceCountOutput, (int)1);
        }
        return XR10.nxrEnumerateReferenceSpaces(session, Checks.remainingSafe((Buffer)spaces), MemoryUtil.memAddress((IntBuffer)spaceCountOutput), MemoryUtil.memAddressSafe((IntBuffer)spaces));
    }

    public static int nxrCreateReferenceSpace(XrSession session, long createInfo, long space) {
        long __functionAddress = session.getCapabilities().xrCreateReferenceSpace;
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)space, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateReferenceSpace(XrSession session, @NativeType(value="XrReferenceSpaceCreateInfo const *") XrReferenceSpaceCreateInfo createInfo, @NativeType(value="XrSpace *") PointerBuffer space) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)space, (int)1);
        }
        return XR10.nxrCreateReferenceSpace(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)space));
    }

    public static int nxrGetReferenceSpaceBoundsRect(XrSession session, int referenceSpaceType, long bounds) {
        long __functionAddress = session.getCapabilities().xrGetReferenceSpaceBoundsRect;
        return JNI.callPPI((long)session.address(), (int)referenceSpaceType, (long)bounds, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetReferenceSpaceBoundsRect(XrSession session, @NativeType(value="XrReferenceSpaceType") int referenceSpaceType, @NativeType(value="XrExtent2Df *") XrExtent2Df bounds) {
        return XR10.nxrGetReferenceSpaceBoundsRect(session, referenceSpaceType, bounds.address());
    }

    public static int nxrCreateActionSpace(XrSession session, long createInfo, long space) {
        long __functionAddress = session.getCapabilities().xrCreateActionSpace;
        if (Checks.CHECKS) {
            XrActionSpaceCreateInfo.validate(createInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)space, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateActionSpace(XrSession session, @NativeType(value="XrActionSpaceCreateInfo const *") XrActionSpaceCreateInfo createInfo, @NativeType(value="XrSpace *") PointerBuffer space) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)space, (int)1);
        }
        return XR10.nxrCreateActionSpace(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)space));
    }

    public static int nxrLocateSpace(XrSpace space, XrSpace baseSpace, long time, long location) {
        long __functionAddress = space.getCapabilities().xrLocateSpace;
        return JNI.callPPJPI((long)space.address(), (long)baseSpace.address(), (long)time, (long)location, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrLocateSpace(XrSpace space, XrSpace baseSpace, @NativeType(value="XrTime") long time, @NativeType(value="XrSpaceLocation *") XrSpaceLocation location) {
        return XR10.nxrLocateSpace(space, baseSpace, time, location.address());
    }

    @NativeType(value="XrResult")
    public static int xrDestroySpace(XrSpace space) {
        long __functionAddress = space.getCapabilities().xrDestroySpace;
        return JNI.callPI((long)space.address(), (long)__functionAddress);
    }

    public static int nxrEnumerateViewConfigurations(XrInstance instance, long systemId, int viewConfigurationsTypeCapacityInput, long viewConfigurationsTypeCountOutput, long viewConfigurationsTypes) {
        long __functionAddress = instance.getCapabilities().xrEnumerateViewConfigurations;
        return JNI.callPJPPI((long)instance.address(), (long)systemId, (int)viewConfigurationsTypeCapacityInput, (long)viewConfigurationsTypeCountOutput, (long)viewConfigurationsTypes, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateViewConfigurations(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="uint32_t *") IntBuffer viewConfigurationsTypeCountOutput, @Nullable @NativeType(value="XrViewConfigurationType *") IntBuffer viewConfigurationsTypes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)viewConfigurationsTypeCountOutput, (int)1);
        }
        return XR10.nxrEnumerateViewConfigurations(instance, systemId, Checks.remainingSafe((Buffer)viewConfigurationsTypes), MemoryUtil.memAddress((IntBuffer)viewConfigurationsTypeCountOutput), MemoryUtil.memAddressSafe((IntBuffer)viewConfigurationsTypes));
    }

    public static int nxrGetViewConfigurationProperties(XrInstance instance, long systemId, int viewConfigurationType, long configurationProperties) {
        long __functionAddress = instance.getCapabilities().xrGetViewConfigurationProperties;
        return JNI.callPJPI((long)instance.address(), (long)systemId, (int)viewConfigurationType, (long)configurationProperties, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetViewConfigurationProperties(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="XrViewConfigurationType") int viewConfigurationType, @NativeType(value="XrViewConfigurationProperties *") XrViewConfigurationProperties configurationProperties) {
        return XR10.nxrGetViewConfigurationProperties(instance, systemId, viewConfigurationType, configurationProperties.address());
    }

    public static int nxrEnumerateViewConfigurationViews(XrInstance instance, long systemId, int viewConfigurationType, int viewCapacityInput, long viewCountOutput, long views) {
        long __functionAddress = instance.getCapabilities().xrEnumerateViewConfigurationViews;
        return JNI.callPJPPI((long)instance.address(), (long)systemId, (int)viewConfigurationType, (int)viewCapacityInput, (long)viewCountOutput, (long)views, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateViewConfigurationViews(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="XrViewConfigurationType") int viewConfigurationType, @NativeType(value="uint32_t *") IntBuffer viewCountOutput, @Nullable @NativeType(value="XrViewConfigurationView *") XrViewConfigurationView.Buffer views) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)viewCountOutput, (int)1);
        }
        return XR10.nxrEnumerateViewConfigurationViews(instance, systemId, viewConfigurationType, Checks.remainingSafe((CustomBuffer)views), MemoryUtil.memAddress((IntBuffer)viewCountOutput), MemoryUtil.memAddressSafe((Pointer)views));
    }

    public static int nxrEnumerateSwapchainFormats(XrSession session, int formatCapacityInput, long formatCountOutput, long formats) {
        long __functionAddress = session.getCapabilities().xrEnumerateSwapchainFormats;
        return JNI.callPPPI((long)session.address(), (int)formatCapacityInput, (long)formatCountOutput, (long)formats, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateSwapchainFormats(XrSession session, @NativeType(value="uint32_t *") IntBuffer formatCountOutput, @Nullable @NativeType(value="int64_t *") LongBuffer formats) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)formatCountOutput, (int)1);
        }
        return XR10.nxrEnumerateSwapchainFormats(session, Checks.remainingSafe((Buffer)formats), MemoryUtil.memAddress((IntBuffer)formatCountOutput), MemoryUtil.memAddressSafe((LongBuffer)formats));
    }

    public static int nxrCreateSwapchain(XrSession session, long createInfo, long swapchain) {
        long __functionAddress = session.getCapabilities().xrCreateSwapchain;
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)swapchain, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSwapchain(XrSession session, @NativeType(value="XrSwapchainCreateInfo const *") XrSwapchainCreateInfo createInfo, @NativeType(value="XrSwapchain *") PointerBuffer swapchain) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)swapchain, (int)1);
        }
        return XR10.nxrCreateSwapchain(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)swapchain));
    }

    @NativeType(value="XrResult")
    public static int xrDestroySwapchain(XrSwapchain swapchain) {
        long __functionAddress = swapchain.getCapabilities().xrDestroySwapchain;
        return JNI.callPI((long)swapchain.address(), (long)__functionAddress);
    }

    public static int nxrEnumerateSwapchainImages(XrSwapchain swapchain, int imageCapacityInput, long imageCountOutput, long images) {
        long __functionAddress = swapchain.getCapabilities().xrEnumerateSwapchainImages;
        return JNI.callPPPI((long)swapchain.address(), (int)imageCapacityInput, (long)imageCountOutput, (long)images, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateSwapchainImages(XrSwapchain swapchain, @NativeType(value="uint32_t *") IntBuffer imageCountOutput, @Nullable @NativeType(value="XrSwapchainImageBaseHeader *") XrSwapchainImageBaseHeader.Buffer images) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)imageCountOutput, (int)1);
        }
        return XR10.nxrEnumerateSwapchainImages(swapchain, Checks.remainingSafe((CustomBuffer)images), MemoryUtil.memAddress((IntBuffer)imageCountOutput), MemoryUtil.memAddressSafe((Pointer)images));
    }

    public static int nxrAcquireSwapchainImage(XrSwapchain swapchain, long acquireInfo, long index) {
        long __functionAddress = swapchain.getCapabilities().xrAcquireSwapchainImage;
        return JNI.callPPPI((long)swapchain.address(), (long)acquireInfo, (long)index, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrAcquireSwapchainImage(XrSwapchain swapchain, @Nullable @NativeType(value="XrSwapchainImageAcquireInfo const *") XrSwapchainImageAcquireInfo acquireInfo, @NativeType(value="uint32_t *") IntBuffer index) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)index, (int)1);
        }
        return XR10.nxrAcquireSwapchainImage(swapchain, MemoryUtil.memAddressSafe((Pointer)acquireInfo), MemoryUtil.memAddress((IntBuffer)index));
    }

    public static int nxrWaitSwapchainImage(XrSwapchain swapchain, long waitInfo) {
        long __functionAddress = swapchain.getCapabilities().xrWaitSwapchainImage;
        return JNI.callPPI((long)swapchain.address(), (long)waitInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrWaitSwapchainImage(XrSwapchain swapchain, @NativeType(value="XrSwapchainImageWaitInfo const *") XrSwapchainImageWaitInfo waitInfo) {
        return XR10.nxrWaitSwapchainImage(swapchain, waitInfo.address());
    }

    public static int nxrReleaseSwapchainImage(XrSwapchain swapchain, long releaseInfo) {
        long __functionAddress = swapchain.getCapabilities().xrReleaseSwapchainImage;
        return JNI.callPPI((long)swapchain.address(), (long)releaseInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrReleaseSwapchainImage(XrSwapchain swapchain, @Nullable @NativeType(value="XrSwapchainImageReleaseInfo const *") XrSwapchainImageReleaseInfo releaseInfo) {
        return XR10.nxrReleaseSwapchainImage(swapchain, MemoryUtil.memAddressSafe((Pointer)releaseInfo));
    }

    public static int nxrBeginSession(XrSession session, long beginInfo) {
        long __functionAddress = session.getCapabilities().xrBeginSession;
        return JNI.callPPI((long)session.address(), (long)beginInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrBeginSession(XrSession session, @NativeType(value="XrSessionBeginInfo const *") XrSessionBeginInfo beginInfo) {
        return XR10.nxrBeginSession(session, beginInfo.address());
    }

    @NativeType(value="XrResult")
    public static int xrEndSession(XrSession session) {
        long __functionAddress = session.getCapabilities().xrEndSession;
        return JNI.callPI((long)session.address(), (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrRequestExitSession(XrSession session) {
        long __functionAddress = session.getCapabilities().xrRequestExitSession;
        return JNI.callPI((long)session.address(), (long)__functionAddress);
    }

    public static int nxrWaitFrame(XrSession session, long frameWaitInfo, long frameState) {
        long __functionAddress = session.getCapabilities().xrWaitFrame;
        return JNI.callPPPI((long)session.address(), (long)frameWaitInfo, (long)frameState, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrWaitFrame(XrSession session, @Nullable @NativeType(value="XrFrameWaitInfo const *") XrFrameWaitInfo frameWaitInfo, @NativeType(value="XrFrameState *") XrFrameState frameState) {
        return XR10.nxrWaitFrame(session, MemoryUtil.memAddressSafe((Pointer)frameWaitInfo), frameState.address());
    }

    public static int nxrBeginFrame(XrSession session, long frameBeginInfo) {
        long __functionAddress = session.getCapabilities().xrBeginFrame;
        return JNI.callPPI((long)session.address(), (long)frameBeginInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrBeginFrame(XrSession session, @Nullable @NativeType(value="XrFrameBeginInfo const *") XrFrameBeginInfo frameBeginInfo) {
        return XR10.nxrBeginFrame(session, MemoryUtil.memAddressSafe((Pointer)frameBeginInfo));
    }

    public static int nxrEndFrame(XrSession session, long frameEndInfo) {
        long __functionAddress = session.getCapabilities().xrEndFrame;
        return JNI.callPPI((long)session.address(), (long)frameEndInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEndFrame(XrSession session, @NativeType(value="XrFrameEndInfo const *") XrFrameEndInfo frameEndInfo) {
        return XR10.nxrEndFrame(session, frameEndInfo.address());
    }

    public static int nxrLocateViews(XrSession session, long viewLocateInfo, long viewState, int viewCapacityInput, long viewCountOutput, long views) {
        long __functionAddress = session.getCapabilities().xrLocateViews;
        if (Checks.CHECKS) {
            XrViewLocateInfo.validate(viewLocateInfo);
        }
        return JNI.callPPPPPI((long)session.address(), (long)viewLocateInfo, (long)viewState, (int)viewCapacityInput, (long)viewCountOutput, (long)views, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrLocateViews(XrSession session, @NativeType(value="XrViewLocateInfo const *") XrViewLocateInfo viewLocateInfo, @NativeType(value="XrViewState *") XrViewState viewState, @NativeType(value="uint32_t *") IntBuffer viewCountOutput, @Nullable @NativeType(value="XrView *") XrView.Buffer views) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)viewCountOutput, (int)1);
        }
        return XR10.nxrLocateViews(session, viewLocateInfo.address(), viewState.address(), Checks.remainingSafe((CustomBuffer)views), MemoryUtil.memAddress((IntBuffer)viewCountOutput), MemoryUtil.memAddressSafe((Pointer)views));
    }

    public static int nxrStringToPath(XrInstance instance, long pathString, long path) {
        long __functionAddress = instance.getCapabilities().xrStringToPath;
        return JNI.callPPPI((long)instance.address(), (long)pathString, (long)path, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrStringToPath(XrInstance instance, @NativeType(value="char const *") ByteBuffer pathString, @NativeType(value="XrPath *") LongBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pathString);
            Checks.check((Buffer)path, (int)1);
        }
        return XR10.nxrStringToPath(instance, MemoryUtil.memAddress((ByteBuffer)pathString), MemoryUtil.memAddress((LongBuffer)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="XrResult")
    public static int xrStringToPath(XrInstance instance, @NativeType(value="char const *") CharSequence pathString, @NativeType(value="XrPath *") LongBuffer path) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)path, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(pathString, true);
            long pathStringEncoded = stack.getPointerAddress();
            int n = XR10.nxrStringToPath(instance, pathStringEncoded, MemoryUtil.memAddress((LongBuffer)path));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nxrPathToString(XrInstance instance, long path, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = instance.getCapabilities().xrPathToString;
        return JNI.callPJPPI((long)instance.address(), (long)path, (int)bufferCapacityInput, (long)bufferCountOutput, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPathToString(XrInstance instance, @NativeType(value="XrPath") long path, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @Nullable @NativeType(value="char *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, (int)1);
        }
        return XR10.nxrPathToString(instance, path, Checks.remainingSafe((Buffer)buffer), MemoryUtil.memAddress((IntBuffer)bufferCountOutput), MemoryUtil.memAddressSafe((ByteBuffer)buffer));
    }

    public static int nxrCreateActionSet(XrInstance instance, long createInfo, long actionSet) {
        long __functionAddress = instance.getCapabilities().xrCreateActionSet;
        return JNI.callPPPI((long)instance.address(), (long)createInfo, (long)actionSet, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateActionSet(XrInstance instance, @NativeType(value="XrActionSetCreateInfo const *") XrActionSetCreateInfo createInfo, @NativeType(value="XrActionSet *") PointerBuffer actionSet) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)actionSet, (int)1);
        }
        return XR10.nxrCreateActionSet(instance, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)actionSet));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyActionSet(XrActionSet actionSet) {
        long __functionAddress = actionSet.getCapabilities().xrDestroyActionSet;
        return JNI.callPI((long)actionSet.address(), (long)__functionAddress);
    }

    public static int nxrCreateAction(XrActionSet actionSet, long createInfo, long action) {
        long __functionAddress = actionSet.getCapabilities().xrCreateAction;
        return JNI.callPPPI((long)actionSet.address(), (long)createInfo, (long)action, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateAction(XrActionSet actionSet, @NativeType(value="XrActionCreateInfo const *") XrActionCreateInfo createInfo, @NativeType(value="XrAction *") PointerBuffer action) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)action, (int)1);
        }
        return XR10.nxrCreateAction(actionSet, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)action));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyAction(XrAction action) {
        long __functionAddress = action.getCapabilities().xrDestroyAction;
        return JNI.callPI((long)action.address(), (long)__functionAddress);
    }

    public static int nxrSuggestInteractionProfileBindings(XrInstance instance, long suggestedBindings) {
        long __functionAddress = instance.getCapabilities().xrSuggestInteractionProfileBindings;
        if (Checks.CHECKS) {
            XrInteractionProfileSuggestedBinding.validate(suggestedBindings);
        }
        return JNI.callPPI((long)instance.address(), (long)suggestedBindings, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSuggestInteractionProfileBindings(XrInstance instance, @NativeType(value="XrInteractionProfileSuggestedBinding const *") XrInteractionProfileSuggestedBinding suggestedBindings) {
        return XR10.nxrSuggestInteractionProfileBindings(instance, suggestedBindings.address());
    }

    public static int nxrAttachSessionActionSets(XrSession session, long attachInfo) {
        long __functionAddress = session.getCapabilities().xrAttachSessionActionSets;
        if (Checks.CHECKS) {
            XrSessionActionSetsAttachInfo.validate(attachInfo);
        }
        return JNI.callPPI((long)session.address(), (long)attachInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrAttachSessionActionSets(XrSession session, @NativeType(value="XrSessionActionSetsAttachInfo const *") XrSessionActionSetsAttachInfo attachInfo) {
        return XR10.nxrAttachSessionActionSets(session, attachInfo.address());
    }

    public static int nxrGetCurrentInteractionProfile(XrSession session, long topLevelUserPath, long interactionProfile) {
        long __functionAddress = session.getCapabilities().xrGetCurrentInteractionProfile;
        return JNI.callPJPI((long)session.address(), (long)topLevelUserPath, (long)interactionProfile, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetCurrentInteractionProfile(XrSession session, @NativeType(value="XrPath") long topLevelUserPath, @NativeType(value="XrInteractionProfileState *") XrInteractionProfileState interactionProfile) {
        return XR10.nxrGetCurrentInteractionProfile(session, topLevelUserPath, interactionProfile.address());
    }

    public static int nxrGetActionStateBoolean(XrSession session, long getInfo, long state) {
        long __functionAddress = session.getCapabilities().xrGetActionStateBoolean;
        if (Checks.CHECKS) {
            XrActionStateGetInfo.validate(getInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)getInfo, (long)state, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetActionStateBoolean(XrSession session, @NativeType(value="XrActionStateGetInfo const *") XrActionStateGetInfo getInfo, @NativeType(value="XrActionStateBoolean *") XrActionStateBoolean state) {
        return XR10.nxrGetActionStateBoolean(session, getInfo.address(), state.address());
    }

    public static int nxrGetActionStateFloat(XrSession session, long getInfo, long state) {
        long __functionAddress = session.getCapabilities().xrGetActionStateFloat;
        if (Checks.CHECKS) {
            XrActionStateGetInfo.validate(getInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)getInfo, (long)state, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetActionStateFloat(XrSession session, @NativeType(value="XrActionStateGetInfo const *") XrActionStateGetInfo getInfo, @NativeType(value="XrActionStateFloat *") XrActionStateFloat state) {
        return XR10.nxrGetActionStateFloat(session, getInfo.address(), state.address());
    }

    public static int nxrGetActionStateVector2f(XrSession session, long getInfo, long state) {
        long __functionAddress = session.getCapabilities().xrGetActionStateVector2f;
        if (Checks.CHECKS) {
            XrActionStateGetInfo.validate(getInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)getInfo, (long)state, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetActionStateVector2f(XrSession session, @NativeType(value="XrActionStateGetInfo const *") XrActionStateGetInfo getInfo, @NativeType(value="XrActionStateVector2f *") XrActionStateVector2f state) {
        return XR10.nxrGetActionStateVector2f(session, getInfo.address(), state.address());
    }

    public static int nxrGetActionStatePose(XrSession session, long getInfo, long state) {
        long __functionAddress = session.getCapabilities().xrGetActionStatePose;
        if (Checks.CHECKS) {
            XrActionStateGetInfo.validate(getInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)getInfo, (long)state, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetActionStatePose(XrSession session, @NativeType(value="XrActionStateGetInfo const *") XrActionStateGetInfo getInfo, @NativeType(value="XrActionStatePose *") XrActionStatePose state) {
        return XR10.nxrGetActionStatePose(session, getInfo.address(), state.address());
    }

    public static int nxrSyncActions(XrSession session, long syncInfo) {
        long __functionAddress = session.getCapabilities().xrSyncActions;
        return JNI.callPPI((long)session.address(), (long)syncInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSyncActions(XrSession session, @NativeType(value="XrActionsSyncInfo const *") XrActionsSyncInfo syncInfo) {
        return XR10.nxrSyncActions(session, syncInfo.address());
    }

    public static int nxrEnumerateBoundSourcesForAction(XrSession session, long enumerateInfo, int sourceCapacityInput, long sourceCountOutput, long sources) {
        long __functionAddress = session.getCapabilities().xrEnumerateBoundSourcesForAction;
        if (Checks.CHECKS) {
            XrBoundSourcesForActionEnumerateInfo.validate(enumerateInfo);
        }
        return JNI.callPPPPI((long)session.address(), (long)enumerateInfo, (int)sourceCapacityInput, (long)sourceCountOutput, (long)sources, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnumerateBoundSourcesForAction(XrSession session, @NativeType(value="XrBoundSourcesForActionEnumerateInfo const *") XrBoundSourcesForActionEnumerateInfo enumerateInfo, @NativeType(value="uint32_t *") IntBuffer sourceCountOutput, @Nullable @NativeType(value="XrPath *") LongBuffer sources) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)sourceCountOutput, (int)1);
        }
        return XR10.nxrEnumerateBoundSourcesForAction(session, enumerateInfo.address(), Checks.remainingSafe((Buffer)sources), MemoryUtil.memAddress((IntBuffer)sourceCountOutput), MemoryUtil.memAddressSafe((LongBuffer)sources));
    }

    public static int nxrGetInputSourceLocalizedName(XrSession session, long getInfo, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = session.getCapabilities().xrGetInputSourceLocalizedName;
        return JNI.callPPPPI((long)session.address(), (long)getInfo, (int)bufferCapacityInput, (long)bufferCountOutput, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetInputSourceLocalizedName(XrSession session, @NativeType(value="XrInputSourceLocalizedNameGetInfo const *") XrInputSourceLocalizedNameGetInfo getInfo, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @Nullable @NativeType(value="char *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, (int)1);
        }
        return XR10.nxrGetInputSourceLocalizedName(session, getInfo.address(), Checks.remainingSafe((Buffer)buffer), MemoryUtil.memAddress((IntBuffer)bufferCountOutput), MemoryUtil.memAddressSafe((ByteBuffer)buffer));
    }

    public static int nxrApplyHapticFeedback(XrSession session, long hapticActionInfo, long hapticFeedback) {
        long __functionAddress = session.getCapabilities().xrApplyHapticFeedback;
        if (Checks.CHECKS) {
            XrHapticActionInfo.validate(hapticActionInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)hapticActionInfo, (long)hapticFeedback, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrApplyHapticFeedback(XrSession session, @NativeType(value="XrHapticActionInfo const *") XrHapticActionInfo hapticActionInfo, @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader hapticFeedback) {
        return XR10.nxrApplyHapticFeedback(session, hapticActionInfo.address(), hapticFeedback.address());
    }

    public static int nxrStopHapticFeedback(XrSession session, long hapticActionInfo) {
        long __functionAddress = session.getCapabilities().xrStopHapticFeedback;
        if (Checks.CHECKS) {
            XrHapticActionInfo.validate(hapticActionInfo);
        }
        return JNI.callPPI((long)session.address(), (long)hapticActionInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrStopHapticFeedback(XrSession session, @NativeType(value="XrHapticActionInfo const *") XrHapticActionInfo hapticActionInfo) {
        return XR10.nxrStopHapticFeedback(session, hapticActionInfo.address());
    }

    @NativeType(value="uint64_t")
    public static long XR_MAKE_VERSION(@NativeType(value="uint16_t") int major, @NativeType(value="uint16_t") int minor, @NativeType(value="uint32_t") int patch) {
        return ((long)major & 0xFFFFL) << 48 | ((long)minor & 0xFFFFL) << 32 | (long)patch & 0xFFFFFFFFL;
    }

    @NativeType(value="uint16_t")
    public static short XR_VERSION_MAJOR(@NativeType(value="uint64_t") long version) {
        return (short)(version >> 48 & 0xFFFFL);
    }

    @NativeType(value="uint16_t")
    public static short XR_VERSION_MINOR(@NativeType(value="uint64_t") long version) {
        return (short)(version >> 32 & 0xFFFFL);
    }

    @NativeType(value="uint32_t")
    public static int XR_VERSION_PATCH(@NativeType(value="uint64_t") long version) {
        return (int)(version & 0xFFFFFFFFL);
    }

    @NativeType(value="bool")
    public static boolean XR_SUCCEEDED(int result) {
        return result >= 0;
    }

    @NativeType(value="bool")
    public static boolean XR_UNQUALIFIED_SUCCESS(int result) {
        return result == 0;
    }

    @NativeType(value="bool")
    public static boolean XR_FAILED(int result) {
        return result < 0;
    }
}

