/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionCreateInfo
extends Struct<XrActionCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTIONNAME;
    public static final int ACTIONTYPE;
    public static final int COUNTSUBACTIONPATHS;
    public static final int SUBACTIONPATHS;
    public static final int LOCALIZEDACTIONNAME;

    protected XrActionCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActionCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrActionCreateInfo(address, container);
    }

    public XrActionCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionCreateInfo.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
    public ByteBuffer actionName() {
        return XrActionCreateInfo.nactionName(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
    public String actionNameString() {
        return XrActionCreateInfo.nactionNameString(this.address());
    }

    @NativeType(value="XrActionType")
    public int actionType() {
        return XrActionCreateInfo.nactionType(this.address());
    }

    @NativeType(value="uint32_t")
    public int countSubactionPaths() {
        return XrActionCreateInfo.ncountSubactionPaths(this.address());
    }

    @Nullable
    @NativeType(value="XrPath const *")
    public LongBuffer subactionPaths() {
        return XrActionCreateInfo.nsubactionPaths(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
    public ByteBuffer localizedActionName() {
        return XrActionCreateInfo.nlocalizedActionName(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
    public String localizedActionNameString() {
        return XrActionCreateInfo.nlocalizedActionNameString(this.address());
    }

    public XrActionCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionCreateInfo type$Default() {
        return this.type(29);
    }

    public XrActionCreateInfo next(@NativeType(value="void const *") long value) {
        XrActionCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionCreateInfo actionName(@NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]") ByteBuffer value) {
        XrActionCreateInfo.nactionName(this.address(), value);
        return this;
    }

    public XrActionCreateInfo actionType(@NativeType(value="XrActionType") int value) {
        XrActionCreateInfo.nactionType(this.address(), value);
        return this;
    }

    public XrActionCreateInfo countSubactionPaths(@NativeType(value="uint32_t") int value) {
        XrActionCreateInfo.ncountSubactionPaths(this.address(), value);
        return this;
    }

    public XrActionCreateInfo subactionPaths(@Nullable @NativeType(value="XrPath const *") LongBuffer value) {
        XrActionCreateInfo.nsubactionPaths(this.address(), value);
        return this;
    }

    public XrActionCreateInfo localizedActionName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]") ByteBuffer value) {
        XrActionCreateInfo.nlocalizedActionName(this.address(), value);
        return this;
    }

    public XrActionCreateInfo set(int type, long next, ByteBuffer actionName, int actionType, int countSubactionPaths, @Nullable LongBuffer subactionPaths, ByteBuffer localizedActionName) {
        this.type(type);
        this.next(next);
        this.actionName(actionName);
        this.actionType(actionType);
        this.countSubactionPaths(countSubactionPaths);
        this.subactionPaths(subactionPaths);
        this.localizedActionName(localizedActionName);
        return this;
    }

    public XrActionCreateInfo set(XrActionCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionCreateInfo malloc() {
        return new XrActionCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActionCreateInfo calloc() {
        return new XrActionCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActionCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActionCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActionCreateInfo create(long address) {
        return new XrActionCreateInfo(address, null);
    }

    @Nullable
    public static XrActionCreateInfo createSafe(long address) {
        return address == 0L ? null : new XrActionCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActionCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionCreateInfo malloc(MemoryStack stack) {
        return new XrActionCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionCreateInfo calloc(MemoryStack stack) {
        return new XrActionCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nactionName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)ACTIONNAME), (int)64);
    }

    public static String nactionNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)ACTIONNAME));
    }

    public static int nactionType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ACTIONTYPE);
    }

    public static int ncountSubactionPaths(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNTSUBACTIONPATHS);
    }

    @Nullable
    public static LongBuffer nsubactionPaths(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)SUBACTIONPATHS)), (int)XrActionCreateInfo.ncountSubactionPaths(struct));
    }

    public static ByteBuffer nlocalizedActionName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LOCALIZEDACTIONNAME), (int)128);
    }

    public static String nlocalizedActionNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)LOCALIZEDACTIONNAME));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nactionName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)ACTIONNAME), (long)value.remaining());
    }

    public static void nactionType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ACTIONTYPE, value);
    }

    public static void ncountSubactionPaths(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COUNTSUBACTIONPATHS, value);
    }

    public static void nsubactionPaths(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SUBACTIONPATHS), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        if (value != null) {
            XrActionCreateInfo.ncountSubactionPaths(struct, value.remaining());
        }
    }

    public static void nlocalizedActionName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)128);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LOCALIZEDACTIONNAME), (long)value.remaining());
    }

    static {
        Struct.Layout layout = XrActionCreateInfo.__struct((Struct.Member[])new Struct.Member[]{XrActionCreateInfo.__member((int)4), XrActionCreateInfo.__member((int)POINTER_SIZE), XrActionCreateInfo.__array((int)1, (int)64), XrActionCreateInfo.__member((int)4), XrActionCreateInfo.__member((int)4), XrActionCreateInfo.__member((int)POINTER_SIZE), XrActionCreateInfo.__array((int)1, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTIONNAME = layout.offsetof(2);
        ACTIONTYPE = layout.offsetof(3);
        COUNTSUBACTIONPATHS = layout.offsetof(4);
        SUBACTIONPATHS = layout.offsetof(5);
        LOCALIZEDACTIONNAME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrActionCreateInfo, Buffer>
    implements NativeResource {
        private static final XrActionCreateInfo ELEMENT_FACTORY = XrActionCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActionCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionCreateInfo.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
        public ByteBuffer actionName() {
            return XrActionCreateInfo.nactionName(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]")
        public String actionNameString() {
            return XrActionCreateInfo.nactionNameString(this.address());
        }

        @NativeType(value="XrActionType")
        public int actionType() {
            return XrActionCreateInfo.nactionType(this.address());
        }

        @NativeType(value="uint32_t")
        public int countSubactionPaths() {
            return XrActionCreateInfo.ncountSubactionPaths(this.address());
        }

        @Nullable
        @NativeType(value="XrPath const *")
        public LongBuffer subactionPaths() {
            return XrActionCreateInfo.nsubactionPaths(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
        public ByteBuffer localizedActionName() {
            return XrActionCreateInfo.nlocalizedActionName(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]")
        public String localizedActionNameString() {
            return XrActionCreateInfo.nlocalizedActionNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(29);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer actionName(@NativeType(value="char[XR_MAX_ACTION_NAME_SIZE]") ByteBuffer value) {
            XrActionCreateInfo.nactionName(this.address(), value);
            return this;
        }

        public Buffer actionType(@NativeType(value="XrActionType") int value) {
            XrActionCreateInfo.nactionType(this.address(), value);
            return this;
        }

        public Buffer countSubactionPaths(@NativeType(value="uint32_t") int value) {
            XrActionCreateInfo.ncountSubactionPaths(this.address(), value);
            return this;
        }

        public Buffer subactionPaths(@Nullable @NativeType(value="XrPath const *") LongBuffer value) {
            XrActionCreateInfo.nsubactionPaths(this.address(), value);
            return this;
        }

        public Buffer localizedActionName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_NAME_SIZE]") ByteBuffer value) {
            XrActionCreateInfo.nlocalizedActionName(this.address(), value);
            return this;
        }
    }
}

