/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionStateGetInfo
extends Struct<XrActionStateGetInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int SUBACTIONPATH;

    protected XrActionStateGetInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActionStateGetInfo create(long address, @Nullable ByteBuffer container) {
        return new XrActionStateGetInfo(address, container);
    }

    public XrActionStateGetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionStateGetInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionStateGetInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionStateGetInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrActionStateGetInfo.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrActionStateGetInfo.nsubactionPath(this.address());
    }

    public XrActionStateGetInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionStateGetInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionStateGetInfo type$Default() {
        return this.type(58);
    }

    public XrActionStateGetInfo next(@NativeType(value="void const *") long value) {
        XrActionStateGetInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionStateGetInfo action(XrAction value) {
        XrActionStateGetInfo.naction(this.address(), value);
        return this;
    }

    public XrActionStateGetInfo subactionPath(@NativeType(value="XrPath") long value) {
        XrActionStateGetInfo.nsubactionPath(this.address(), value);
        return this;
    }

    public XrActionStateGetInfo set(int type, long next, XrAction action, long subactionPath) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.subactionPath(subactionPath);
        return this;
    }

    public XrActionStateGetInfo set(XrActionStateGetInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionStateGetInfo malloc() {
        return new XrActionStateGetInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActionStateGetInfo calloc() {
        return new XrActionStateGetInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActionStateGetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActionStateGetInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActionStateGetInfo create(long address) {
        return new XrActionStateGetInfo(address, null);
    }

    @Nullable
    public static XrActionStateGetInfo createSafe(long address) {
        return address == 0L ? null : new XrActionStateGetInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActionStateGetInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionStateGetInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionStateGetInfo malloc(MemoryStack stack) {
        return new XrActionStateGetInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionStateGetInfo calloc(MemoryStack stack) {
        return new XrActionStateGetInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTION));
    }

    public static long nsubactionPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBACTIONPATH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTION), (long)value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBACTIONPATH, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTION)));
    }

    static {
        Struct.Layout layout = XrActionStateGetInfo.__struct((Struct.Member[])new Struct.Member[]{XrActionStateGetInfo.__member((int)4), XrActionStateGetInfo.__member((int)POINTER_SIZE), XrActionStateGetInfo.__member((int)POINTER_SIZE), XrActionStateGetInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        SUBACTIONPATH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrActionStateGetInfo, Buffer>
    implements NativeResource {
        private static final XrActionStateGetInfo ELEMENT_FACTORY = XrActionStateGetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActionStateGetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionStateGetInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionStateGetInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrActionStateGetInfo.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrActionStateGetInfo.nsubactionPath(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionStateGetInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(58);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionStateGetInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrActionStateGetInfo.naction(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrActionStateGetInfo.nsubactionPath(this.address(), value);
            return this;
        }
    }
}

