/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBaseOutStructure
extends Struct<XrBaseOutStructure>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrBaseOutStructure(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBaseOutStructure create(long address, @Nullable ByteBuffer container) {
        return new XrBaseOutStructure(address, container);
    }

    public XrBaseOutStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBaseOutStructure.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBaseOutStructure.ntype(this.address());
    }

    @NativeType(value="XrBaseOutStructure *")
    public XrBaseOutStructure next() {
        return XrBaseOutStructure.nnext(this.address());
    }

    public XrBaseOutStructure type(@NativeType(value="XrStructureType") int value) {
        XrBaseOutStructure.ntype(this.address(), value);
        return this;
    }

    public XrBaseOutStructure next(@NativeType(value="XrBaseOutStructure *") XrBaseOutStructure value) {
        XrBaseOutStructure.nnext(this.address(), value);
        return this;
    }

    public XrBaseOutStructure set(int type, XrBaseOutStructure next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBaseOutStructure set(XrBaseOutStructure src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBaseOutStructure malloc() {
        return new XrBaseOutStructure(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBaseOutStructure calloc() {
        return new XrBaseOutStructure(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBaseOutStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBaseOutStructure(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBaseOutStructure create(long address) {
        return new XrBaseOutStructure(address, null);
    }

    @Nullable
    public static XrBaseOutStructure createSafe(long address) {
        return address == 0L ? null : new XrBaseOutStructure(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBaseOutStructure.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBaseOutStructure.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBaseOutStructure malloc(MemoryStack stack) {
        return new XrBaseOutStructure(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBaseOutStructure calloc(MemoryStack stack) {
        return new XrBaseOutStructure(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static XrBaseOutStructure nnext(long struct) {
        return XrBaseOutStructure.create(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, XrBaseOutStructure value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    static {
        Struct.Layout layout = XrBaseOutStructure.__struct((Struct.Member[])new Struct.Member[]{XrBaseOutStructure.__member((int)4), XrBaseOutStructure.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBaseOutStructure, Buffer>
    implements NativeResource {
        private static final XrBaseOutStructure ELEMENT_FACTORY = XrBaseOutStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBaseOutStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBaseOutStructure.ntype(this.address());
        }

        @NativeType(value="XrBaseOutStructure *")
        public XrBaseOutStructure next() {
            return XrBaseOutStructure.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBaseOutStructure.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="XrBaseOutStructure *") XrBaseOutStructure value) {
            XrBaseOutStructure.nnext(this.address(), value);
            return this;
        }
    }
}

