/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodySkeletonJointFB
extends Struct<XrBodySkeletonJointFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int JOINT;
    public static final int PARENTJOINT;
    public static final int POSE;

    protected XrBodySkeletonJointFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBodySkeletonJointFB create(long address, @Nullable ByteBuffer container) {
        return new XrBodySkeletonJointFB(address, container);
    }

    public XrBodySkeletonJointFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodySkeletonJointFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int joint() {
        return XrBodySkeletonJointFB.njoint(this.address());
    }

    @NativeType(value="int32_t")
    public int parentJoint() {
        return XrBodySkeletonJointFB.nparentJoint(this.address());
    }

    public XrPosef pose() {
        return XrBodySkeletonJointFB.npose(this.address());
    }

    public XrBodySkeletonJointFB joint(@NativeType(value="int32_t") int value) {
        XrBodySkeletonJointFB.njoint(this.address(), value);
        return this;
    }

    public XrBodySkeletonJointFB parentJoint(@NativeType(value="int32_t") int value) {
        XrBodySkeletonJointFB.nparentJoint(this.address(), value);
        return this;
    }

    public XrBodySkeletonJointFB pose(XrPosef value) {
        XrBodySkeletonJointFB.npose(this.address(), value);
        return this;
    }

    public XrBodySkeletonJointFB pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrBodySkeletonJointFB set(int joint, int parentJoint, XrPosef pose) {
        this.joint(joint);
        this.parentJoint(parentJoint);
        this.pose(pose);
        return this;
    }

    public XrBodySkeletonJointFB set(XrBodySkeletonJointFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodySkeletonJointFB malloc() {
        return new XrBodySkeletonJointFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBodySkeletonJointFB calloc() {
        return new XrBodySkeletonJointFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBodySkeletonJointFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBodySkeletonJointFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBodySkeletonJointFB create(long address) {
        return new XrBodySkeletonJointFB(address, null);
    }

    @Nullable
    public static XrBodySkeletonJointFB createSafe(long address) {
        return address == 0L ? null : new XrBodySkeletonJointFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBodySkeletonJointFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodySkeletonJointFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodySkeletonJointFB malloc(MemoryStack stack) {
        return new XrBodySkeletonJointFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodySkeletonJointFB calloc(MemoryStack stack) {
        return new XrBodySkeletonJointFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int njoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)JOINT);
    }

    public static int nparentJoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)PARENTJOINT);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void njoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)JOINT, value);
    }

    public static void nparentJoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PARENTJOINT, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrBodySkeletonJointFB.__struct((Struct.Member[])new Struct.Member[]{XrBodySkeletonJointFB.__member((int)4), XrBodySkeletonJointFB.__member((int)4), XrBodySkeletonJointFB.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        JOINT = layout.offsetof(0);
        PARENTJOINT = layout.offsetof(1);
        POSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBodySkeletonJointFB, Buffer>
    implements NativeResource {
        private static final XrBodySkeletonJointFB ELEMENT_FACTORY = XrBodySkeletonJointFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBodySkeletonJointFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int joint() {
            return XrBodySkeletonJointFB.njoint(this.address());
        }

        @NativeType(value="int32_t")
        public int parentJoint() {
            return XrBodySkeletonJointFB.nparentJoint(this.address());
        }

        public XrPosef pose() {
            return XrBodySkeletonJointFB.npose(this.address());
        }

        public Buffer joint(@NativeType(value="int32_t") int value) {
            XrBodySkeletonJointFB.njoint(this.address(), value);
            return this;
        }

        public Buffer parentJoint(@NativeType(value="int32_t") int value) {
            XrBodySkeletonJointFB.nparentJoint(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrBodySkeletonJointFB.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

