/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBoundSourcesForActionEnumerateInfo
extends Struct<XrBoundSourcesForActionEnumerateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;

    protected XrBoundSourcesForActionEnumerateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBoundSourcesForActionEnumerateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrBoundSourcesForActionEnumerateInfo(address, container);
    }

    public XrBoundSourcesForActionEnumerateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBoundSourcesForActionEnumerateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBoundSourcesForActionEnumerateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBoundSourcesForActionEnumerateInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrBoundSourcesForActionEnumerateInfo.naction(this.address());
    }

    public XrBoundSourcesForActionEnumerateInfo type(@NativeType(value="XrStructureType") int value) {
        XrBoundSourcesForActionEnumerateInfo.ntype(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo type$Default() {
        return this.type(62);
    }

    public XrBoundSourcesForActionEnumerateInfo next(@NativeType(value="void const *") long value) {
        XrBoundSourcesForActionEnumerateInfo.nnext(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo action(XrAction value) {
        XrBoundSourcesForActionEnumerateInfo.naction(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo set(int type, long next, XrAction action) {
        this.type(type);
        this.next(next);
        this.action(action);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo set(XrBoundSourcesForActionEnumerateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBoundSourcesForActionEnumerateInfo malloc() {
        return new XrBoundSourcesForActionEnumerateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBoundSourcesForActionEnumerateInfo calloc() {
        return new XrBoundSourcesForActionEnumerateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBoundSourcesForActionEnumerateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBoundSourcesForActionEnumerateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBoundSourcesForActionEnumerateInfo create(long address) {
        return new XrBoundSourcesForActionEnumerateInfo(address, null);
    }

    @Nullable
    public static XrBoundSourcesForActionEnumerateInfo createSafe(long address) {
        return address == 0L ? null : new XrBoundSourcesForActionEnumerateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBoundSourcesForActionEnumerateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBoundSourcesForActionEnumerateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBoundSourcesForActionEnumerateInfo malloc(MemoryStack stack) {
        return new XrBoundSourcesForActionEnumerateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBoundSourcesForActionEnumerateInfo calloc(MemoryStack stack) {
        return new XrBoundSourcesForActionEnumerateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTION));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTION), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTION)));
    }

    static {
        Struct.Layout layout = XrBoundSourcesForActionEnumerateInfo.__struct((Struct.Member[])new Struct.Member[]{XrBoundSourcesForActionEnumerateInfo.__member((int)4), XrBoundSourcesForActionEnumerateInfo.__member((int)POINTER_SIZE), XrBoundSourcesForActionEnumerateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBoundSourcesForActionEnumerateInfo, Buffer>
    implements NativeResource {
        private static final XrBoundSourcesForActionEnumerateInfo ELEMENT_FACTORY = XrBoundSourcesForActionEnumerateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBoundSourcesForActionEnumerateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBoundSourcesForActionEnumerateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBoundSourcesForActionEnumerateInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrBoundSourcesForActionEnumerateInfo.naction(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBoundSourcesForActionEnumerateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(62);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBoundSourcesForActionEnumerateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrBoundSourcesForActionEnumerateInfo.naction(this.address(), value);
            return this;
        }
    }
}

