/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerCylinderKHR
extends Struct<XrCompositionLayerCylinderKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int EYEVISIBILITY;
    public static final int SUBIMAGE;
    public static final int POSE;
    public static final int RADIUS;
    public static final int CENTRALANGLE;
    public static final int ASPECTRATIO;

    protected XrCompositionLayerCylinderKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrCompositionLayerCylinderKHR create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerCylinderKHR(address, container);
    }

    public XrCompositionLayerCylinderKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerCylinderKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerCylinderKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerCylinderKHR.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerCylinderKHR.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerCylinderKHR.nspace(this.address());
    }

    @NativeType(value="XrEyeVisibility")
    public int eyeVisibility() {
        return XrCompositionLayerCylinderKHR.neyeVisibility(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerCylinderKHR.nsubImage(this.address());
    }

    public XrPosef pose() {
        return XrCompositionLayerCylinderKHR.npose(this.address());
    }

    public float radius() {
        return XrCompositionLayerCylinderKHR.nradius(this.address());
    }

    public float centralAngle() {
        return XrCompositionLayerCylinderKHR.ncentralAngle(this.address());
    }

    public float aspectRatio() {
        return XrCompositionLayerCylinderKHR.naspectRatio(this.address());
    }

    public XrCompositionLayerCylinderKHR type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerCylinderKHR.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR type$Default() {
        return this.type(1000017000);
    }

    public XrCompositionLayerCylinderKHR next(@NativeType(value="void const *") long value) {
        XrCompositionLayerCylinderKHR.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerCylinderKHR.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR space(XrSpace value) {
        XrCompositionLayerCylinderKHR.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
        XrCompositionLayerCylinderKHR.neyeVisibility(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR subImage(XrSwapchainSubImage value) {
        XrCompositionLayerCylinderKHR.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerCylinderKHR pose(XrPosef value) {
        XrCompositionLayerCylinderKHR.npose(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrCompositionLayerCylinderKHR radius(float value) {
        XrCompositionLayerCylinderKHR.nradius(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR centralAngle(float value) {
        XrCompositionLayerCylinderKHR.ncentralAngle(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR aspectRatio(float value) {
        XrCompositionLayerCylinderKHR.naspectRatio(this.address(), value);
        return this;
    }

    public XrCompositionLayerCylinderKHR set(int type, long next, long layerFlags, XrSpace space, int eyeVisibility, XrSwapchainSubImage subImage, XrPosef pose, float radius, float centralAngle, float aspectRatio) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.eyeVisibility(eyeVisibility);
        this.subImage(subImage);
        this.pose(pose);
        this.radius(radius);
        this.centralAngle(centralAngle);
        this.aspectRatio(aspectRatio);
        return this;
    }

    public XrCompositionLayerCylinderKHR set(XrCompositionLayerCylinderKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerCylinderKHR malloc() {
        return new XrCompositionLayerCylinderKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrCompositionLayerCylinderKHR calloc() {
        return new XrCompositionLayerCylinderKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrCompositionLayerCylinderKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrCompositionLayerCylinderKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrCompositionLayerCylinderKHR create(long address) {
        return new XrCompositionLayerCylinderKHR(address, null);
    }

    @Nullable
    public static XrCompositionLayerCylinderKHR createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerCylinderKHR(address, null);
    }

    public static XrCompositionLayerCylinderKHR create(XrCompositionLayerBaseHeader value) {
        return new XrCompositionLayerCylinderKHR(value.address(), XrCompositionLayerCylinderKHR.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrCompositionLayerCylinderKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerCylinderKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerCylinderKHR.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerCylinderKHR malloc(MemoryStack stack) {
        return new XrCompositionLayerCylinderKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerCylinderKHR calloc(MemoryStack stack) {
        return new XrCompositionLayerCylinderKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nlayerFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int neyeVisibility(long struct) {
        return UNSAFE.getInt(null, struct + (long)EYEVISIBILITY);
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static float ncentralAngle(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CENTRALANGLE);
    }

    public static float naspectRatio(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ASPECTRATIO);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlayerFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void neyeVisibility(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EYEVISIBILITY, value);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SUBIMAGE), (long)XrSwapchainSubImage.SIZEOF);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RADIUS, value);
    }

    public static void ncentralAngle(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CENTRALANGLE, value);
    }

    public static void naspectRatio(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ASPECTRATIO, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerCylinderKHR.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerCylinderKHR.__member((int)4), XrCompositionLayerCylinderKHR.__member((int)POINTER_SIZE), XrCompositionLayerCylinderKHR.__member((int)8), XrCompositionLayerCylinderKHR.__member((int)POINTER_SIZE), XrCompositionLayerCylinderKHR.__member((int)4), XrCompositionLayerCylinderKHR.__member((int)XrSwapchainSubImage.SIZEOF, (int)XrSwapchainSubImage.ALIGNOF), XrCompositionLayerCylinderKHR.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrCompositionLayerCylinderKHR.__member((int)4), XrCompositionLayerCylinderKHR.__member((int)4), XrCompositionLayerCylinderKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        EYEVISIBILITY = layout.offsetof(4);
        SUBIMAGE = layout.offsetof(5);
        POSE = layout.offsetof(6);
        RADIUS = layout.offsetof(7);
        CENTRALANGLE = layout.offsetof(8);
        ASPECTRATIO = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerCylinderKHR, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerCylinderKHR ELEMENT_FACTORY = XrCompositionLayerCylinderKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerCylinderKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerCylinderKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerCylinderKHR.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerCylinderKHR.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerCylinderKHR.nspace(this.address());
        }

        @NativeType(value="XrEyeVisibility")
        public int eyeVisibility() {
            return XrCompositionLayerCylinderKHR.neyeVisibility(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerCylinderKHR.nsubImage(this.address());
        }

        public XrPosef pose() {
            return XrCompositionLayerCylinderKHR.npose(this.address());
        }

        public float radius() {
            return XrCompositionLayerCylinderKHR.nradius(this.address());
        }

        public float centralAngle() {
            return XrCompositionLayerCylinderKHR.ncentralAngle(this.address());
        }

        public float aspectRatio() {
            return XrCompositionLayerCylinderKHR.naspectRatio(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerCylinderKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000017000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerCylinderKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerCylinderKHR.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerCylinderKHR.nspace(this.address(), value);
            return this;
        }

        public Buffer eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
            XrCompositionLayerCylinderKHR.neyeVisibility(this.address(), value);
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerCylinderKHR.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrCompositionLayerCylinderKHR.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer radius(float value) {
            XrCompositionLayerCylinderKHR.nradius(this.address(), value);
            return this;
        }

        public Buffer centralAngle(float value) {
            XrCompositionLayerCylinderKHR.ncentralAngle(this.address(), value);
            return this;
        }

        public Buffer aspectRatio(float value) {
            XrCompositionLayerCylinderKHR.naspectRatio(this.address(), value);
            return this;
        }
    }
}

