/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerDepthTestFB
extends Struct<XrCompositionLayerDepthTestFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int DEPTHMASK;
    public static final int COMPAREOP;

    protected XrCompositionLayerDepthTestFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrCompositionLayerDepthTestFB create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerDepthTestFB(address, container);
    }

    public XrCompositionLayerDepthTestFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerDepthTestFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerDepthTestFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerDepthTestFB.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean depthMask() {
        return XrCompositionLayerDepthTestFB.ndepthMask(this.address()) != 0;
    }

    @NativeType(value="XrCompareOpFB")
    public int compareOp() {
        return XrCompositionLayerDepthTestFB.ncompareOp(this.address());
    }

    public XrCompositionLayerDepthTestFB type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerDepthTestFB.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthTestFB type$Default() {
        return this.type(1000212000);
    }

    public XrCompositionLayerDepthTestFB next(@NativeType(value="void const *") long value) {
        XrCompositionLayerDepthTestFB.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthTestFB depthMask(@NativeType(value="XrBool32") boolean value) {
        XrCompositionLayerDepthTestFB.ndepthMask(this.address(), value ? 1 : 0);
        return this;
    }

    public XrCompositionLayerDepthTestFB compareOp(@NativeType(value="XrCompareOpFB") int value) {
        XrCompositionLayerDepthTestFB.ncompareOp(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthTestFB set(int type, long next, boolean depthMask, int compareOp) {
        this.type(type);
        this.next(next);
        this.depthMask(depthMask);
        this.compareOp(compareOp);
        return this;
    }

    public XrCompositionLayerDepthTestFB set(XrCompositionLayerDepthTestFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerDepthTestFB malloc() {
        return new XrCompositionLayerDepthTestFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrCompositionLayerDepthTestFB calloc() {
        return new XrCompositionLayerDepthTestFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrCompositionLayerDepthTestFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrCompositionLayerDepthTestFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrCompositionLayerDepthTestFB create(long address) {
        return new XrCompositionLayerDepthTestFB(address, null);
    }

    @Nullable
    public static XrCompositionLayerDepthTestFB createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerDepthTestFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrCompositionLayerDepthTestFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerDepthTestFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrCompositionLayerDepthTestFB malloc(MemoryStack stack) {
        return new XrCompositionLayerDepthTestFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerDepthTestFB calloc(MemoryStack stack) {
        return new XrCompositionLayerDepthTestFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int ndepthMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHMASK);
    }

    public static int ncompareOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPAREOP);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ndepthMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHMASK, value);
    }

    public static void ncompareOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPAREOP, value);
    }

    static {
        Struct.Layout layout = XrCompositionLayerDepthTestFB.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerDepthTestFB.__member((int)4), XrCompositionLayerDepthTestFB.__member((int)POINTER_SIZE), XrCompositionLayerDepthTestFB.__member((int)4), XrCompositionLayerDepthTestFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        DEPTHMASK = layout.offsetof(2);
        COMPAREOP = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerDepthTestFB, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerDepthTestFB ELEMENT_FACTORY = XrCompositionLayerDepthTestFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerDepthTestFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerDepthTestFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerDepthTestFB.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean depthMask() {
            return XrCompositionLayerDepthTestFB.ndepthMask(this.address()) != 0;
        }

        @NativeType(value="XrCompareOpFB")
        public int compareOp() {
            return XrCompositionLayerDepthTestFB.ncompareOp(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerDepthTestFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000212000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerDepthTestFB.nnext(this.address(), value);
            return this;
        }

        public Buffer depthMask(@NativeType(value="XrBool32") boolean value) {
            XrCompositionLayerDepthTestFB.ndepthMask(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer compareOp(@NativeType(value="XrCompareOpFB") int value) {
            XrCompositionLayerDepthTestFB.ncompareOp(this.address(), value);
            return this;
        }
    }
}

