/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrDebugUtilsLabelEXT;
import org.lwjgl.openxr.XrDebugUtilsObjectNameInfoEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDebugUtilsMessengerCallbackDataEXT
extends Struct<XrDebugUtilsMessengerCallbackDataEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MESSAGEID;
    public static final int FUNCTIONNAME;
    public static final int MESSAGE;
    public static final int OBJECTCOUNT;
    public static final int OBJECTS;
    public static final int SESSIONLABELCOUNT;
    public static final int SESSIONLABELS;

    protected XrDebugUtilsMessengerCallbackDataEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrDebugUtilsMessengerCallbackDataEXT create(long address, @Nullable ByteBuffer container) {
        return new XrDebugUtilsMessengerCallbackDataEXT(address, container);
    }

    public XrDebugUtilsMessengerCallbackDataEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrDebugUtilsMessengerCallbackDataEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrDebugUtilsMessengerCallbackDataEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrDebugUtilsMessengerCallbackDataEXT.nnext(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer messageId() {
        return XrDebugUtilsMessengerCallbackDataEXT.nmessageId(this.address());
    }

    @NativeType(value="char const *")
    public String messageIdString() {
        return XrDebugUtilsMessengerCallbackDataEXT.nmessageIdString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer functionName() {
        return XrDebugUtilsMessengerCallbackDataEXT.nfunctionName(this.address());
    }

    @NativeType(value="char const *")
    public String functionNameString() {
        return XrDebugUtilsMessengerCallbackDataEXT.nfunctionNameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer message() {
        return XrDebugUtilsMessengerCallbackDataEXT.nmessage(this.address());
    }

    @NativeType(value="char const *")
    public String messageString() {
        return XrDebugUtilsMessengerCallbackDataEXT.nmessageString(this.address());
    }

    @NativeType(value="uint32_t")
    public int objectCount() {
        return XrDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address());
    }

    @Nullable
    @NativeType(value="XrDebugUtilsObjectNameInfoEXT *")
    public XrDebugUtilsObjectNameInfoEXT.Buffer objects() {
        return XrDebugUtilsMessengerCallbackDataEXT.nobjects(this.address());
    }

    @NativeType(value="uint32_t")
    public int sessionLabelCount() {
        return XrDebugUtilsMessengerCallbackDataEXT.nsessionLabelCount(this.address());
    }

    @Nullable
    @NativeType(value="XrDebugUtilsLabelEXT *")
    public XrDebugUtilsLabelEXT.Buffer sessionLabels() {
        return XrDebugUtilsMessengerCallbackDataEXT.nsessionLabels(this.address());
    }

    public XrDebugUtilsMessengerCallbackDataEXT type(@NativeType(value="XrStructureType") int value) {
        XrDebugUtilsMessengerCallbackDataEXT.ntype(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT type$Default() {
        return this.type(1000019001);
    }

    public XrDebugUtilsMessengerCallbackDataEXT next(@NativeType(value="void const *") long value) {
        XrDebugUtilsMessengerCallbackDataEXT.nnext(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT messageId(@NativeType(value="char const *") ByteBuffer value) {
        XrDebugUtilsMessengerCallbackDataEXT.nmessageId(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT functionName(@NativeType(value="char const *") ByteBuffer value) {
        XrDebugUtilsMessengerCallbackDataEXT.nfunctionName(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT message(@NativeType(value="char const *") ByteBuffer value) {
        XrDebugUtilsMessengerCallbackDataEXT.nmessage(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT objectCount(@NativeType(value="uint32_t") int value) {
        XrDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT objects(@Nullable @NativeType(value="XrDebugUtilsObjectNameInfoEXT *") XrDebugUtilsObjectNameInfoEXT.Buffer value) {
        XrDebugUtilsMessengerCallbackDataEXT.nobjects(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT sessionLabelCount(@NativeType(value="uint32_t") int value) {
        XrDebugUtilsMessengerCallbackDataEXT.nsessionLabelCount(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT sessionLabels(@Nullable @NativeType(value="XrDebugUtilsLabelEXT *") XrDebugUtilsLabelEXT.Buffer value) {
        XrDebugUtilsMessengerCallbackDataEXT.nsessionLabels(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT set(int type, long next, ByteBuffer messageId, ByteBuffer functionName, ByteBuffer message, int objectCount, @Nullable XrDebugUtilsObjectNameInfoEXT.Buffer objects, int sessionLabelCount, @Nullable XrDebugUtilsLabelEXT.Buffer sessionLabels) {
        this.type(type);
        this.next(next);
        this.messageId(messageId);
        this.functionName(functionName);
        this.message(message);
        this.objectCount(objectCount);
        this.objects(objects);
        this.sessionLabelCount(sessionLabelCount);
        this.sessionLabels(sessionLabels);
        return this;
    }

    public XrDebugUtilsMessengerCallbackDataEXT set(XrDebugUtilsMessengerCallbackDataEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrDebugUtilsMessengerCallbackDataEXT malloc() {
        return new XrDebugUtilsMessengerCallbackDataEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrDebugUtilsMessengerCallbackDataEXT calloc() {
        return new XrDebugUtilsMessengerCallbackDataEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrDebugUtilsMessengerCallbackDataEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrDebugUtilsMessengerCallbackDataEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrDebugUtilsMessengerCallbackDataEXT create(long address) {
        return new XrDebugUtilsMessengerCallbackDataEXT(address, null);
    }

    @Nullable
    public static XrDebugUtilsMessengerCallbackDataEXT createSafe(long address) {
        return address == 0L ? null : new XrDebugUtilsMessengerCallbackDataEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrDebugUtilsMessengerCallbackDataEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDebugUtilsMessengerCallbackDataEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrDebugUtilsMessengerCallbackDataEXT malloc(MemoryStack stack) {
        return new XrDebugUtilsMessengerCallbackDataEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrDebugUtilsMessengerCallbackDataEXT calloc(MemoryStack stack) {
        return new XrDebugUtilsMessengerCallbackDataEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nmessageId(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGEID)));
    }

    public static String nmessageIdString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGEID)));
    }

    public static ByteBuffer nfunctionName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONNAME)));
    }

    public static String nfunctionNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONNAME)));
    }

    public static ByteBuffer nmessage(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGE)));
    }

    public static String nmessageString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGE)));
    }

    public static int nobjectCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTCOUNT);
    }

    @Nullable
    public static XrDebugUtilsObjectNameInfoEXT.Buffer nobjects(long struct) {
        return XrDebugUtilsObjectNameInfoEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)OBJECTS)), XrDebugUtilsMessengerCallbackDataEXT.nobjectCount(struct));
    }

    public static int nsessionLabelCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SESSIONLABELCOUNT);
    }

    @Nullable
    public static XrDebugUtilsLabelEXT.Buffer nsessionLabels(long struct) {
        return XrDebugUtilsLabelEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SESSIONLABELS)), XrDebugUtilsMessengerCallbackDataEXT.nsessionLabelCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nmessageId(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MESSAGEID), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nfunctionName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)FUNCTIONNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nmessage(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MESSAGE), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nobjectCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTCOUNT, value);
    }

    public static void nobjects(long struct, @Nullable XrDebugUtilsObjectNameInfoEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OBJECTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrDebugUtilsMessengerCallbackDataEXT.nobjectCount(struct, value.remaining());
        }
    }

    public static void nsessionLabelCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SESSIONLABELCOUNT, value);
    }

    public static void nsessionLabels(long struct, @Nullable XrDebugUtilsLabelEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SESSIONLABELS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrDebugUtilsMessengerCallbackDataEXT.nsessionLabelCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGEID)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONNAME)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGE)));
    }

    static {
        Struct.Layout layout = XrDebugUtilsMessengerCallbackDataEXT.__struct((Struct.Member[])new Struct.Member[]{XrDebugUtilsMessengerCallbackDataEXT.__member((int)4), XrDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), XrDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), XrDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), XrDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), XrDebugUtilsMessengerCallbackDataEXT.__member((int)4), XrDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE), XrDebugUtilsMessengerCallbackDataEXT.__member((int)4), XrDebugUtilsMessengerCallbackDataEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MESSAGEID = layout.offsetof(2);
        FUNCTIONNAME = layout.offsetof(3);
        MESSAGE = layout.offsetof(4);
        OBJECTCOUNT = layout.offsetof(5);
        OBJECTS = layout.offsetof(6);
        SESSIONLABELCOUNT = layout.offsetof(7);
        SESSIONLABELS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<XrDebugUtilsMessengerCallbackDataEXT, Buffer>
    implements NativeResource {
        private static final XrDebugUtilsMessengerCallbackDataEXT ELEMENT_FACTORY = XrDebugUtilsMessengerCallbackDataEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrDebugUtilsMessengerCallbackDataEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrDebugUtilsMessengerCallbackDataEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrDebugUtilsMessengerCallbackDataEXT.nnext(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer messageId() {
            return XrDebugUtilsMessengerCallbackDataEXT.nmessageId(this.address());
        }

        @NativeType(value="char const *")
        public String messageIdString() {
            return XrDebugUtilsMessengerCallbackDataEXT.nmessageIdString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer functionName() {
            return XrDebugUtilsMessengerCallbackDataEXT.nfunctionName(this.address());
        }

        @NativeType(value="char const *")
        public String functionNameString() {
            return XrDebugUtilsMessengerCallbackDataEXT.nfunctionNameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer message() {
            return XrDebugUtilsMessengerCallbackDataEXT.nmessage(this.address());
        }

        @NativeType(value="char const *")
        public String messageString() {
            return XrDebugUtilsMessengerCallbackDataEXT.nmessageString(this.address());
        }

        @NativeType(value="uint32_t")
        public int objectCount() {
            return XrDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address());
        }

        @Nullable
        @NativeType(value="XrDebugUtilsObjectNameInfoEXT *")
        public XrDebugUtilsObjectNameInfoEXT.Buffer objects() {
            return XrDebugUtilsMessengerCallbackDataEXT.nobjects(this.address());
        }

        @NativeType(value="uint32_t")
        public int sessionLabelCount() {
            return XrDebugUtilsMessengerCallbackDataEXT.nsessionLabelCount(this.address());
        }

        @Nullable
        @NativeType(value="XrDebugUtilsLabelEXT *")
        public XrDebugUtilsLabelEXT.Buffer sessionLabels() {
            return XrDebugUtilsMessengerCallbackDataEXT.nsessionLabels(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrDebugUtilsMessengerCallbackDataEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000019001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrDebugUtilsMessengerCallbackDataEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer messageId(@NativeType(value="char const *") ByteBuffer value) {
            XrDebugUtilsMessengerCallbackDataEXT.nmessageId(this.address(), value);
            return this;
        }

        public Buffer functionName(@NativeType(value="char const *") ByteBuffer value) {
            XrDebugUtilsMessengerCallbackDataEXT.nfunctionName(this.address(), value);
            return this;
        }

        public Buffer message(@NativeType(value="char const *") ByteBuffer value) {
            XrDebugUtilsMessengerCallbackDataEXT.nmessage(this.address(), value);
            return this;
        }

        public Buffer objectCount(@NativeType(value="uint32_t") int value) {
            XrDebugUtilsMessengerCallbackDataEXT.nobjectCount(this.address(), value);
            return this;
        }

        public Buffer objects(@Nullable @NativeType(value="XrDebugUtilsObjectNameInfoEXT *") XrDebugUtilsObjectNameInfoEXT.Buffer value) {
            XrDebugUtilsMessengerCallbackDataEXT.nobjects(this.address(), value);
            return this;
        }

        public Buffer sessionLabelCount(@NativeType(value="uint32_t") int value) {
            XrDebugUtilsMessengerCallbackDataEXT.nsessionLabelCount(this.address(), value);
            return this;
        }

        public Buffer sessionLabels(@Nullable @NativeType(value="XrDebugUtilsLabelEXT *") XrDebugUtilsLabelEXT.Buffer value) {
            XrDebugUtilsMessengerCallbackDataEXT.nsessionLabels(this.address(), value);
            return this;
        }
    }
}

