/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDeserializeSceneFragmentMSFT
extends Struct<XrDeserializeSceneFragmentMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERSIZE;
    public static final int BUFFER;

    protected XrDeserializeSceneFragmentMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrDeserializeSceneFragmentMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrDeserializeSceneFragmentMSFT(address, container);
    }

    public XrDeserializeSceneFragmentMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrDeserializeSceneFragmentMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int bufferSize() {
        return XrDeserializeSceneFragmentMSFT.nbufferSize(this.address());
    }

    @Nullable
    @NativeType(value="uint8_t const *")
    public ByteBuffer buffer() {
        return XrDeserializeSceneFragmentMSFT.nbuffer(this.address());
    }

    public XrDeserializeSceneFragmentMSFT bufferSize(@NativeType(value="uint32_t") int value) {
        XrDeserializeSceneFragmentMSFT.nbufferSize(this.address(), value);
        return this;
    }

    public XrDeserializeSceneFragmentMSFT buffer(@Nullable @NativeType(value="uint8_t const *") ByteBuffer value) {
        XrDeserializeSceneFragmentMSFT.nbuffer(this.address(), value);
        return this;
    }

    public XrDeserializeSceneFragmentMSFT set(int bufferSize, @Nullable ByteBuffer buffer) {
        this.bufferSize(bufferSize);
        this.buffer(buffer);
        return this;
    }

    public XrDeserializeSceneFragmentMSFT set(XrDeserializeSceneFragmentMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrDeserializeSceneFragmentMSFT malloc() {
        return new XrDeserializeSceneFragmentMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrDeserializeSceneFragmentMSFT calloc() {
        return new XrDeserializeSceneFragmentMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrDeserializeSceneFragmentMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrDeserializeSceneFragmentMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrDeserializeSceneFragmentMSFT create(long address) {
        return new XrDeserializeSceneFragmentMSFT(address, null);
    }

    @Nullable
    public static XrDeserializeSceneFragmentMSFT createSafe(long address) {
        return address == 0L ? null : new XrDeserializeSceneFragmentMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrDeserializeSceneFragmentMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDeserializeSceneFragmentMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrDeserializeSceneFragmentMSFT malloc(MemoryStack stack) {
        return new XrDeserializeSceneFragmentMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrDeserializeSceneFragmentMSFT calloc(MemoryStack stack) {
        return new XrDeserializeSceneFragmentMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERSIZE);
    }

    @Nullable
    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)XrDeserializeSceneFragmentMSFT.nbufferSize(struct));
    }

    public static void nbufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERSIZE, value);
    }

    public static void nbuffer(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        if (value != null) {
            XrDeserializeSceneFragmentMSFT.nbufferSize(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrDeserializeSceneFragmentMSFT.__struct((Struct.Member[])new Struct.Member[]{XrDeserializeSceneFragmentMSFT.__member((int)4), XrDeserializeSceneFragmentMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERSIZE = layout.offsetof(0);
        BUFFER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrDeserializeSceneFragmentMSFT, Buffer>
    implements NativeResource {
        private static final XrDeserializeSceneFragmentMSFT ELEMENT_FACTORY = XrDeserializeSceneFragmentMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrDeserializeSceneFragmentMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int bufferSize() {
            return XrDeserializeSceneFragmentMSFT.nbufferSize(this.address());
        }

        @Nullable
        @NativeType(value="uint8_t const *")
        public ByteBuffer buffer() {
            return XrDeserializeSceneFragmentMSFT.nbuffer(this.address());
        }

        public Buffer bufferSize(@NativeType(value="uint32_t") int value) {
            XrDeserializeSceneFragmentMSFT.nbufferSize(this.address(), value);
            return this;
        }

        public Buffer buffer(@Nullable @NativeType(value="uint8_t const *") ByteBuffer value) {
            XrDeserializeSceneFragmentMSFT.nbuffer(this.address(), value);
            return this;
        }
    }
}

