/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataEventsLost
extends Struct<XrEventDataEventsLost>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOSTEVENTCOUNT;

    protected XrEventDataEventsLost(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrEventDataEventsLost create(long address, @Nullable ByteBuffer container) {
        return new XrEventDataEventsLost(address, container);
    }

    public XrEventDataEventsLost(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrEventDataEventsLost.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataEventsLost.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataEventsLost.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int lostEventCount() {
        return XrEventDataEventsLost.nlostEventCount(this.address());
    }

    public XrEventDataEventsLost type(@NativeType(value="XrStructureType") int value) {
        XrEventDataEventsLost.ntype(this.address(), value);
        return this;
    }

    public XrEventDataEventsLost type$Default() {
        return this.type(49);
    }

    public XrEventDataEventsLost next(@NativeType(value="void const *") long value) {
        XrEventDataEventsLost.nnext(this.address(), value);
        return this;
    }

    public XrEventDataEventsLost set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrEventDataEventsLost set(XrEventDataEventsLost src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrEventDataEventsLost malloc() {
        return new XrEventDataEventsLost(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrEventDataEventsLost calloc() {
        return new XrEventDataEventsLost(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrEventDataEventsLost create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrEventDataEventsLost(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrEventDataEventsLost create(long address) {
        return new XrEventDataEventsLost(address, null);
    }

    @Nullable
    public static XrEventDataEventsLost createSafe(long address) {
        return address == 0L ? null : new XrEventDataEventsLost(address, null);
    }

    public static XrEventDataEventsLost create(XrEventDataBaseHeader value) {
        return new XrEventDataEventsLost(value.address(), XrEventDataEventsLost.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrEventDataEventsLost.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataEventsLost.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrEventDataEventsLost.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrEventDataEventsLost malloc(MemoryStack stack) {
        return new XrEventDataEventsLost(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEventDataEventsLost calloc(MemoryStack stack) {
        return new XrEventDataEventsLost(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nlostEventCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOSTEVENTCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrEventDataEventsLost.__struct((Struct.Member[])new Struct.Member[]{XrEventDataEventsLost.__member((int)4), XrEventDataEventsLost.__member((int)POINTER_SIZE), XrEventDataEventsLost.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOSTEVENTCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataEventsLost, Buffer>
    implements NativeResource {
        private static final XrEventDataEventsLost ELEMENT_FACTORY = XrEventDataEventsLost.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrEventDataEventsLost getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataEventsLost.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataEventsLost.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int lostEventCount() {
            return XrEventDataEventsLost.nlostEventCount(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataEventsLost.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(49);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataEventsLost.nnext(this.address(), value);
            return this;
        }
    }
}

