/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent2Df
extends Struct<XrExtent2Df>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected XrExtent2Df(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrExtent2Df create(long address, @Nullable ByteBuffer container) {
        return new XrExtent2Df(address, container);
    }

    public XrExtent2Df(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExtent2Df.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return XrExtent2Df.nwidth(this.address());
    }

    public float height() {
        return XrExtent2Df.nheight(this.address());
    }

    public XrExtent2Df width(float value) {
        XrExtent2Df.nwidth(this.address(), value);
        return this;
    }

    public XrExtent2Df height(float value) {
        XrExtent2Df.nheight(this.address(), value);
        return this;
    }

    public XrExtent2Df set(float width, float height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public XrExtent2Df set(XrExtent2Df src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtent2Df malloc() {
        return new XrExtent2Df(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrExtent2Df calloc() {
        return new XrExtent2Df(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrExtent2Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrExtent2Df(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrExtent2Df create(long address) {
        return new XrExtent2Df(address, null);
    }

    @Nullable
    public static XrExtent2Df createSafe(long address) {
        return address == 0L ? null : new XrExtent2Df(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrExtent2Df.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent2Df.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtent2Df malloc(MemoryStack stack) {
        return new XrExtent2Df(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtent2Df calloc(MemoryStack stack) {
        return new XrExtent2Df(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = XrExtent2Df.__struct((Struct.Member[])new Struct.Member[]{XrExtent2Df.__member((int)4), XrExtent2Df.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrExtent2Df, Buffer>
    implements NativeResource {
        private static final XrExtent2Df ELEMENT_FACTORY = XrExtent2Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExtent2Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return XrExtent2Df.nwidth(this.address());
        }

        public float height() {
            return XrExtent2Df.nheight(this.address());
        }

        public Buffer width(float value) {
            XrExtent2Df.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            XrExtent2Df.nheight(this.address(), value);
            return this;
        }
    }
}

