/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent3DfEXT
extends Struct<XrExtent3DfEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;

    protected XrExtent3DfEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrExtent3DfEXT create(long address, @Nullable ByteBuffer container) {
        return new XrExtent3DfEXT(address, container);
    }

    public XrExtent3DfEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExtent3DfEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return XrExtent3DfEXT.nwidth(this.address());
    }

    public float height() {
        return XrExtent3DfEXT.nheight(this.address());
    }

    public float depth() {
        return XrExtent3DfEXT.ndepth(this.address());
    }

    public XrExtent3DfEXT width(float value) {
        XrExtent3DfEXT.nwidth(this.address(), value);
        return this;
    }

    public XrExtent3DfEXT height(float value) {
        XrExtent3DfEXT.nheight(this.address(), value);
        return this;
    }

    public XrExtent3DfEXT depth(float value) {
        XrExtent3DfEXT.ndepth(this.address(), value);
        return this;
    }

    public XrExtent3DfEXT set(float width, float height, float depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public XrExtent3DfEXT set(XrExtent3DfEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtent3DfEXT malloc() {
        return new XrExtent3DfEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrExtent3DfEXT calloc() {
        return new XrExtent3DfEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrExtent3DfEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrExtent3DfEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrExtent3DfEXT create(long address) {
        return new XrExtent3DfEXT(address, null);
    }

    @Nullable
    public static XrExtent3DfEXT createSafe(long address) {
        return address == 0L ? null : new XrExtent3DfEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrExtent3DfEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent3DfEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtent3DfEXT malloc(MemoryStack stack) {
        return new XrExtent3DfEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtent3DfEXT calloc(MemoryStack stack) {
        return new XrExtent3DfEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float ndepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DEPTH);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = XrExtent3DfEXT.__struct((Struct.Member[])new Struct.Member[]{XrExtent3DfEXT.__member((int)4), XrExtent3DfEXT.__member((int)4), XrExtent3DfEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrExtent3DfEXT, Buffer>
    implements NativeResource {
        private static final XrExtent3DfEXT ELEMENT_FACTORY = XrExtent3DfEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExtent3DfEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return XrExtent3DfEXT.nwidth(this.address());
        }

        public float height() {
            return XrExtent3DfEXT.nheight(this.address());
        }

        public float depth() {
            return XrExtent3DfEXT.ndepth(this.address());
        }

        public Buffer width(float value) {
            XrExtent3DfEXT.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            XrExtent3DfEXT.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(float value) {
            XrExtent3DfEXT.ndepth(this.address(), value);
            return this;
        }
    }
}

