/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrFrameEndInfoML;
import org.lwjgl.openxr.XrGlobalDimmerFrameEndInfoML;
import org.lwjgl.openxr.XrLocalDimmingFrameEndInfoMETA;
import org.lwjgl.openxr.XrSecondaryViewConfigurationFrameEndInfoMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrameEndInfo
extends Struct<XrFrameEndInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int DISPLAYTIME;
    public static final int ENVIRONMENTBLENDMODE;
    public static final int LAYERCOUNT;
    public static final int LAYERS;

    protected XrFrameEndInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrFrameEndInfo create(long address, @Nullable ByteBuffer container) {
        return new XrFrameEndInfo(address, container);
    }

    public XrFrameEndInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFrameEndInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFrameEndInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFrameEndInfo.nnext(this.address());
    }

    @NativeType(value="XrTime")
    public long displayTime() {
        return XrFrameEndInfo.ndisplayTime(this.address());
    }

    @NativeType(value="XrEnvironmentBlendMode")
    public int environmentBlendMode() {
        return XrFrameEndInfo.nenvironmentBlendMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return XrFrameEndInfo.nlayerCount(this.address());
    }

    @Nullable
    @NativeType(value="XrCompositionLayerBaseHeader const * const *")
    public PointerBuffer layers() {
        return XrFrameEndInfo.nlayers(this.address());
    }

    public XrFrameEndInfo type(@NativeType(value="XrStructureType") int value) {
        XrFrameEndInfo.ntype(this.address(), value);
        return this;
    }

    public XrFrameEndInfo type$Default() {
        return this.type(12);
    }

    public XrFrameEndInfo next(@NativeType(value="void const *") long value) {
        XrFrameEndInfo.nnext(this.address(), value);
        return this;
    }

    public XrFrameEndInfo next(XrFrameEndInfoML value) {
        return this.next(value.next(this.next()).address());
    }

    public XrFrameEndInfo next(XrGlobalDimmerFrameEndInfoML value) {
        return this.next(value.next(this.next()).address());
    }

    public XrFrameEndInfo next(XrLocalDimmingFrameEndInfoMETA value) {
        return this.next(value.next(this.next()).address());
    }

    public XrFrameEndInfo next(XrSecondaryViewConfigurationFrameEndInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrFrameEndInfo displayTime(@NativeType(value="XrTime") long value) {
        XrFrameEndInfo.ndisplayTime(this.address(), value);
        return this;
    }

    public XrFrameEndInfo environmentBlendMode(@NativeType(value="XrEnvironmentBlendMode") int value) {
        XrFrameEndInfo.nenvironmentBlendMode(this.address(), value);
        return this;
    }

    public XrFrameEndInfo layerCount(@NativeType(value="uint32_t") int value) {
        XrFrameEndInfo.nlayerCount(this.address(), value);
        return this;
    }

    public XrFrameEndInfo layers(@Nullable @NativeType(value="XrCompositionLayerBaseHeader const * const *") PointerBuffer value) {
        XrFrameEndInfo.nlayers(this.address(), value);
        return this;
    }

    public XrFrameEndInfo set(int type, long next, long displayTime, int environmentBlendMode, int layerCount, @Nullable PointerBuffer layers) {
        this.type(type);
        this.next(next);
        this.displayTime(displayTime);
        this.environmentBlendMode(environmentBlendMode);
        this.layerCount(layerCount);
        this.layers(layers);
        return this;
    }

    public XrFrameEndInfo set(XrFrameEndInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFrameEndInfo malloc() {
        return new XrFrameEndInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrFrameEndInfo calloc() {
        return new XrFrameEndInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrFrameEndInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrFrameEndInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrFrameEndInfo create(long address) {
        return new XrFrameEndInfo(address, null);
    }

    @Nullable
    public static XrFrameEndInfo createSafe(long address) {
        return address == 0L ? null : new XrFrameEndInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrFrameEndInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrameEndInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFrameEndInfo malloc(MemoryStack stack) {
        return new XrFrameEndInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFrameEndInfo calloc(MemoryStack stack) {
        return new XrFrameEndInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ndisplayTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)DISPLAYTIME);
    }

    public static int nenvironmentBlendMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENVIRONMENTBLENDMODE);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    @Nullable
    public static PointerBuffer nlayers(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)LAYERS)), (int)XrFrameEndInfo.nlayerCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ndisplayTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DISPLAYTIME, value);
    }

    public static void nenvironmentBlendMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENVIRONMENTBLENDMODE, value);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    public static void nlayers(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LAYERS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrFrameEndInfo.nlayerCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrFrameEndInfo.__struct((Struct.Member[])new Struct.Member[]{XrFrameEndInfo.__member((int)4), XrFrameEndInfo.__member((int)POINTER_SIZE), XrFrameEndInfo.__member((int)8), XrFrameEndInfo.__member((int)4), XrFrameEndInfo.__member((int)4), XrFrameEndInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        DISPLAYTIME = layout.offsetof(2);
        ENVIRONMENTBLENDMODE = layout.offsetof(3);
        LAYERCOUNT = layout.offsetof(4);
        LAYERS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrFrameEndInfo, Buffer>
    implements NativeResource {
        private static final XrFrameEndInfo ELEMENT_FACTORY = XrFrameEndInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFrameEndInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFrameEndInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFrameEndInfo.nnext(this.address());
        }

        @NativeType(value="XrTime")
        public long displayTime() {
            return XrFrameEndInfo.ndisplayTime(this.address());
        }

        @NativeType(value="XrEnvironmentBlendMode")
        public int environmentBlendMode() {
            return XrFrameEndInfo.nenvironmentBlendMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return XrFrameEndInfo.nlayerCount(this.address());
        }

        @Nullable
        @NativeType(value="XrCompositionLayerBaseHeader const * const *")
        public PointerBuffer layers() {
            return XrFrameEndInfo.nlayers(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFrameEndInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(12);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFrameEndInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrFrameEndInfoML value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrGlobalDimmerFrameEndInfoML value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrLocalDimmingFrameEndInfoMETA value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSecondaryViewConfigurationFrameEndInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer displayTime(@NativeType(value="XrTime") long value) {
            XrFrameEndInfo.ndisplayTime(this.address(), value);
            return this;
        }

        public Buffer environmentBlendMode(@NativeType(value="XrEnvironmentBlendMode") int value) {
            XrFrameEndInfo.nenvironmentBlendMode(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            XrFrameEndInfo.nlayerCount(this.address(), value);
            return this;
        }

        public Buffer layers(@Nullable @NativeType(value="XrCompositionLayerBaseHeader const * const *") PointerBuffer value) {
            XrFrameEndInfo.nlayers(this.address(), value);
            return this;
        }
    }
}

