/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrameEndInfoML
extends Struct<XrFrameEndInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FOCUSDISTANCE;
    public static final int FLAGS;

    protected XrFrameEndInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrFrameEndInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrFrameEndInfoML(address, container);
    }

    public XrFrameEndInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFrameEndInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFrameEndInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFrameEndInfoML.nnext(this.address());
    }

    public float focusDistance() {
        return XrFrameEndInfoML.nfocusDistance(this.address());
    }

    @NativeType(value="XrFrameEndInfoFlagsML")
    public long flags() {
        return XrFrameEndInfoML.nflags(this.address());
    }

    public XrFrameEndInfoML type(@NativeType(value="XrStructureType") int value) {
        XrFrameEndInfoML.ntype(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML type$Default() {
        return this.type(1000135000);
    }

    public XrFrameEndInfoML next(@NativeType(value="void const *") long value) {
        XrFrameEndInfoML.nnext(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML focusDistance(float value) {
        XrFrameEndInfoML.nfocusDistance(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML flags(@NativeType(value="XrFrameEndInfoFlagsML") long value) {
        XrFrameEndInfoML.nflags(this.address(), value);
        return this;
    }

    public XrFrameEndInfoML set(int type, long next, float focusDistance, long flags) {
        this.type(type);
        this.next(next);
        this.focusDistance(focusDistance);
        this.flags(flags);
        return this;
    }

    public XrFrameEndInfoML set(XrFrameEndInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFrameEndInfoML malloc() {
        return new XrFrameEndInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrFrameEndInfoML calloc() {
        return new XrFrameEndInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrFrameEndInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrFrameEndInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrFrameEndInfoML create(long address) {
        return new XrFrameEndInfoML(address, null);
    }

    @Nullable
    public static XrFrameEndInfoML createSafe(long address) {
        return address == 0L ? null : new XrFrameEndInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrFrameEndInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrameEndInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFrameEndInfoML malloc(MemoryStack stack) {
        return new XrFrameEndInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFrameEndInfoML calloc(MemoryStack stack) {
        return new XrFrameEndInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float nfocusDistance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FOCUSDISTANCE);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nfocusDistance(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)FOCUSDISTANCE, value);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = XrFrameEndInfoML.__struct((Struct.Member[])new Struct.Member[]{XrFrameEndInfoML.__member((int)4), XrFrameEndInfoML.__member((int)POINTER_SIZE), XrFrameEndInfoML.__member((int)4), XrFrameEndInfoML.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FOCUSDISTANCE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrFrameEndInfoML, Buffer>
    implements NativeResource {
        private static final XrFrameEndInfoML ELEMENT_FACTORY = XrFrameEndInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFrameEndInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFrameEndInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFrameEndInfoML.nnext(this.address());
        }

        public float focusDistance() {
            return XrFrameEndInfoML.nfocusDistance(this.address());
        }

        @NativeType(value="XrFrameEndInfoFlagsML")
        public long flags() {
            return XrFrameEndInfoML.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFrameEndInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000135000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFrameEndInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer focusDistance(float value) {
            XrFrameEndInfoML.nfocusDistance(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrFrameEndInfoFlagsML") long value) {
            XrFrameEndInfoML.nflags(this.address(), value);
            return this;
        }
    }
}

