/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshIndexBufferMSFT
extends Struct<XrHandMeshIndexBufferMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INDEXBUFFERKEY;
    public static final int INDEXCAPACITYINPUT;
    public static final int INDEXCOUNTOUTPUT;
    public static final int INDICES;

    protected XrHandMeshIndexBufferMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandMeshIndexBufferMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrHandMeshIndexBufferMSFT(address, container);
    }

    public XrHandMeshIndexBufferMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandMeshIndexBufferMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int indexBufferKey() {
        return XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCapacityInput() {
        return XrHandMeshIndexBufferMSFT.nindexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCountOutput() {
        return XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address());
    }

    @NativeType(value="uint32_t *")
    public IntBuffer indices() {
        return XrHandMeshIndexBufferMSFT.nindices(this.address());
    }

    public XrHandMeshIndexBufferMSFT indexBufferKey(@NativeType(value="uint32_t") int value) {
        XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address(), value);
        return this;
    }

    public XrHandMeshIndexBufferMSFT indexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address(), value);
        return this;
    }

    public XrHandMeshIndexBufferMSFT indices(@NativeType(value="uint32_t *") IntBuffer value) {
        XrHandMeshIndexBufferMSFT.nindices(this.address(), value);
        return this;
    }

    public XrHandMeshIndexBufferMSFT set(int indexBufferKey, int indexCountOutput, IntBuffer indices) {
        this.indexBufferKey(indexBufferKey);
        this.indexCountOutput(indexCountOutput);
        this.indices(indices);
        return this;
    }

    public XrHandMeshIndexBufferMSFT set(XrHandMeshIndexBufferMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandMeshIndexBufferMSFT malloc() {
        return new XrHandMeshIndexBufferMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandMeshIndexBufferMSFT calloc() {
        return new XrHandMeshIndexBufferMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandMeshIndexBufferMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandMeshIndexBufferMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandMeshIndexBufferMSFT create(long address) {
        return new XrHandMeshIndexBufferMSFT(address, null);
    }

    @Nullable
    public static XrHandMeshIndexBufferMSFT createSafe(long address) {
        return address == 0L ? null : new XrHandMeshIndexBufferMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandMeshIndexBufferMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshIndexBufferMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandMeshIndexBufferMSFT malloc(MemoryStack stack) {
        return new XrHandMeshIndexBufferMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandMeshIndexBufferMSFT calloc(MemoryStack stack) {
        return new XrHandMeshIndexBufferMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nindexBufferKey(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXBUFFERKEY);
    }

    public static int nindexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCAPACITYINPUT);
    }

    public static int nindexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCOUNTOUTPUT);
    }

    public static IntBuffer nindices(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)INDICES)), (int)XrHandMeshIndexBufferMSFT.nindexCapacityInput(struct));
    }

    public static void nindexBufferKey(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXBUFFERKEY, value);
    }

    public static void nindexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCAPACITYINPUT, value);
    }

    public static void nindexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCOUNTOUTPUT, value);
    }

    public static void nindices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INDICES), (long)MemoryUtil.memAddress((IntBuffer)value));
        XrHandMeshIndexBufferMSFT.nindexCapacityInput(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INDICES)));
    }

    static {
        Struct.Layout layout = XrHandMeshIndexBufferMSFT.__struct((Struct.Member[])new Struct.Member[]{XrHandMeshIndexBufferMSFT.__member((int)4), XrHandMeshIndexBufferMSFT.__member((int)4), XrHandMeshIndexBufferMSFT.__member((int)4), XrHandMeshIndexBufferMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INDEXBUFFERKEY = layout.offsetof(0);
        INDEXCAPACITYINPUT = layout.offsetof(1);
        INDEXCOUNTOUTPUT = layout.offsetof(2);
        INDICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshIndexBufferMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshIndexBufferMSFT ELEMENT_FACTORY = XrHandMeshIndexBufferMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandMeshIndexBufferMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int indexBufferKey() {
            return XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCapacityInput() {
            return XrHandMeshIndexBufferMSFT.nindexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCountOutput() {
            return XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address());
        }

        @NativeType(value="uint32_t *")
        public IntBuffer indices() {
            return XrHandMeshIndexBufferMSFT.nindices(this.address());
        }

        public Buffer indexBufferKey(@NativeType(value="uint32_t") int value) {
            XrHandMeshIndexBufferMSFT.nindexBufferKey(this.address(), value);
            return this;
        }

        public Buffer indexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandMeshIndexBufferMSFT.nindexCountOutput(this.address(), value);
            return this;
        }

        public Buffer indices(@NativeType(value="uint32_t *") IntBuffer value) {
            XrHandMeshIndexBufferMSFT.nindices(this.address(), value);
            return this;
        }
    }
}

