/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshVertexMSFT
extends Struct<XrHandMeshVertexMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITION;
    public static final int NORMAL;

    protected XrHandMeshVertexMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandMeshVertexMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrHandMeshVertexMSFT(address, container);
    }

    public XrHandMeshVertexMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandMeshVertexMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrVector3f position$() {
        return XrHandMeshVertexMSFT.nposition$(this.address());
    }

    public XrVector3f normal() {
        return XrHandMeshVertexMSFT.nnormal(this.address());
    }

    public XrHandMeshVertexMSFT position$(XrVector3f value) {
        XrHandMeshVertexMSFT.nposition$(this.address(), value);
        return this;
    }

    public XrHandMeshVertexMSFT position$(Consumer<XrVector3f> consumer) {
        consumer.accept(this.position$());
        return this;
    }

    public XrHandMeshVertexMSFT normal(XrVector3f value) {
        XrHandMeshVertexMSFT.nnormal(this.address(), value);
        return this;
    }

    public XrHandMeshVertexMSFT normal(Consumer<XrVector3f> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public XrHandMeshVertexMSFT set(XrVector3f position$, XrVector3f normal) {
        this.position$(position$);
        this.normal(normal);
        return this;
    }

    public XrHandMeshVertexMSFT set(XrHandMeshVertexMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandMeshVertexMSFT malloc() {
        return new XrHandMeshVertexMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandMeshVertexMSFT calloc() {
        return new XrHandMeshVertexMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandMeshVertexMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandMeshVertexMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandMeshVertexMSFT create(long address) {
        return new XrHandMeshVertexMSFT(address, null);
    }

    @Nullable
    public static XrHandMeshVertexMSFT createSafe(long address) {
        return address == 0L ? null : new XrHandMeshVertexMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandMeshVertexMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshVertexMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandMeshVertexMSFT malloc(MemoryStack stack) {
        return new XrHandMeshVertexMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandMeshVertexMSFT calloc(MemoryStack stack) {
        return new XrHandMeshVertexMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrVector3f nposition$(long struct) {
        return XrVector3f.create(struct + (long)POSITION);
    }

    public static XrVector3f nnormal(long struct) {
        return XrVector3f.create(struct + (long)NORMAL);
    }

    public static void nposition$(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSITION), (long)XrVector3f.SIZEOF);
    }

    public static void nnormal(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NORMAL), (long)XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrHandMeshVertexMSFT.__struct((Struct.Member[])new Struct.Member[]{XrHandMeshVertexMSFT.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF), XrHandMeshVertexMSFT.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITION = layout.offsetof(0);
        NORMAL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshVertexMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshVertexMSFT ELEMENT_FACTORY = XrHandMeshVertexMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandMeshVertexMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrVector3f position$() {
            return XrHandMeshVertexMSFT.nposition$(this.address());
        }

        public XrVector3f normal() {
            return XrHandMeshVertexMSFT.nnormal(this.address());
        }

        public Buffer position$(XrVector3f value) {
            XrHandMeshVertexMSFT.nposition$(this.address(), value);
            return this;
        }

        public Buffer position$(Consumer<XrVector3f> consumer) {
            consumer.accept(this.position$());
            return this;
        }

        public Buffer normal(XrVector3f value) {
            XrHandMeshVertexMSFT.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<XrVector3f> consumer) {
            consumer.accept(this.normal());
            return this;
        }
    }
}

