/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingDataSourceStateEXT
extends Struct<XrHandTrackingDataSourceStateEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ISACTIVE;
    public static final int DATASOURCE;

    protected XrHandTrackingDataSourceStateEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandTrackingDataSourceStateEXT create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackingDataSourceStateEXT(address, container);
    }

    public XrHandTrackingDataSourceStateEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandTrackingDataSourceStateEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingDataSourceStateEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingDataSourceStateEXT.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrHandTrackingDataSourceStateEXT.nisActive(this.address()) != 0;
    }

    @NativeType(value="XrHandTrackingDataSourceEXT")
    public int dataSource() {
        return XrHandTrackingDataSourceStateEXT.ndataSource(this.address());
    }

    public XrHandTrackingDataSourceStateEXT type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingDataSourceStateEXT.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingDataSourceStateEXT type$Default() {
        return this.type(1000428001);
    }

    public XrHandTrackingDataSourceStateEXT next(@NativeType(value="void *") long value) {
        XrHandTrackingDataSourceStateEXT.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingDataSourceStateEXT isActive(@NativeType(value="XrBool32") boolean value) {
        XrHandTrackingDataSourceStateEXT.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrHandTrackingDataSourceStateEXT dataSource(@NativeType(value="XrHandTrackingDataSourceEXT") int value) {
        XrHandTrackingDataSourceStateEXT.ndataSource(this.address(), value);
        return this;
    }

    public XrHandTrackingDataSourceStateEXT set(int type, long next, boolean isActive, int dataSource) {
        this.type(type);
        this.next(next);
        this.isActive(isActive);
        this.dataSource(dataSource);
        return this;
    }

    public XrHandTrackingDataSourceStateEXT set(XrHandTrackingDataSourceStateEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandTrackingDataSourceStateEXT malloc() {
        return new XrHandTrackingDataSourceStateEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandTrackingDataSourceStateEXT calloc() {
        return new XrHandTrackingDataSourceStateEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandTrackingDataSourceStateEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandTrackingDataSourceStateEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandTrackingDataSourceStateEXT create(long address) {
        return new XrHandTrackingDataSourceStateEXT(address, null);
    }

    @Nullable
    public static XrHandTrackingDataSourceStateEXT createSafe(long address) {
        return address == 0L ? null : new XrHandTrackingDataSourceStateEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandTrackingDataSourceStateEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingDataSourceStateEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackingDataSourceStateEXT malloc(MemoryStack stack) {
        return new XrHandTrackingDataSourceStateEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackingDataSourceStateEXT calloc(MemoryStack stack) {
        return new XrHandTrackingDataSourceStateEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nisActive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISACTIVE);
    }

    public static int ndataSource(long struct) {
        return UNSAFE.getInt(null, struct + (long)DATASOURCE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nisActive(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ISACTIVE, value);
    }

    public static void ndataSource(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DATASOURCE, value);
    }

    static {
        Struct.Layout layout = XrHandTrackingDataSourceStateEXT.__struct((Struct.Member[])new Struct.Member[]{XrHandTrackingDataSourceStateEXT.__member((int)4), XrHandTrackingDataSourceStateEXT.__member((int)POINTER_SIZE), XrHandTrackingDataSourceStateEXT.__member((int)4), XrHandTrackingDataSourceStateEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ISACTIVE = layout.offsetof(2);
        DATASOURCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingDataSourceStateEXT, Buffer>
    implements NativeResource {
        private static final XrHandTrackingDataSourceStateEXT ELEMENT_FACTORY = XrHandTrackingDataSourceStateEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHandTrackingDataSourceStateEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingDataSourceStateEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingDataSourceStateEXT.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrHandTrackingDataSourceStateEXT.nisActive(this.address()) != 0;
        }

        @NativeType(value="XrHandTrackingDataSourceEXT")
        public int dataSource() {
            return XrHandTrackingDataSourceStateEXT.ndataSource(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingDataSourceStateEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000428001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingDataSourceStateEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrHandTrackingDataSourceStateEXT.nisActive(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer dataSource(@NativeType(value="XrHandTrackingDataSourceEXT") int value) {
            XrHandTrackingDataSourceStateEXT.ndataSource(this.address(), value);
            return this;
        }
    }
}

