/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHapticPcmVibrationFB
extends Struct<XrHapticPcmVibrationFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BUFFERSIZE;
    public static final int BUFFER;
    public static final int SAMPLERATE;
    public static final int APPEND;
    public static final int SAMPLESCONSUMED;

    protected XrHapticPcmVibrationFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHapticPcmVibrationFB create(long address, @Nullable ByteBuffer container) {
        return new XrHapticPcmVibrationFB(address, container);
    }

    public XrHapticPcmVibrationFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHapticPcmVibrationFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHapticPcmVibrationFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHapticPcmVibrationFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferSize() {
        return XrHapticPcmVibrationFB.nbufferSize(this.address());
    }

    @NativeType(value="float const *")
    public FloatBuffer buffer() {
        return XrHapticPcmVibrationFB.nbuffer(this.address());
    }

    public float sampleRate() {
        return XrHapticPcmVibrationFB.nsampleRate(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean append() {
        return XrHapticPcmVibrationFB.nappend(this.address()) != 0;
    }

    @NativeType(value="uint32_t *")
    public IntBuffer samplesConsumed(int capacity) {
        return XrHapticPcmVibrationFB.nsamplesConsumed(this.address(), capacity);
    }

    public XrHapticPcmVibrationFB type(@NativeType(value="XrStructureType") int value) {
        XrHapticPcmVibrationFB.ntype(this.address(), value);
        return this;
    }

    public XrHapticPcmVibrationFB type$Default() {
        return this.type(1000209001);
    }

    public XrHapticPcmVibrationFB next(@NativeType(value="void const *") long value) {
        XrHapticPcmVibrationFB.nnext(this.address(), value);
        return this;
    }

    public XrHapticPcmVibrationFB buffer(@NativeType(value="float const *") FloatBuffer value) {
        XrHapticPcmVibrationFB.nbuffer(this.address(), value);
        return this;
    }

    public XrHapticPcmVibrationFB sampleRate(float value) {
        XrHapticPcmVibrationFB.nsampleRate(this.address(), value);
        return this;
    }

    public XrHapticPcmVibrationFB append(@NativeType(value="XrBool32") boolean value) {
        XrHapticPcmVibrationFB.nappend(this.address(), value ? 1 : 0);
        return this;
    }

    public XrHapticPcmVibrationFB samplesConsumed(@NativeType(value="uint32_t *") IntBuffer value) {
        XrHapticPcmVibrationFB.nsamplesConsumed(this.address(), value);
        return this;
    }

    public XrHapticPcmVibrationFB set(int type, long next, FloatBuffer buffer, float sampleRate, boolean append, IntBuffer samplesConsumed) {
        this.type(type);
        this.next(next);
        this.buffer(buffer);
        this.sampleRate(sampleRate);
        this.append(append);
        this.samplesConsumed(samplesConsumed);
        return this;
    }

    public XrHapticPcmVibrationFB set(XrHapticPcmVibrationFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHapticPcmVibrationFB malloc() {
        return new XrHapticPcmVibrationFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHapticPcmVibrationFB calloc() {
        return new XrHapticPcmVibrationFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHapticPcmVibrationFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHapticPcmVibrationFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHapticPcmVibrationFB create(long address) {
        return new XrHapticPcmVibrationFB(address, null);
    }

    @Nullable
    public static XrHapticPcmVibrationFB createSafe(long address) {
        return address == 0L ? null : new XrHapticPcmVibrationFB(address, null);
    }

    public static XrHapticPcmVibrationFB create(XrHapticBaseHeader value) {
        return new XrHapticPcmVibrationFB(value.address(), XrHapticPcmVibrationFB.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHapticPcmVibrationFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHapticPcmVibrationFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrHapticBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrHapticPcmVibrationFB.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrHapticPcmVibrationFB malloc(MemoryStack stack) {
        return new XrHapticPcmVibrationFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHapticPcmVibrationFB calloc(MemoryStack stack) {
        return new XrHapticPcmVibrationFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nbufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERSIZE);
    }

    public static FloatBuffer nbuffer(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)XrHapticPcmVibrationFB.nbufferSize(struct));
    }

    public static float nsampleRate(long struct) {
        return UNSAFE.getFloat(null, struct + (long)SAMPLERATE);
    }

    public static int nappend(long struct) {
        return UNSAFE.getInt(null, struct + (long)APPEND);
    }

    public static IntBuffer nsamplesConsumed(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLESCONSUMED)), (int)capacity);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERSIZE, value);
    }

    public static void nbuffer(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)MemoryUtil.memAddress((FloatBuffer)value));
        XrHapticPcmVibrationFB.nbufferSize(struct, value.remaining());
    }

    public static void nsampleRate(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)SAMPLERATE, value);
    }

    public static void nappend(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)APPEND, value);
    }

    public static void nsamplesConsumed(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SAMPLESCONSUMED), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLESCONSUMED)));
    }

    static {
        Struct.Layout layout = XrHapticPcmVibrationFB.__struct((Struct.Member[])new Struct.Member[]{XrHapticPcmVibrationFB.__member((int)4), XrHapticPcmVibrationFB.__member((int)POINTER_SIZE), XrHapticPcmVibrationFB.__member((int)4), XrHapticPcmVibrationFB.__member((int)POINTER_SIZE), XrHapticPcmVibrationFB.__member((int)4), XrHapticPcmVibrationFB.__member((int)4), XrHapticPcmVibrationFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BUFFERSIZE = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        SAMPLERATE = layout.offsetof(4);
        APPEND = layout.offsetof(5);
        SAMPLESCONSUMED = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrHapticPcmVibrationFB, Buffer>
    implements NativeResource {
        private static final XrHapticPcmVibrationFB ELEMENT_FACTORY = XrHapticPcmVibrationFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHapticPcmVibrationFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHapticPcmVibrationFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHapticPcmVibrationFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferSize() {
            return XrHapticPcmVibrationFB.nbufferSize(this.address());
        }

        @NativeType(value="float const *")
        public FloatBuffer buffer() {
            return XrHapticPcmVibrationFB.nbuffer(this.address());
        }

        public float sampleRate() {
            return XrHapticPcmVibrationFB.nsampleRate(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean append() {
            return XrHapticPcmVibrationFB.nappend(this.address()) != 0;
        }

        @NativeType(value="uint32_t *")
        public IntBuffer samplesConsumed(int capacity) {
            return XrHapticPcmVibrationFB.nsamplesConsumed(this.address(), capacity);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHapticPcmVibrationFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000209001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHapticPcmVibrationFB.nnext(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="float const *") FloatBuffer value) {
            XrHapticPcmVibrationFB.nbuffer(this.address(), value);
            return this;
        }

        public Buffer sampleRate(float value) {
            XrHapticPcmVibrationFB.nsampleRate(this.address(), value);
            return this;
        }

        public Buffer append(@NativeType(value="XrBool32") boolean value) {
            XrHapticPcmVibrationFB.nappend(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer samplesConsumed(@NativeType(value="uint32_t *") IntBuffer value) {
            XrHapticPcmVibrationFB.nsamplesConsumed(this.address(), value);
            return this;
        }
    }
}

