/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPlaneDetectorGetInfoEXT
extends Struct<XrPlaneDetectorGetInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;

    protected XrPlaneDetectorGetInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrPlaneDetectorGetInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new XrPlaneDetectorGetInfoEXT(address, container);
    }

    public XrPlaneDetectorGetInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPlaneDetectorGetInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPlaneDetectorGetInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPlaneDetectorGetInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrPlaneDetectorGetInfoEXT.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrPlaneDetectorGetInfoEXT.ntime(this.address());
    }

    public XrPlaneDetectorGetInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrPlaneDetectorGetInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrPlaneDetectorGetInfoEXT type$Default() {
        return this.type(1000429003);
    }

    public XrPlaneDetectorGetInfoEXT next(@NativeType(value="void const *") long value) {
        XrPlaneDetectorGetInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrPlaneDetectorGetInfoEXT baseSpace(XrSpace value) {
        XrPlaneDetectorGetInfoEXT.nbaseSpace(this.address(), value);
        return this;
    }

    public XrPlaneDetectorGetInfoEXT time(@NativeType(value="XrTime") long value) {
        XrPlaneDetectorGetInfoEXT.ntime(this.address(), value);
        return this;
    }

    public XrPlaneDetectorGetInfoEXT set(int type, long next, XrSpace baseSpace, long time) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        return this;
    }

    public XrPlaneDetectorGetInfoEXT set(XrPlaneDetectorGetInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPlaneDetectorGetInfoEXT malloc() {
        return new XrPlaneDetectorGetInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrPlaneDetectorGetInfoEXT calloc() {
        return new XrPlaneDetectorGetInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrPlaneDetectorGetInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrPlaneDetectorGetInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrPlaneDetectorGetInfoEXT create(long address) {
        return new XrPlaneDetectorGetInfoEXT(address, null);
    }

    @Nullable
    public static XrPlaneDetectorGetInfoEXT createSafe(long address) {
        return address == 0L ? null : new XrPlaneDetectorGetInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrPlaneDetectorGetInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPlaneDetectorGetInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPlaneDetectorGetInfoEXT malloc(MemoryStack stack) {
        return new XrPlaneDetectorGetInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPlaneDetectorGetInfoEXT calloc(MemoryStack stack) {
        return new XrPlaneDetectorGetInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE));
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASESPACE), (long)value.address());
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE)));
    }

    static {
        Struct.Layout layout = XrPlaneDetectorGetInfoEXT.__struct((Struct.Member[])new Struct.Member[]{XrPlaneDetectorGetInfoEXT.__member((int)4), XrPlaneDetectorGetInfoEXT.__member((int)POINTER_SIZE), XrPlaneDetectorGetInfoEXT.__member((int)POINTER_SIZE), XrPlaneDetectorGetInfoEXT.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrPlaneDetectorGetInfoEXT, Buffer>
    implements NativeResource {
        private static final XrPlaneDetectorGetInfoEXT ELEMENT_FACTORY = XrPlaneDetectorGetInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrPlaneDetectorGetInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPlaneDetectorGetInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPlaneDetectorGetInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrPlaneDetectorGetInfoEXT.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrPlaneDetectorGetInfoEXT.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPlaneDetectorGetInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000429003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPlaneDetectorGetInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrPlaneDetectorGetInfoEXT.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrPlaneDetectorGetInfoEXT.ntime(this.address(), value);
            return this;
        }
    }
}

