/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneCreateInfoMSFT
extends Struct<XrSceneCreateInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSceneCreateInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneCreateInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneCreateInfoMSFT(address, container);
    }

    public XrSceneCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneCreateInfoMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSceneCreateInfoMSFT.nnext(this.address());
    }

    public XrSceneCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneCreateInfoMSFT type$Default() {
        return this.type(1000097001);
    }

    public XrSceneCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSceneCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneCreateInfoMSFT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSceneCreateInfoMSFT set(XrSceneCreateInfoMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneCreateInfoMSFT malloc() {
        return new XrSceneCreateInfoMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneCreateInfoMSFT calloc() {
        return new XrSceneCreateInfoMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneCreateInfoMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneCreateInfoMSFT create(long address) {
        return new XrSceneCreateInfoMSFT(address, null);
    }

    @Nullable
    public static XrSceneCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneCreateInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneCreateInfoMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneCreateInfoMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneCreateInfoMSFT malloc(MemoryStack stack) {
        return new XrSceneCreateInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneCreateInfoMSFT calloc(MemoryStack stack) {
        return new XrSceneCreateInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSceneCreateInfoMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneCreateInfoMSFT.__member((int)4), XrSceneCreateInfoMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneCreateInfoMSFT ELEMENT_FACTORY = XrSceneCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSceneCreateInfoMSFT.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSceneCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }
    }
}

