/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialGraphNodeSpaceCreateInfoMSFT
extends Struct<XrSpatialGraphNodeSpaceCreateInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NODETYPE;
    public static final int NODEID;
    public static final int POSE;

    protected XrSpatialGraphNodeSpaceCreateInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpatialGraphNodeSpaceCreateInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(address, container);
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpatialGraphNodeSpaceCreateInfoMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrSpatialGraphNodeTypeMSFT")
    public int nodeType() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address());
    }

    @NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]")
    public ByteBuffer nodeId() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address());
    }

    @NativeType(value="uint8_t")
    public byte nodeId(int index) {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index);
    }

    public XrPosef pose() {
        return XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address());
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT type$Default() {
        return this.type(1000049000);
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT nodeType(@NativeType(value="XrSpatialGraphNodeTypeMSFT") int value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT nodeId(@NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]") ByteBuffer value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT nodeId(int index, @NativeType(value="uint8_t") byte value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index, value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT pose(XrPosef value) {
        XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address(), value);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT set(int type, long next, int nodeType, ByteBuffer nodeId, XrPosef pose) {
        this.type(type);
        this.next(next);
        this.nodeType(nodeType);
        this.nodeId(nodeId);
        this.pose(pose);
        return this;
    }

    public XrSpatialGraphNodeSpaceCreateInfoMSFT set(XrSpatialGraphNodeSpaceCreateInfoMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT malloc() {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT calloc() {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT create(long address) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(address, null);
    }

    @Nullable
    public static XrSpatialGraphNodeSpaceCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrSpatialGraphNodeSpaceCreateInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpatialGraphNodeSpaceCreateInfoMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialGraphNodeSpaceCreateInfoMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT malloc(MemoryStack stack) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialGraphNodeSpaceCreateInfoMSFT calloc(MemoryStack stack) {
        return new XrSpatialGraphNodeSpaceCreateInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nnodeType(long struct) {
        return UNSAFE.getInt(null, struct + (long)NODETYPE);
    }

    public static ByteBuffer nnodeId(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NODEID), (int)16);
    }

    public static byte nnodeId(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)NODEID + Checks.check((int)index, (int)16) * 1L);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nnodeType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NODETYPE, value);
    }

    public static void nnodeId(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)NODEID), (long)(value.remaining() * 1));
    }

    public static void nnodeId(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)NODEID + Checks.check((int)index, (int)16) * 1L, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSpatialGraphNodeSpaceCreateInfoMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSpatialGraphNodeSpaceCreateInfoMSFT.__member((int)4), XrSpatialGraphNodeSpaceCreateInfoMSFT.__member((int)POINTER_SIZE), XrSpatialGraphNodeSpaceCreateInfoMSFT.__member((int)4), XrSpatialGraphNodeSpaceCreateInfoMSFT.__array((int)1, (int)16), XrSpatialGraphNodeSpaceCreateInfoMSFT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NODETYPE = layout.offsetof(2);
        NODEID = layout.offsetof(3);
        POSE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialGraphNodeSpaceCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrSpatialGraphNodeSpaceCreateInfoMSFT ELEMENT_FACTORY = XrSpatialGraphNodeSpaceCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSpatialGraphNodeSpaceCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrSpatialGraphNodeTypeMSFT")
        public int nodeType() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address());
        }

        @NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]")
        public ByteBuffer nodeId() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address());
        }

        @NativeType(value="uint8_t")
        public byte nodeId(int index) {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index);
        }

        public XrPosef pose() {
            return XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000049000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer nodeType(@NativeType(value="XrSpatialGraphNodeTypeMSFT") int value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeType(this.address(), value);
            return this;
        }

        public Buffer nodeId(@NativeType(value="uint8_t[XR_GUID_SIZE_MSFT]") ByteBuffer value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), value);
            return this;
        }

        public Buffer nodeId(int index, @NativeType(value="uint8_t") byte value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.nnodeId(this.address(), index, value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrSpatialGraphNodeSpaceCreateInfoMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

