/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;
import org.lwjgl.openxr.XrSwapchainImageVulkanKHR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainImageBaseHeader
extends Struct<XrSwapchainImageBaseHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrSwapchainImageBaseHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSwapchainImageBaseHeader create(long address, @Nullable ByteBuffer container) {
        return new XrSwapchainImageBaseHeader(address, container);
    }

    public XrSwapchainImageBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSwapchainImageBaseHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSwapchainImageBaseHeader.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSwapchainImageBaseHeader.nnext(this.address());
    }

    public XrSwapchainImageBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrSwapchainImageBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrSwapchainImageBaseHeader next(@NativeType(value="void *") long value) {
        XrSwapchainImageBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrSwapchainImageBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSwapchainImageBaseHeader set(XrSwapchainImageBaseHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSwapchainImageBaseHeader malloc() {
        return new XrSwapchainImageBaseHeader(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSwapchainImageBaseHeader calloc() {
        return new XrSwapchainImageBaseHeader(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSwapchainImageBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSwapchainImageBaseHeader(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSwapchainImageBaseHeader create(long address) {
        return new XrSwapchainImageBaseHeader(address, null);
    }

    @Nullable
    public static XrSwapchainImageBaseHeader createSafe(long address) {
        return address == 0L ? null : new XrSwapchainImageBaseHeader(address, null);
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageOpenGLKHR value) {
        return new XrSwapchainImageBaseHeader(value.address(), XrSwapchainImageBaseHeader.__getContainer((Struct)value));
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageVulkanKHR value) {
        return new XrSwapchainImageBaseHeader(value.address(), XrSwapchainImageBaseHeader.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSwapchainImageBaseHeader.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainImageBaseHeader.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrSwapchainImageOpenGLKHR.Buffer value) {
        return new Buffer(value.address(), XrSwapchainImageBaseHeader.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrSwapchainImageVulkanKHR.Buffer value) {
        return new Buffer(value.address(), XrSwapchainImageBaseHeader.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrSwapchainImageBaseHeader malloc(MemoryStack stack) {
        return new XrSwapchainImageBaseHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSwapchainImageBaseHeader calloc(MemoryStack stack) {
        return new XrSwapchainImageBaseHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSwapchainImageBaseHeader.__struct((Struct.Member[])new Struct.Member[]{XrSwapchainImageBaseHeader.__member((int)4), XrSwapchainImageBaseHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainImageBaseHeader, Buffer>
    implements NativeResource {
        private static final XrSwapchainImageBaseHeader ELEMENT_FACTORY = XrSwapchainImageBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSwapchainImageBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSwapchainImageBaseHeader.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSwapchainImageBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSwapchainImageBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSwapchainImageBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

