/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemHandTrackingPropertiesEXT
extends Struct<XrSystemHandTrackingPropertiesEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSHANDTRACKING;

    protected XrSystemHandTrackingPropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSystemHandTrackingPropertiesEXT create(long address, @Nullable ByteBuffer container) {
        return new XrSystemHandTrackingPropertiesEXT(address, container);
    }

    public XrSystemHandTrackingPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSystemHandTrackingPropertiesEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemHandTrackingPropertiesEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemHandTrackingPropertiesEXT.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsHandTracking() {
        return XrSystemHandTrackingPropertiesEXT.nsupportsHandTracking(this.address()) != 0;
    }

    public XrSystemHandTrackingPropertiesEXT type(@NativeType(value="XrStructureType") int value) {
        XrSystemHandTrackingPropertiesEXT.ntype(this.address(), value);
        return this;
    }

    public XrSystemHandTrackingPropertiesEXT type$Default() {
        return this.type(1000051000);
    }

    public XrSystemHandTrackingPropertiesEXT next(@NativeType(value="void *") long value) {
        XrSystemHandTrackingPropertiesEXT.nnext(this.address(), value);
        return this;
    }

    public XrSystemHandTrackingPropertiesEXT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemHandTrackingPropertiesEXT set(XrSystemHandTrackingPropertiesEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSystemHandTrackingPropertiesEXT malloc() {
        return new XrSystemHandTrackingPropertiesEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSystemHandTrackingPropertiesEXT calloc() {
        return new XrSystemHandTrackingPropertiesEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSystemHandTrackingPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSystemHandTrackingPropertiesEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSystemHandTrackingPropertiesEXT create(long address) {
        return new XrSystemHandTrackingPropertiesEXT(address, null);
    }

    @Nullable
    public static XrSystemHandTrackingPropertiesEXT createSafe(long address) {
        return address == 0L ? null : new XrSystemHandTrackingPropertiesEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSystemHandTrackingPropertiesEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemHandTrackingPropertiesEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemHandTrackingPropertiesEXT malloc(MemoryStack stack) {
        return new XrSystemHandTrackingPropertiesEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemHandTrackingPropertiesEXT calloc(MemoryStack stack) {
        return new XrSystemHandTrackingPropertiesEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nsupportsHandTracking(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTSHANDTRACKING);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSystemHandTrackingPropertiesEXT.__struct((Struct.Member[])new Struct.Member[]{XrSystemHandTrackingPropertiesEXT.__member((int)4), XrSystemHandTrackingPropertiesEXT.__member((int)POINTER_SIZE), XrSystemHandTrackingPropertiesEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSHANDTRACKING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemHandTrackingPropertiesEXT, Buffer>
    implements NativeResource {
        private static final XrSystemHandTrackingPropertiesEXT ELEMENT_FACTORY = XrSystemHandTrackingPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSystemHandTrackingPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemHandTrackingPropertiesEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemHandTrackingPropertiesEXT.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsHandTracking() {
            return XrSystemHandTrackingPropertiesEXT.nsupportsHandTracking(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemHandTrackingPropertiesEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000051000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemHandTrackingPropertiesEXT.nnext(this.address(), value);
            return this;
        }
    }
}

