/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrRenderModelCapabilitiesRequestFB;
import org.lwjgl.openxr.XrSystemBodyTrackingPropertiesFB;
import org.lwjgl.openxr.XrSystemColorSpacePropertiesFB;
import org.lwjgl.openxr.XrSystemEyeGazeInteractionPropertiesEXT;
import org.lwjgl.openxr.XrSystemEyeTrackingPropertiesFB;
import org.lwjgl.openxr.XrSystemFaceTrackingPropertiesFB;
import org.lwjgl.openxr.XrSystemFacialTrackingPropertiesHTC;
import org.lwjgl.openxr.XrSystemForceFeedbackCurlPropertiesMNDX;
import org.lwjgl.openxr.XrSystemFoveatedRenderingPropertiesVARJO;
import org.lwjgl.openxr.XrSystemFoveationEyeTrackedPropertiesMETA;
import org.lwjgl.openxr.XrSystemGraphicsProperties;
import org.lwjgl.openxr.XrSystemHandTrackingMeshPropertiesMSFT;
import org.lwjgl.openxr.XrSystemHandTrackingPropertiesEXT;
import org.lwjgl.openxr.XrSystemHeadsetIdPropertiesMETA;
import org.lwjgl.openxr.XrSystemKeyboardTrackingPropertiesFB;
import org.lwjgl.openxr.XrSystemMarkerTrackingPropertiesVARJO;
import org.lwjgl.openxr.XrSystemPassthroughColorLutPropertiesMETA;
import org.lwjgl.openxr.XrSystemPassthroughProperties2FB;
import org.lwjgl.openxr.XrSystemPassthroughPropertiesFB;
import org.lwjgl.openxr.XrSystemPlaneDetectionPropertiesEXT;
import org.lwjgl.openxr.XrSystemRenderModelPropertiesFB;
import org.lwjgl.openxr.XrSystemSpaceWarpPropertiesFB;
import org.lwjgl.openxr.XrSystemSpatialEntityPropertiesFB;
import org.lwjgl.openxr.XrSystemTrackingProperties;
import org.lwjgl.openxr.XrSystemVirtualKeyboardPropertiesMETA;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemProperties
extends Struct<XrSystemProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SYSTEMID;
    public static final int VENDORID;
    public static final int SYSTEMNAME;
    public static final int GRAPHICSPROPERTIES;
    public static final int TRACKINGPROPERTIES;

    protected XrSystemProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSystemProperties create(long address, @Nullable ByteBuffer container) {
        return new XrSystemProperties(address, container);
    }

    public XrSystemProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSystemProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemProperties.nnext(this.address());
    }

    @NativeType(value="XrSystemId")
    public long systemId() {
        return XrSystemProperties.nsystemId(this.address());
    }

    @NativeType(value="uint32_t")
    public int vendorId() {
        return XrSystemProperties.nvendorId(this.address());
    }

    @NativeType(value="char[XR_MAX_SYSTEM_NAME_SIZE]")
    public ByteBuffer systemName() {
        return XrSystemProperties.nsystemName(this.address());
    }

    @NativeType(value="char[XR_MAX_SYSTEM_NAME_SIZE]")
    public String systemNameString() {
        return XrSystemProperties.nsystemNameString(this.address());
    }

    public XrSystemGraphicsProperties graphicsProperties() {
        return XrSystemProperties.ngraphicsProperties(this.address());
    }

    public XrSystemTrackingProperties trackingProperties() {
        return XrSystemProperties.ntrackingProperties(this.address());
    }

    public XrSystemProperties type(@NativeType(value="XrStructureType") int value) {
        XrSystemProperties.ntype(this.address(), value);
        return this;
    }

    public XrSystemProperties type$Default() {
        return this.type(5);
    }

    public XrSystemProperties next(@NativeType(value="void *") long value) {
        XrSystemProperties.nnext(this.address(), value);
        return this;
    }

    public XrSystemProperties next(XrRenderModelCapabilitiesRequestFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemBodyTrackingPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemColorSpacePropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemEyeGazeInteractionPropertiesEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemEyeTrackingPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemFaceTrackingPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemFacialTrackingPropertiesHTC value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemForceFeedbackCurlPropertiesMNDX value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemFoveatedRenderingPropertiesVARJO value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemFoveationEyeTrackedPropertiesMETA value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemHandTrackingMeshPropertiesMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemHandTrackingPropertiesEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemHeadsetIdPropertiesMETA value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemKeyboardTrackingPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemMarkerTrackingPropertiesVARJO value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemPassthroughColorLutPropertiesMETA value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemPassthroughProperties2FB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemPassthroughPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemPlaneDetectionPropertiesEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemRenderModelPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemSpaceWarpPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemSpatialEntityPropertiesFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties next(XrSystemVirtualKeyboardPropertiesMETA value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSystemProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSystemProperties set(XrSystemProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSystemProperties malloc() {
        return new XrSystemProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSystemProperties calloc() {
        return new XrSystemProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSystemProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSystemProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSystemProperties create(long address) {
        return new XrSystemProperties(address, null);
    }

    @Nullable
    public static XrSystemProperties createSafe(long address) {
        return address == 0L ? null : new XrSystemProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSystemProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemProperties malloc(MemoryStack stack) {
        return new XrSystemProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemProperties calloc(MemoryStack stack) {
        return new XrSystemProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nsystemId(long struct) {
        return UNSAFE.getLong(null, struct + (long)SYSTEMID);
    }

    public static int nvendorId(long struct) {
        return UNSAFE.getInt(null, struct + (long)VENDORID);
    }

    public static ByteBuffer nsystemName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)SYSTEMNAME), (int)256);
    }

    public static String nsystemNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)SYSTEMNAME));
    }

    public static XrSystemGraphicsProperties ngraphicsProperties(long struct) {
        return XrSystemGraphicsProperties.create(struct + (long)GRAPHICSPROPERTIES);
    }

    public static XrSystemTrackingProperties ntrackingProperties(long struct) {
        return XrSystemTrackingProperties.create(struct + (long)TRACKINGPROPERTIES);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSystemProperties.__struct((Struct.Member[])new Struct.Member[]{XrSystemProperties.__member((int)4), XrSystemProperties.__member((int)POINTER_SIZE), XrSystemProperties.__member((int)8), XrSystemProperties.__member((int)4), XrSystemProperties.__array((int)1, (int)256), XrSystemProperties.__member((int)XrSystemGraphicsProperties.SIZEOF, (int)XrSystemGraphicsProperties.ALIGNOF), XrSystemProperties.__member((int)XrSystemTrackingProperties.SIZEOF, (int)XrSystemTrackingProperties.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SYSTEMID = layout.offsetof(2);
        VENDORID = layout.offsetof(3);
        SYSTEMNAME = layout.offsetof(4);
        GRAPHICSPROPERTIES = layout.offsetof(5);
        TRACKINGPROPERTIES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrSystemProperties, Buffer>
    implements NativeResource {
        private static final XrSystemProperties ELEMENT_FACTORY = XrSystemProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSystemProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemProperties.nnext(this.address());
        }

        @NativeType(value="XrSystemId")
        public long systemId() {
            return XrSystemProperties.nsystemId(this.address());
        }

        @NativeType(value="uint32_t")
        public int vendorId() {
            return XrSystemProperties.nvendorId(this.address());
        }

        @NativeType(value="char[XR_MAX_SYSTEM_NAME_SIZE]")
        public ByteBuffer systemName() {
            return XrSystemProperties.nsystemName(this.address());
        }

        @NativeType(value="char[XR_MAX_SYSTEM_NAME_SIZE]")
        public String systemNameString() {
            return XrSystemProperties.nsystemNameString(this.address());
        }

        public XrSystemGraphicsProperties graphicsProperties() {
            return XrSystemProperties.ngraphicsProperties(this.address());
        }

        public XrSystemTrackingProperties trackingProperties() {
            return XrSystemProperties.ntrackingProperties(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(5);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemProperties.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrRenderModelCapabilitiesRequestFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemBodyTrackingPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemColorSpacePropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemEyeGazeInteractionPropertiesEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemEyeTrackingPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemFaceTrackingPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemFacialTrackingPropertiesHTC value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemForceFeedbackCurlPropertiesMNDX value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemFoveatedRenderingPropertiesVARJO value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemFoveationEyeTrackedPropertiesMETA value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemHandTrackingMeshPropertiesMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemHandTrackingPropertiesEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemHeadsetIdPropertiesMETA value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemKeyboardTrackingPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemMarkerTrackingPropertiesVARJO value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemPassthroughColorLutPropertiesMETA value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemPassthroughProperties2FB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemPassthroughPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemPlaneDetectionPropertiesEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemRenderModelPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemSpaceWarpPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemSpatialEntityPropertiesFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSystemVirtualKeyboardPropertiesMETA value) {
            return this.next(value.next(this.next()).address());
        }
    }
}

