/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFoveatedViewConfigurationViewVARJO;
import org.lwjgl.openxr.XrViewConfigurationDepthRangeEXT;
import org.lwjgl.openxr.XrViewConfigurationViewFovEPIC;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewConfigurationView
extends Struct<XrViewConfigurationView>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RECOMMENDEDIMAGERECTWIDTH;
    public static final int MAXIMAGERECTWIDTH;
    public static final int RECOMMENDEDIMAGERECTHEIGHT;
    public static final int MAXIMAGERECTHEIGHT;
    public static final int RECOMMENDEDSWAPCHAINSAMPLECOUNT;
    public static final int MAXSWAPCHAINSAMPLECOUNT;

    protected XrViewConfigurationView(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrViewConfigurationView create(long address, @Nullable ByteBuffer container) {
        return new XrViewConfigurationView(address, container);
    }

    public XrViewConfigurationView(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViewConfigurationView.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewConfigurationView.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViewConfigurationView.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int recommendedImageRectWidth() {
        return XrViewConfigurationView.nrecommendedImageRectWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageRectWidth() {
        return XrViewConfigurationView.nmaxImageRectWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int recommendedImageRectHeight() {
        return XrViewConfigurationView.nrecommendedImageRectHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageRectHeight() {
        return XrViewConfigurationView.nmaxImageRectHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int recommendedSwapchainSampleCount() {
        return XrViewConfigurationView.nrecommendedSwapchainSampleCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxSwapchainSampleCount() {
        return XrViewConfigurationView.nmaxSwapchainSampleCount(this.address());
    }

    public XrViewConfigurationView type(@NativeType(value="XrStructureType") int value) {
        XrViewConfigurationView.ntype(this.address(), value);
        return this;
    }

    public XrViewConfigurationView type$Default() {
        return this.type(41);
    }

    public XrViewConfigurationView next(@NativeType(value="void *") long value) {
        XrViewConfigurationView.nnext(this.address(), value);
        return this;
    }

    public XrViewConfigurationView next(XrFoveatedViewConfigurationViewVARJO value) {
        return this.next(value.next(this.next()).address());
    }

    public XrViewConfigurationView next(XrViewConfigurationDepthRangeEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrViewConfigurationView next(XrViewConfigurationViewFovEPIC value) {
        return this.next(value.next(this.next()).address());
    }

    public XrViewConfigurationView recommendedImageRectWidth(@NativeType(value="uint32_t") int value) {
        XrViewConfigurationView.nrecommendedImageRectWidth(this.address(), value);
        return this;
    }

    public XrViewConfigurationView maxImageRectWidth(@NativeType(value="uint32_t") int value) {
        XrViewConfigurationView.nmaxImageRectWidth(this.address(), value);
        return this;
    }

    public XrViewConfigurationView recommendedImageRectHeight(@NativeType(value="uint32_t") int value) {
        XrViewConfigurationView.nrecommendedImageRectHeight(this.address(), value);
        return this;
    }

    public XrViewConfigurationView maxImageRectHeight(@NativeType(value="uint32_t") int value) {
        XrViewConfigurationView.nmaxImageRectHeight(this.address(), value);
        return this;
    }

    public XrViewConfigurationView recommendedSwapchainSampleCount(@NativeType(value="uint32_t") int value) {
        XrViewConfigurationView.nrecommendedSwapchainSampleCount(this.address(), value);
        return this;
    }

    public XrViewConfigurationView maxSwapchainSampleCount(@NativeType(value="uint32_t") int value) {
        XrViewConfigurationView.nmaxSwapchainSampleCount(this.address(), value);
        return this;
    }

    public XrViewConfigurationView set(int type, long next, int recommendedImageRectWidth, int maxImageRectWidth, int recommendedImageRectHeight, int maxImageRectHeight, int recommendedSwapchainSampleCount, int maxSwapchainSampleCount) {
        this.type(type);
        this.next(next);
        this.recommendedImageRectWidth(recommendedImageRectWidth);
        this.maxImageRectWidth(maxImageRectWidth);
        this.recommendedImageRectHeight(recommendedImageRectHeight);
        this.maxImageRectHeight(maxImageRectHeight);
        this.recommendedSwapchainSampleCount(recommendedSwapchainSampleCount);
        this.maxSwapchainSampleCount(maxSwapchainSampleCount);
        return this;
    }

    public XrViewConfigurationView set(XrViewConfigurationView src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViewConfigurationView malloc() {
        return new XrViewConfigurationView(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrViewConfigurationView calloc() {
        return new XrViewConfigurationView(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrViewConfigurationView create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrViewConfigurationView(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrViewConfigurationView create(long address) {
        return new XrViewConfigurationView(address, null);
    }

    @Nullable
    public static XrViewConfigurationView createSafe(long address) {
        return address == 0L ? null : new XrViewConfigurationView(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrViewConfigurationView.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewConfigurationView.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrViewConfigurationView malloc(MemoryStack stack) {
        return new XrViewConfigurationView(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrViewConfigurationView calloc(MemoryStack stack) {
        return new XrViewConfigurationView(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nrecommendedImageRectWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)RECOMMENDEDIMAGERECTWIDTH);
    }

    public static int nmaxImageRectWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGERECTWIDTH);
    }

    public static int nrecommendedImageRectHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)RECOMMENDEDIMAGERECTHEIGHT);
    }

    public static int nmaxImageRectHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGERECTHEIGHT);
    }

    public static int nrecommendedSwapchainSampleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)RECOMMENDEDSWAPCHAINSAMPLECOUNT);
    }

    public static int nmaxSwapchainSampleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXSWAPCHAINSAMPLECOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nrecommendedImageRectWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RECOMMENDEDIMAGERECTWIDTH, value);
    }

    public static void nmaxImageRectWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXIMAGERECTWIDTH, value);
    }

    public static void nrecommendedImageRectHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RECOMMENDEDIMAGERECTHEIGHT, value);
    }

    public static void nmaxImageRectHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXIMAGERECTHEIGHT, value);
    }

    public static void nrecommendedSwapchainSampleCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RECOMMENDEDSWAPCHAINSAMPLECOUNT, value);
    }

    public static void nmaxSwapchainSampleCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXSWAPCHAINSAMPLECOUNT, value);
    }

    static {
        Struct.Layout layout = XrViewConfigurationView.__struct((Struct.Member[])new Struct.Member[]{XrViewConfigurationView.__member((int)4), XrViewConfigurationView.__member((int)POINTER_SIZE), XrViewConfigurationView.__member((int)4), XrViewConfigurationView.__member((int)4), XrViewConfigurationView.__member((int)4), XrViewConfigurationView.__member((int)4), XrViewConfigurationView.__member((int)4), XrViewConfigurationView.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RECOMMENDEDIMAGERECTWIDTH = layout.offsetof(2);
        MAXIMAGERECTWIDTH = layout.offsetof(3);
        RECOMMENDEDIMAGERECTHEIGHT = layout.offsetof(4);
        MAXIMAGERECTHEIGHT = layout.offsetof(5);
        RECOMMENDEDSWAPCHAINSAMPLECOUNT = layout.offsetof(6);
        MAXSWAPCHAINSAMPLECOUNT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrViewConfigurationView, Buffer>
    implements NativeResource {
        private static final XrViewConfigurationView ELEMENT_FACTORY = XrViewConfigurationView.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrViewConfigurationView getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewConfigurationView.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViewConfigurationView.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int recommendedImageRectWidth() {
            return XrViewConfigurationView.nrecommendedImageRectWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageRectWidth() {
            return XrViewConfigurationView.nmaxImageRectWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int recommendedImageRectHeight() {
            return XrViewConfigurationView.nrecommendedImageRectHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageRectHeight() {
            return XrViewConfigurationView.nmaxImageRectHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int recommendedSwapchainSampleCount() {
            return XrViewConfigurationView.nrecommendedSwapchainSampleCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxSwapchainSampleCount() {
            return XrViewConfigurationView.nmaxSwapchainSampleCount(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewConfigurationView.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(41);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViewConfigurationView.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrFoveatedViewConfigurationViewVARJO value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrViewConfigurationDepthRangeEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrViewConfigurationViewFovEPIC value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer recommendedImageRectWidth(@NativeType(value="uint32_t") int value) {
            XrViewConfigurationView.nrecommendedImageRectWidth(this.address(), value);
            return this;
        }

        public Buffer maxImageRectWidth(@NativeType(value="uint32_t") int value) {
            XrViewConfigurationView.nmaxImageRectWidth(this.address(), value);
            return this;
        }

        public Buffer recommendedImageRectHeight(@NativeType(value="uint32_t") int value) {
            XrViewConfigurationView.nrecommendedImageRectHeight(this.address(), value);
            return this;
        }

        public Buffer maxImageRectHeight(@NativeType(value="uint32_t") int value) {
            XrViewConfigurationView.nmaxImageRectHeight(this.address(), value);
            return this;
        }

        public Buffer recommendedSwapchainSampleCount(@NativeType(value="uint32_t") int value) {
            XrViewConfigurationView.nrecommendedSwapchainSampleCount(this.address(), value);
            return this;
        }

        public Buffer maxSwapchainSampleCount(@NativeType(value="uint32_t") int value) {
            XrViewConfigurationView.nmaxSwapchainSampleCount(this.address(), value);
            return this;
        }
    }
}

