/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewConfigurationViewFovEPIC
extends Struct<XrViewConfigurationViewFovEPIC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RECOMMENDEDFOV;
    public static final int MAXMUTABLEFOV;

    protected XrViewConfigurationViewFovEPIC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrViewConfigurationViewFovEPIC create(long address, @Nullable ByteBuffer container) {
        return new XrViewConfigurationViewFovEPIC(address, container);
    }

    public XrViewConfigurationViewFovEPIC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViewConfigurationViewFovEPIC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewConfigurationViewFovEPIC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrViewConfigurationViewFovEPIC.nnext(this.address());
    }

    public XrFovf recommendedFov() {
        return XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address());
    }

    public XrFovf maxMutableFov() {
        return XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address());
    }

    public XrViewConfigurationViewFovEPIC type(@NativeType(value="XrStructureType") int value) {
        XrViewConfigurationViewFovEPIC.ntype(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC type$Default() {
        return this.type(1000059000);
    }

    public XrViewConfigurationViewFovEPIC next(@NativeType(value="void const *") long value) {
        XrViewConfigurationViewFovEPIC.nnext(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC recommendedFov(XrFovf value) {
        XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC recommendedFov(Consumer<XrFovf> consumer) {
        consumer.accept(this.recommendedFov());
        return this;
    }

    public XrViewConfigurationViewFovEPIC maxMutableFov(XrFovf value) {
        XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address(), value);
        return this;
    }

    public XrViewConfigurationViewFovEPIC maxMutableFov(Consumer<XrFovf> consumer) {
        consumer.accept(this.maxMutableFov());
        return this;
    }

    public XrViewConfigurationViewFovEPIC set(int type, long next, XrFovf recommendedFov, XrFovf maxMutableFov) {
        this.type(type);
        this.next(next);
        this.recommendedFov(recommendedFov);
        this.maxMutableFov(maxMutableFov);
        return this;
    }

    public XrViewConfigurationViewFovEPIC set(XrViewConfigurationViewFovEPIC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViewConfigurationViewFovEPIC malloc() {
        return new XrViewConfigurationViewFovEPIC(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrViewConfigurationViewFovEPIC calloc() {
        return new XrViewConfigurationViewFovEPIC(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrViewConfigurationViewFovEPIC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrViewConfigurationViewFovEPIC(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrViewConfigurationViewFovEPIC create(long address) {
        return new XrViewConfigurationViewFovEPIC(address, null);
    }

    @Nullable
    public static XrViewConfigurationViewFovEPIC createSafe(long address) {
        return address == 0L ? null : new XrViewConfigurationViewFovEPIC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrViewConfigurationViewFovEPIC.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewConfigurationViewFovEPIC.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrViewConfigurationViewFovEPIC malloc(MemoryStack stack) {
        return new XrViewConfigurationViewFovEPIC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrViewConfigurationViewFovEPIC calloc(MemoryStack stack) {
        return new XrViewConfigurationViewFovEPIC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrFovf nrecommendedFov(long struct) {
        return XrFovf.create(struct + (long)RECOMMENDEDFOV);
    }

    public static XrFovf nmaxMutableFov(long struct) {
        return XrFovf.create(struct + (long)MAXMUTABLEFOV);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nrecommendedFov(long struct, XrFovf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RECOMMENDEDFOV), (long)XrFovf.SIZEOF);
    }

    public static void nmaxMutableFov(long struct, XrFovf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MAXMUTABLEFOV), (long)XrFovf.SIZEOF);
    }

    static {
        Struct.Layout layout = XrViewConfigurationViewFovEPIC.__struct((Struct.Member[])new Struct.Member[]{XrViewConfigurationViewFovEPIC.__member((int)4), XrViewConfigurationViewFovEPIC.__member((int)POINTER_SIZE), XrViewConfigurationViewFovEPIC.__member((int)XrFovf.SIZEOF, (int)XrFovf.ALIGNOF), XrViewConfigurationViewFovEPIC.__member((int)XrFovf.SIZEOF, (int)XrFovf.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RECOMMENDEDFOV = layout.offsetof(2);
        MAXMUTABLEFOV = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrViewConfigurationViewFovEPIC, Buffer>
    implements NativeResource {
        private static final XrViewConfigurationViewFovEPIC ELEMENT_FACTORY = XrViewConfigurationViewFovEPIC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrViewConfigurationViewFovEPIC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewConfigurationViewFovEPIC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrViewConfigurationViewFovEPIC.nnext(this.address());
        }

        public XrFovf recommendedFov() {
            return XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address());
        }

        public XrFovf maxMutableFov() {
            return XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewConfigurationViewFovEPIC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000059000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrViewConfigurationViewFovEPIC.nnext(this.address(), value);
            return this;
        }

        public Buffer recommendedFov(XrFovf value) {
            XrViewConfigurationViewFovEPIC.nrecommendedFov(this.address(), value);
            return this;
        }

        public Buffer recommendedFov(Consumer<XrFovf> consumer) {
            consumer.accept(this.recommendedFov());
            return this;
        }

        public Buffer maxMutableFov(XrFovf value) {
            XrViewConfigurationViewFovEPIC.nmaxMutableFov(this.address(), value);
            return this;
        }

        public Buffer maxMutableFov(Consumer<XrFovf> consumer) {
            consumer.accept(this.maxMutableFov());
            return this;
        }
    }
}

