/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrViewLocateFoveatedRenderingVARJO;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewLocateInfo
extends Struct<XrViewLocateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VIEWCONFIGURATIONTYPE;
    public static final int DISPLAYTIME;
    public static final int SPACE;

    protected XrViewLocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrViewLocateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrViewLocateInfo(address, container);
    }

    public XrViewLocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViewLocateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewLocateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrViewLocateInfo.nnext(this.address());
    }

    @NativeType(value="XrViewConfigurationType")
    public int viewConfigurationType() {
        return XrViewLocateInfo.nviewConfigurationType(this.address());
    }

    @NativeType(value="XrTime")
    public long displayTime() {
        return XrViewLocateInfo.ndisplayTime(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrViewLocateInfo.nspace(this.address());
    }

    public XrViewLocateInfo type(@NativeType(value="XrStructureType") int value) {
        XrViewLocateInfo.ntype(this.address(), value);
        return this;
    }

    public XrViewLocateInfo type$Default() {
        return this.type(6);
    }

    public XrViewLocateInfo next(@NativeType(value="void const *") long value) {
        XrViewLocateInfo.nnext(this.address(), value);
        return this;
    }

    public XrViewLocateInfo next(XrViewLocateFoveatedRenderingVARJO value) {
        return this.next(value.next(this.next()).address());
    }

    public XrViewLocateInfo viewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
        XrViewLocateInfo.nviewConfigurationType(this.address(), value);
        return this;
    }

    public XrViewLocateInfo displayTime(@NativeType(value="XrTime") long value) {
        XrViewLocateInfo.ndisplayTime(this.address(), value);
        return this;
    }

    public XrViewLocateInfo space(XrSpace value) {
        XrViewLocateInfo.nspace(this.address(), value);
        return this;
    }

    public XrViewLocateInfo set(int type, long next, int viewConfigurationType, long displayTime, XrSpace space) {
        this.type(type);
        this.next(next);
        this.viewConfigurationType(viewConfigurationType);
        this.displayTime(displayTime);
        this.space(space);
        return this;
    }

    public XrViewLocateInfo set(XrViewLocateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViewLocateInfo malloc() {
        return new XrViewLocateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrViewLocateInfo calloc() {
        return new XrViewLocateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrViewLocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrViewLocateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrViewLocateInfo create(long address) {
        return new XrViewLocateInfo(address, null);
    }

    @Nullable
    public static XrViewLocateInfo createSafe(long address) {
        return address == 0L ? null : new XrViewLocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrViewLocateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewLocateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrViewLocateInfo malloc(MemoryStack stack) {
        return new XrViewLocateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrViewLocateInfo calloc(MemoryStack stack) {
        return new XrViewLocateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nviewConfigurationType(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWCONFIGURATIONTYPE);
    }

    public static long ndisplayTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)DISPLAYTIME);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nviewConfigurationType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWCONFIGURATIONTYPE, value);
    }

    public static void ndisplayTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DISPLAYTIME, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrViewLocateInfo.__struct((Struct.Member[])new Struct.Member[]{XrViewLocateInfo.__member((int)4), XrViewLocateInfo.__member((int)POINTER_SIZE), XrViewLocateInfo.__member((int)4), XrViewLocateInfo.__member((int)8), XrViewLocateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VIEWCONFIGURATIONTYPE = layout.offsetof(2);
        DISPLAYTIME = layout.offsetof(3);
        SPACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrViewLocateInfo, Buffer>
    implements NativeResource {
        private static final XrViewLocateInfo ELEMENT_FACTORY = XrViewLocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrViewLocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewLocateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrViewLocateInfo.nnext(this.address());
        }

        @NativeType(value="XrViewConfigurationType")
        public int viewConfigurationType() {
            return XrViewLocateInfo.nviewConfigurationType(this.address());
        }

        @NativeType(value="XrTime")
        public long displayTime() {
            return XrViewLocateInfo.ndisplayTime(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrViewLocateInfo.nspace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewLocateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(6);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrViewLocateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrViewLocateFoveatedRenderingVARJO value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer viewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
            XrViewLocateInfo.nviewConfigurationType(this.address(), value);
            return this;
        }

        public Buffer displayTime(@NativeType(value="XrTime") long value) {
            XrViewLocateInfo.ndisplayTime(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrViewLocateInfo.nspace(this.address(), value);
            return this;
        }
    }
}

