/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVirtualKeyboardTextureDataMETA
extends Struct<XrVirtualKeyboardTextureDataMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int TEXTUREWIDTH;
    public static final int TEXTUREHEIGHT;
    public static final int BUFFERCAPACITYINPUT;
    public static final int BUFFERCOUNTOUTPUT;
    public static final int BUFFER;

    protected XrVirtualKeyboardTextureDataMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrVirtualKeyboardTextureDataMETA create(long address, @Nullable ByteBuffer container) {
        return new XrVirtualKeyboardTextureDataMETA(address, container);
    }

    public XrVirtualKeyboardTextureDataMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrVirtualKeyboardTextureDataMETA.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVirtualKeyboardTextureDataMETA.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrVirtualKeyboardTextureDataMETA.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int textureWidth() {
        return XrVirtualKeyboardTextureDataMETA.ntextureWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int textureHeight() {
        return XrVirtualKeyboardTextureDataMETA.ntextureHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCapacityInput() {
        return XrVirtualKeyboardTextureDataMETA.nbufferCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCountOutput() {
        return XrVirtualKeyboardTextureDataMETA.nbufferCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="uint8_t *")
    public ByteBuffer buffer() {
        return XrVirtualKeyboardTextureDataMETA.nbuffer(this.address());
    }

    public XrVirtualKeyboardTextureDataMETA type(@NativeType(value="XrStructureType") int value) {
        XrVirtualKeyboardTextureDataMETA.ntype(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA type$Default() {
        return this.type(1000219009);
    }

    public XrVirtualKeyboardTextureDataMETA next(@NativeType(value="void *") long value) {
        XrVirtualKeyboardTextureDataMETA.nnext(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA textureWidth(@NativeType(value="uint32_t") int value) {
        XrVirtualKeyboardTextureDataMETA.ntextureWidth(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA textureHeight(@NativeType(value="uint32_t") int value) {
        XrVirtualKeyboardTextureDataMETA.ntextureHeight(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA bufferCapacityInput(@NativeType(value="uint32_t") int value) {
        XrVirtualKeyboardTextureDataMETA.nbufferCapacityInput(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA bufferCountOutput(@NativeType(value="uint32_t") int value) {
        XrVirtualKeyboardTextureDataMETA.nbufferCountOutput(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA buffer(@Nullable @NativeType(value="uint8_t *") ByteBuffer value) {
        XrVirtualKeyboardTextureDataMETA.nbuffer(this.address(), value);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA set(int type, long next, int textureWidth, int textureHeight, int bufferCapacityInput, int bufferCountOutput, @Nullable ByteBuffer buffer) {
        this.type(type);
        this.next(next);
        this.textureWidth(textureWidth);
        this.textureHeight(textureHeight);
        this.bufferCapacityInput(bufferCapacityInput);
        this.bufferCountOutput(bufferCountOutput);
        this.buffer(buffer);
        return this;
    }

    public XrVirtualKeyboardTextureDataMETA set(XrVirtualKeyboardTextureDataMETA src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrVirtualKeyboardTextureDataMETA malloc() {
        return new XrVirtualKeyboardTextureDataMETA(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrVirtualKeyboardTextureDataMETA calloc() {
        return new XrVirtualKeyboardTextureDataMETA(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrVirtualKeyboardTextureDataMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrVirtualKeyboardTextureDataMETA(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrVirtualKeyboardTextureDataMETA create(long address) {
        return new XrVirtualKeyboardTextureDataMETA(address, null);
    }

    @Nullable
    public static XrVirtualKeyboardTextureDataMETA createSafe(long address) {
        return address == 0L ? null : new XrVirtualKeyboardTextureDataMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrVirtualKeyboardTextureDataMETA.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVirtualKeyboardTextureDataMETA.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVirtualKeyboardTextureDataMETA malloc(MemoryStack stack) {
        return new XrVirtualKeyboardTextureDataMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVirtualKeyboardTextureDataMETA calloc(MemoryStack stack) {
        return new XrVirtualKeyboardTextureDataMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int ntextureWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTUREWIDTH);
    }

    public static int ntextureHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEXTUREHEIGHT);
    }

    public static int nbufferCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERCAPACITYINPUT);
    }

    public static int nbufferCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERCOUNTOUTPUT);
    }

    @Nullable
    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)XrVirtualKeyboardTextureDataMETA.nbufferCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ntextureWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TEXTUREWIDTH, value);
    }

    public static void ntextureHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TEXTUREHEIGHT, value);
    }

    public static void nbufferCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERCAPACITYINPUT, value);
    }

    public static void nbufferCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERCOUNTOUTPUT, value);
    }

    public static void nbuffer(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        if (value != null) {
            XrVirtualKeyboardTextureDataMETA.nbufferCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrVirtualKeyboardTextureDataMETA.__struct((Struct.Member[])new Struct.Member[]{XrVirtualKeyboardTextureDataMETA.__member((int)4), XrVirtualKeyboardTextureDataMETA.__member((int)POINTER_SIZE), XrVirtualKeyboardTextureDataMETA.__member((int)4), XrVirtualKeyboardTextureDataMETA.__member((int)4), XrVirtualKeyboardTextureDataMETA.__member((int)4), XrVirtualKeyboardTextureDataMETA.__member((int)4), XrVirtualKeyboardTextureDataMETA.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        TEXTUREWIDTH = layout.offsetof(2);
        TEXTUREHEIGHT = layout.offsetof(3);
        BUFFERCAPACITYINPUT = layout.offsetof(4);
        BUFFERCOUNTOUTPUT = layout.offsetof(5);
        BUFFER = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrVirtualKeyboardTextureDataMETA, Buffer>
    implements NativeResource {
        private static final XrVirtualKeyboardTextureDataMETA ELEMENT_FACTORY = XrVirtualKeyboardTextureDataMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrVirtualKeyboardTextureDataMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVirtualKeyboardTextureDataMETA.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrVirtualKeyboardTextureDataMETA.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int textureWidth() {
            return XrVirtualKeyboardTextureDataMETA.ntextureWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int textureHeight() {
            return XrVirtualKeyboardTextureDataMETA.ntextureHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCapacityInput() {
            return XrVirtualKeyboardTextureDataMETA.nbufferCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCountOutput() {
            return XrVirtualKeyboardTextureDataMETA.nbufferCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="uint8_t *")
        public ByteBuffer buffer() {
            return XrVirtualKeyboardTextureDataMETA.nbuffer(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVirtualKeyboardTextureDataMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000219009);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrVirtualKeyboardTextureDataMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer textureWidth(@NativeType(value="uint32_t") int value) {
            XrVirtualKeyboardTextureDataMETA.ntextureWidth(this.address(), value);
            return this;
        }

        public Buffer textureHeight(@NativeType(value="uint32_t") int value) {
            XrVirtualKeyboardTextureDataMETA.ntextureHeight(this.address(), value);
            return this;
        }

        public Buffer bufferCapacityInput(@NativeType(value="uint32_t") int value) {
            XrVirtualKeyboardTextureDataMETA.nbufferCapacityInput(this.address(), value);
            return this;
        }

        public Buffer bufferCountOutput(@NativeType(value="uint32_t") int value) {
            XrVirtualKeyboardTextureDataMETA.nbufferCountOutput(this.address(), value);
            return this;
        }

        public Buffer buffer(@Nullable @NativeType(value="uint8_t *") ByteBuffer value) {
            XrVirtualKeyboardTextureDataMETA.nbuffer(this.address(), value);
            return this;
        }
    }
}

