/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViveTrackerPathsHTCX
extends Struct<XrViveTrackerPathsHTCX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PERSISTENTPATH;
    public static final int ROLEPATH;

    protected XrViveTrackerPathsHTCX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrViveTrackerPathsHTCX create(long address, @Nullable ByteBuffer container) {
        return new XrViveTrackerPathsHTCX(address, container);
    }

    public XrViveTrackerPathsHTCX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViveTrackerPathsHTCX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViveTrackerPathsHTCX.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViveTrackerPathsHTCX.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long persistentPath() {
        return XrViveTrackerPathsHTCX.npersistentPath(this.address());
    }

    @NativeType(value="XrPath")
    public long rolePath() {
        return XrViveTrackerPathsHTCX.nrolePath(this.address());
    }

    public XrViveTrackerPathsHTCX type(@NativeType(value="XrStructureType") int value) {
        XrViveTrackerPathsHTCX.ntype(this.address(), value);
        return this;
    }

    public XrViveTrackerPathsHTCX type$Default() {
        return this.type(1000103000);
    }

    public XrViveTrackerPathsHTCX next(@NativeType(value="void *") long value) {
        XrViveTrackerPathsHTCX.nnext(this.address(), value);
        return this;
    }

    public XrViveTrackerPathsHTCX set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrViveTrackerPathsHTCX set(XrViveTrackerPathsHTCX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViveTrackerPathsHTCX malloc() {
        return new XrViveTrackerPathsHTCX(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrViveTrackerPathsHTCX calloc() {
        return new XrViveTrackerPathsHTCX(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrViveTrackerPathsHTCX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrViveTrackerPathsHTCX(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrViveTrackerPathsHTCX create(long address) {
        return new XrViveTrackerPathsHTCX(address, null);
    }

    @Nullable
    public static XrViveTrackerPathsHTCX createSafe(long address) {
        return address == 0L ? null : new XrViveTrackerPathsHTCX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrViveTrackerPathsHTCX.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViveTrackerPathsHTCX.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrViveTrackerPathsHTCX malloc(MemoryStack stack) {
        return new XrViveTrackerPathsHTCX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrViveTrackerPathsHTCX calloc(MemoryStack stack) {
        return new XrViveTrackerPathsHTCX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long npersistentPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)PERSISTENTPATH);
    }

    public static long nrolePath(long struct) {
        return UNSAFE.getLong(null, struct + (long)ROLEPATH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrViveTrackerPathsHTCX.__struct((Struct.Member[])new Struct.Member[]{XrViveTrackerPathsHTCX.__member((int)4), XrViveTrackerPathsHTCX.__member((int)POINTER_SIZE), XrViveTrackerPathsHTCX.__member((int)8), XrViveTrackerPathsHTCX.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PERSISTENTPATH = layout.offsetof(2);
        ROLEPATH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrViveTrackerPathsHTCX, Buffer>
    implements NativeResource {
        private static final XrViveTrackerPathsHTCX ELEMENT_FACTORY = XrViveTrackerPathsHTCX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrViveTrackerPathsHTCX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViveTrackerPathsHTCX.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViveTrackerPathsHTCX.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long persistentPath() {
            return XrViveTrackerPathsHTCX.npersistentPath(this.address());
        }

        @NativeType(value="XrPath")
        public long rolePath() {
            return XrViveTrackerPathsHTCX.nrolePath(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViveTrackerPathsHTCX.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000103000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViveTrackerPathsHTCX.nnext(this.address(), value);
            return this;
        }
    }
}

