/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

class ComponentOperationHandler {
    private BooleanInformer delayed;
    private ComponentOperationPool operationPool = new ComponentOperationPool();
    private Array<ComponentOperation> operations = new Array();

    public ComponentOperationHandler(BooleanInformer delayed) {
        this.delayed = delayed;
    }

    public void add(Entity entity) {
        if (this.delayed.value()) {
            ComponentOperation operation = (ComponentOperation)this.operationPool.obtain();
            operation.makeAdd(entity);
            this.operations.add((Object)operation);
        } else {
            entity.notifyComponentAdded();
        }
    }

    public void remove(Entity entity) {
        if (this.delayed.value()) {
            ComponentOperation operation = (ComponentOperation)this.operationPool.obtain();
            operation.makeRemove(entity);
            this.operations.add((Object)operation);
        } else {
            entity.notifyComponentRemoved();
        }
    }

    public boolean hasOperationsToProcess() {
        return this.operations.size > 0;
    }

    public void processOperations() {
        for (int i = 0; i < this.operations.size; ++i) {
            ComponentOperation operation = (ComponentOperation)this.operations.get(i);
            switch (operation.type) {
                case Add: {
                    operation.entity.notifyComponentAdded();
                    break;
                }
                case Remove: {
                    operation.entity.notifyComponentRemoved();
                    break;
                }
            }
            this.operationPool.free(operation);
        }
        this.operations.clear();
    }

    static interface BooleanInformer {
        public boolean value();
    }

    private static class ComponentOperationPool
    extends Pool<ComponentOperation> {
        private ComponentOperationPool() {
        }

        protected ComponentOperation newObject() {
            return new ComponentOperation();
        }
    }

    private static class ComponentOperation
    implements Pool.Poolable {
        public Type type;
        public Entity entity;

        private ComponentOperation() {
        }

        public void makeAdd(Entity entity) {
            this.type = Type.Add;
            this.entity = entity;
        }

        public void makeRemove(Entity entity) {
            this.type = Type.Remove;
            this.entity = entity;
        }

        public void reset() {
            this.entity = null;
        }

        public static enum Type {
            Add,
            Remove;

        }
    }
}

