/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.Pool;

class EntityManager {
    private EntityListener listener;
    private Array<Entity> entities = new Array(false, 16);
    private ObjectSet<Entity> entitySet = new ObjectSet();
    private ImmutableArray<Entity> immutableEntities = new ImmutableArray<Entity>(this.entities);
    private Array<EntityOperation> pendingOperations = new Array(false, 16);
    private EntityOperationPool entityOperationPool = new EntityOperationPool();

    public EntityManager(EntityListener listener) {
        this.listener = listener;
    }

    public void addEntity(Entity entity) {
        this.addEntity(entity, false);
    }

    public void addEntity(Entity entity, boolean delayed) {
        if (delayed) {
            EntityOperation operation = (EntityOperation)this.entityOperationPool.obtain();
            operation.entity = entity;
            operation.type = EntityOperation.Type.Add;
            this.pendingOperations.add((Object)operation);
        } else {
            this.addEntityInternal(entity);
        }
    }

    public void removeEntity(Entity entity) {
        this.removeEntity(entity, false);
    }

    public void removeEntity(Entity entity, boolean delayed) {
        if (delayed) {
            if (entity.scheduledForRemoval) {
                return;
            }
            entity.scheduledForRemoval = true;
            EntityOperation operation = (EntityOperation)this.entityOperationPool.obtain();
            operation.entity = entity;
            operation.type = EntityOperation.Type.Remove;
            this.pendingOperations.add((Object)operation);
        } else {
            this.removeEntityInternal(entity);
        }
    }

    public void removeAllEntities() {
        this.removeAllEntities(this.immutableEntities);
    }

    public void removeAllEntities(boolean delayed) {
        this.removeAllEntities(this.immutableEntities, delayed);
    }

    public void removeAllEntities(ImmutableArray<Entity> entities) {
        this.removeAllEntities(entities, false);
    }

    public void removeAllEntities(ImmutableArray<Entity> entities, boolean delayed) {
        if (delayed) {
            for (Entity entity : entities) {
                entity.scheduledForRemoval = true;
            }
            EntityOperation operation = (EntityOperation)this.entityOperationPool.obtain();
            operation.type = EntityOperation.Type.RemoveAll;
            operation.entities = entities;
            this.pendingOperations.add((Object)operation);
        } else {
            while (entities.size() > 0) {
                this.removeEntity(entities.first(), false);
            }
        }
    }

    public ImmutableArray<Entity> getEntities() {
        return this.immutableEntities;
    }

    public boolean hasPendingOperations() {
        return this.pendingOperations.size > 0;
    }

    public void processPendingOperations() {
        for (int i = 0; i < this.pendingOperations.size; ++i) {
            EntityOperation operation = (EntityOperation)this.pendingOperations.get(i);
            switch (operation.type) {
                case Add: {
                    this.addEntityInternal(operation.entity);
                    break;
                }
                case Remove: {
                    this.removeEntityInternal(operation.entity);
                    break;
                }
                case RemoveAll: {
                    while (operation.entities.size() > 0) {
                        this.removeEntityInternal(operation.entities.first());
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected EntityOperation type");
                }
            }
            this.entityOperationPool.free(operation);
        }
        this.pendingOperations.clear();
    }

    protected void removeEntityInternal(Entity entity) {
        boolean removed = this.entitySet.remove((Object)entity);
        if (removed) {
            entity.scheduledForRemoval = false;
            entity.removing = true;
            this.entities.removeValue((Object)entity, true);
            this.listener.entityRemoved(entity);
            entity.removing = false;
        }
    }

    protected void addEntityInternal(Entity entity) {
        if (this.entitySet.contains((Object)entity)) {
            throw new IllegalArgumentException("Entity is already registered " + entity);
        }
        this.entities.add((Object)entity);
        this.entitySet.add((Object)entity);
        this.listener.entityAdded(entity);
    }

    private static class EntityOperationPool
    extends Pool<EntityOperation> {
        private EntityOperationPool() {
        }

        protected EntityOperation newObject() {
            return new EntityOperation();
        }
    }

    private static class EntityOperation
    implements Pool.Poolable {
        public Type type;
        public Entity entity;
        public ImmutableArray<Entity> entities;

        private EntityOperation() {
        }

        public void reset() {
            this.entity = null;
        }

        public static enum Type {
            Add,
            Remove,
            RemoveAll;

        }
    }
}

