/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Bits;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SnapshotArray;

class FamilyManager {
    ImmutableArray<Entity> entities;
    private ObjectMap<Family, Array<Entity>> families = new ObjectMap();
    private ObjectMap<Family, ImmutableArray<Entity>> immutableFamilies = new ObjectMap();
    private SnapshotArray<EntityListenerData> entityListeners = new SnapshotArray(true, 16);
    private ObjectMap<Family, Bits> entityListenerMasks = new ObjectMap();
    private BitsPool bitsPool = new BitsPool();
    private boolean notifying = false;

    public FamilyManager(ImmutableArray<Entity> entities) {
        this.entities = entities;
    }

    public ImmutableArray<Entity> getEntitiesFor(Family family) {
        return this.registerFamily(family);
    }

    public boolean notifying() {
        return this.notifying;
    }

    public void addEntityListener(Family family, int priority, EntityListener listener) {
        int insertionIndex;
        this.registerFamily(family);
        for (insertionIndex = 0; insertionIndex < this.entityListeners.size && ((EntityListenerData)this.entityListeners.get((int)insertionIndex)).priority <= priority; ++insertionIndex) {
        }
        for (Bits mask : this.entityListenerMasks.values()) {
            for (int k = mask.length(); k > insertionIndex; --k) {
                if (mask.get(k - 1)) {
                    mask.set(k);
                    continue;
                }
                mask.clear(k);
            }
            mask.clear(insertionIndex);
        }
        ((Bits)this.entityListenerMasks.get((Object)family)).set(insertionIndex);
        EntityListenerData entityListenerData = new EntityListenerData();
        entityListenerData.listener = listener;
        entityListenerData.priority = priority;
        this.entityListeners.insert(insertionIndex, (Object)entityListenerData);
    }

    public void removeEntityListener(EntityListener listener) {
        for (int i = 0; i < this.entityListeners.size; ++i) {
            EntityListenerData entityListenerData = (EntityListenerData)this.entityListeners.get(i);
            if (entityListenerData.listener != listener) continue;
            for (Bits mask : this.entityListenerMasks.values()) {
                int n = mask.length();
                for (int k = i; k < n; ++k) {
                    if (mask.get(k + 1)) {
                        mask.set(k);
                        continue;
                    }
                    mask.clear(k);
                }
            }
            this.entityListeners.removeIndex(i--);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFamilyMembership(Entity entity) {
        Bits addListenerBits = (Bits)this.bitsPool.obtain();
        Bits removeListenerBits = (Bits)this.bitsPool.obtain();
        for (Family family : this.entityListenerMasks.keys()) {
            boolean matches;
            int familyIndex = family.getIndex();
            Bits entityFamilyBits = entity.getFamilyBits();
            boolean belongsToFamily = entityFamilyBits.get(familyIndex);
            if (belongsToFamily == (matches = family.matches(entity) && !entity.removing)) continue;
            Bits listenersMask = (Bits)this.entityListenerMasks.get((Object)family);
            Array familyEntities = (Array)this.families.get((Object)family);
            if (matches) {
                addListenerBits.or(listenersMask);
                familyEntities.add((Object)entity);
                entityFamilyBits.set(familyIndex);
                continue;
            }
            removeListenerBits.or(listenersMask);
            familyEntities.removeValue((Object)entity, true);
            entityFamilyBits.clear(familyIndex);
        }
        this.notifying = true;
        Object[] items = this.entityListeners.begin();
        try {
            int i = removeListenerBits.nextSetBit(0);
            while (i >= 0) {
                ((EntityListenerData)items[i]).listener.entityRemoved(entity);
                i = removeListenerBits.nextSetBit(i + 1);
            }
            i = addListenerBits.nextSetBit(0);
            while (i >= 0) {
                ((EntityListenerData)items[i]).listener.entityAdded(entity);
                i = addListenerBits.nextSetBit(i + 1);
            }
        }
        finally {
            addListenerBits.clear();
            removeListenerBits.clear();
            this.bitsPool.free(addListenerBits);
            this.bitsPool.free(removeListenerBits);
            this.entityListeners.end();
            this.notifying = false;
        }
    }

    private ImmutableArray<Entity> registerFamily(Family family) {
        ImmutableArray entitiesInFamily = (ImmutableArray)this.immutableFamilies.get((Object)family);
        if (entitiesInFamily == null) {
            Array familyEntities = new Array(false, 16);
            entitiesInFamily = new ImmutableArray(familyEntities);
            this.families.put((Object)family, (Object)familyEntities);
            this.immutableFamilies.put((Object)family, entitiesInFamily);
            this.entityListenerMasks.put((Object)family, (Object)new Bits());
            for (Entity entity : this.entities) {
                this.updateFamilyMembership(entity);
            }
        }
        return entitiesInFamily;
    }

    private static class BitsPool
    extends Pool<Bits> {
        private BitsPool() {
        }

        protected Bits newObject() {
            return new Bits();
        }
    }

    private static class EntityListenerData {
        public EntityListener listener;
        public int priority;

        private EntityListenerData() {
        }
    }
}

