/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.fbs.feather;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.ac.bristol.star.fbs.google.FlatBufferBuilder;
import uk.ac.bristol.star.fbs.google.Table;

public final class PrimitiveArray
extends Table {
    public static PrimitiveArray getRootAsPrimitiveArray(ByteBuffer byteBuffer) {
        return PrimitiveArray.getRootAsPrimitiveArray(byteBuffer, new PrimitiveArray());
    }

    public static PrimitiveArray getRootAsPrimitiveArray(ByteBuffer byteBuffer, PrimitiveArray primitiveArray) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return primitiveArray.__assign(byteBuffer.getInt(byteBuffer.position()) + byteBuffer.position(), byteBuffer);
    }

    public void __init(int n, ByteBuffer byteBuffer) {
        this.bb_pos = n;
        this.bb = byteBuffer;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public PrimitiveArray __assign(int n, ByteBuffer byteBuffer) {
        this.__init(n, byteBuffer);
        return this;
    }

    public byte type() {
        int n = this.__offset(4);
        return n != 0 ? this.bb.get(n + this.bb_pos) : (byte)0;
    }

    public byte encoding() {
        int n = this.__offset(6);
        return n != 0 ? this.bb.get(n + this.bb_pos) : (byte)0;
    }

    public long offset() {
        int n = this.__offset(8);
        return n != 0 ? this.bb.getLong(n + this.bb_pos) : 0L;
    }

    public long length() {
        int n = this.__offset(10);
        return n != 0 ? this.bb.getLong(n + this.bb_pos) : 0L;
    }

    public long nullCount() {
        int n = this.__offset(12);
        return n != 0 ? this.bb.getLong(n + this.bb_pos) : 0L;
    }

    public long totalBytes() {
        int n = this.__offset(14);
        return n != 0 ? this.bb.getLong(n + this.bb_pos) : 0L;
    }

    public static int createPrimitiveArray(FlatBufferBuilder flatBufferBuilder, byte by, byte by2, long l, long l2, long l3, long l4) {
        flatBufferBuilder.startObject(6);
        PrimitiveArray.addTotalBytes(flatBufferBuilder, l4);
        PrimitiveArray.addNullCount(flatBufferBuilder, l3);
        PrimitiveArray.addLength(flatBufferBuilder, l2);
        PrimitiveArray.addOffset(flatBufferBuilder, l);
        PrimitiveArray.addEncoding(flatBufferBuilder, by2);
        PrimitiveArray.addType(flatBufferBuilder, by);
        return PrimitiveArray.endPrimitiveArray(flatBufferBuilder);
    }

    public static void startPrimitiveArray(FlatBufferBuilder flatBufferBuilder) {
        flatBufferBuilder.startObject(6);
    }

    public static void addType(FlatBufferBuilder flatBufferBuilder, byte by) {
        flatBufferBuilder.addByte(0, by, 0);
    }

    public static void addEncoding(FlatBufferBuilder flatBufferBuilder, byte by) {
        flatBufferBuilder.addByte(1, by, 0);
    }

    public static void addOffset(FlatBufferBuilder flatBufferBuilder, long l) {
        flatBufferBuilder.addLong(2, l, 0L);
    }

    public static void addLength(FlatBufferBuilder flatBufferBuilder, long l) {
        flatBufferBuilder.addLong(3, l, 0L);
    }

    public static void addNullCount(FlatBufferBuilder flatBufferBuilder, long l) {
        flatBufferBuilder.addLong(4, l, 0L);
    }

    public static void addTotalBytes(FlatBufferBuilder flatBufferBuilder, long l) {
        flatBufferBuilder.addLong(5, l, 0L);
    }

    public static int endPrimitiveArray(FlatBufferBuilder flatBufferBuilder) {
        int n = flatBufferBuilder.endObject();
        return n;
    }
}

